/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ExportEnvironment;
import software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceExportTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateInstanceExportTaskRequest.getter(CreateInstanceExportTaskRequest::tagSpecifications)).setter(CreateInstanceExportTaskRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateInstanceExportTaskRequest.getter(CreateInstanceExportTaskRequest::description)).setter(CreateInstanceExportTaskRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateInstanceExportTaskRequest.getter(CreateInstanceExportTaskRequest::instanceId)).setter(CreateInstanceExportTaskRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> TARGET_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEnvironment").getter(CreateInstanceExportTaskRequest.getter(CreateInstanceExportTaskRequest::targetEnvironmentAsString)).setter(CreateInstanceExportTaskRequest.setter(Builder::targetEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEnvironment").unmarshallLocationName("targetEnvironment").build()}).build();
    private static final SdkField<ExportToS3TaskSpecification> EXPORT_TO_S3_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportToS3Task").getter(CreateInstanceExportTaskRequest.getter(CreateInstanceExportTaskRequest::exportToS3Task)).setter(CreateInstanceExportTaskRequest.setter(Builder::exportToS3Task)).constructor(ExportToS3TaskSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToS3").unmarshallLocationName("exportToS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SPECIFICATIONS_FIELD, DESCRIPTION_FIELD, INSTANCE_ID_FIELD, TARGET_ENVIRONMENT_FIELD, EXPORT_TO_S3_TASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInstanceExportTaskRequest.memberNameToFieldInitializer();
    private final List<TagSpecification> tagSpecifications;
    private final String description;
    private final String instanceId;
    private final String targetEnvironment;
    private final ExportToS3TaskSpecification exportToS3Task;

    private CreateInstanceExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.tagSpecifications = builder.tagSpecifications;
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
        this.exportToS3Task = builder.exportToS3Task;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String description() {
        return this.description;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(this.targetEnvironment);
    }

    public final String targetEnvironmentAsString() {
        return this.targetEnvironment;
    }

    public final ExportToS3TaskSpecification exportToS3Task() {
        return this.exportToS3Task;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToS3Task());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskRequest)) {
            return false;
        }
        CreateInstanceExportTaskRequest other = (CreateInstanceExportTaskRequest)((Object)obj);
        return this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.targetEnvironmentAsString(), other.targetEnvironmentAsString()) && Objects.equals(this.exportToS3Task(), other.exportToS3Task());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceExportTaskRequest").add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("Description", (Object)this.description()).add("InstanceId", (Object)this.instanceId()).add("TargetEnvironment", (Object)this.targetEnvironmentAsString()).add("ExportToS3Task", (Object)this.exportToS3Task()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "TargetEnvironment": {
                return Optional.ofNullable(clazz.cast(this.targetEnvironmentAsString()));
            }
            case "ExportToS3Task": {
                return Optional.ofNullable(clazz.cast(this.exportToS3Task()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("TargetEnvironment", TARGET_ENVIRONMENT_FIELD);
        map.put("ExportToS3", EXPORT_TO_S3_TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceExportTaskRequest, T> g) {
        return obj -> g.apply((CreateInstanceExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String instanceId;
        private String targetEnvironment;
        private ExportToS3TaskSpecification exportToS3Task;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskRequest model) {
            super(model);
            this.tagSpecifications(model.tagSpecifications);
            this.description(model.description);
            this.instanceId(model.instanceId);
            this.targetEnvironment(model.targetEnvironment);
            this.exportToS3Task(model.exportToS3Task);
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTargetEnvironment() {
            return this.targetEnvironment;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment == null ? null : targetEnvironment.toString());
            return this;
        }

        public final ExportToS3TaskSpecification.Builder getExportToS3Task() {
            return this.exportToS3Task != null ? this.exportToS3Task.toBuilder() : null;
        }

        public final void setExportToS3Task(ExportToS3TaskSpecification.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceExportTaskRequest build() {
            return new CreateInstanceExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder targetEnvironment(String var1);

        public Builder targetEnvironment(ExportEnvironment var1);

        public Builder exportToS3Task(ExportToS3TaskSpecification var1);

        default public Builder exportToS3Task(Consumer<ExportToS3TaskSpecification.Builder> exportToS3Task) {
            return this.exportToS3Task((ExportToS3TaskSpecification)((ExportToS3TaskSpecification.Builder)ExportToS3TaskSpecification.builder().applyMutation(exportToS3Task)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

