/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.apache;

import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.pipeline.apache.ApacheConfigSettings;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class Exports
implements Builder.Exports {
    @Override
    public void register(Builder.Registry registry) {
        registry.add(new Builder.Factory<ExecutorService>(){

            @Override
            public <S> ExecutorService create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                return Executors.newCachedThreadPool();
            }
        });
        registry.add(new Builder.Factory<ApacheConfigSettings>(){

            @Override
            public <S> ApacheConfigSettings create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                if (!ManagementConfiguration.isPlayback() && properties.containsKey("com.microsoft.windowsazure.Configuration.credentials")) {
                    CloudCredentials cloudCredentials = (CloudCredentials)properties.get("com.microsoft.windowsazure.Configuration.credentials");
                    cloudCredentials.applyConfig(profile, properties);
                }
                return new ApacheConfigSettings(profile, properties);
            }
        });
        registry.add(new Builder.Factory<HttpClientBuilder>(){

            @Override
            public <S> HttpClientBuilder create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                HttpClientBuilder httpClientBuilder = HttpClients.custom();
                ApacheConfigSettings settings = builder.build(profile, service, ApacheConfigSettings.class, properties);
                return settings.applyConfig(httpClientBuilder);
            }
        });
    }
}

