"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createSqlCluster;
var _sqlPlugin = _interopRequireDefault(require("./sqlPlugin"));
var _constants = require("../../services/utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createSqlCluster(server) {
  const {
    customHeaders,
    ...rest
  } = server.config().get('opensearch');
  server.plugins.opensearch.createCluster(_constants.CLUSTER.SQL, {
    plugins: [_sqlPlugin.default],
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc3FsUGx1Z2luIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfY29uc3RhbnRzIiwiZSIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwiY3JlYXRlU3FsQ2x1c3RlciIsInNlcnZlciIsImN1c3RvbUhlYWRlcnMiLCJyZXN0IiwiY29uZmlnIiwiZ2V0IiwicGx1Z2lucyIsIm9wZW5zZWFyY2giLCJjcmVhdGVDbHVzdGVyIiwiQ0xVU1RFUiIsIlNRTCIsInNxbFBsdWdpbiIsIkRFRkFVTFRfSEVBREVSUyIsIm1vZHVsZSIsImV4cG9ydHMiXSwic291cmNlcyI6WyJjcmVhdGVTcWxDbHVzdGVyLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuXG5pbXBvcnQgc3FsUGx1Z2luIGZyb20gJy4vc3FsUGx1Z2luJztcbmltcG9ydCB7IENMVVNURVIsIERFRkFVTFRfSEVBREVSUyB9IGZyb20gJy4uLy4uL3NlcnZpY2VzL3V0aWxzL2NvbnN0YW50cyc7XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNyZWF0ZVNxbENsdXN0ZXIoc2VydmVyKSB7XG4gIGNvbnN0IHsgY3VzdG9tSGVhZGVycywgLi4ucmVzdCB9ID0gc2VydmVyLmNvbmZpZygpLmdldCgnb3BlbnNlYXJjaCcpO1xuICBzZXJ2ZXIucGx1Z2lucy5vcGVuc2VhcmNoLmNyZWF0ZUNsdXN0ZXIoXG4gICAgQ0xVU1RFUi5TUUwsXG4gICAge1xuICAgICAgcGx1Z2luczogWyBzcWxQbHVnaW4gXSxcbiAgICAgIGN1c3RvbUhlYWRlcnM6IHsgLi4uY3VzdG9tSGVhZGVycywgLi4uREVGQVVMVF9IRUFERVJTIH0sXG4gICAgICAuLi5yZXN0LFxuICAgIH1cbiAgKTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsSUFBQUEsVUFBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQUMsVUFBQSxHQUFBRCxPQUFBO0FBQTBFLFNBQUFELHVCQUFBRyxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBQyxVQUFBLEdBQUFELENBQUEsS0FBQUUsT0FBQSxFQUFBRixDQUFBO0FBUDFFO0FBQ0E7QUFDQTtBQUNBOztBQU1lLFNBQVNHLGdCQUFnQkEsQ0FBQ0MsTUFBTSxFQUFFO0VBQy9DLE1BQU07SUFBRUMsYUFBYTtJQUFFLEdBQUdDO0VBQUssQ0FBQyxHQUFHRixNQUFNLENBQUNHLE1BQU0sQ0FBQyxDQUFDLENBQUNDLEdBQUcsQ0FBQyxZQUFZLENBQUM7RUFDcEVKLE1BQU0sQ0FBQ0ssT0FBTyxDQUFDQyxVQUFVLENBQUNDLGFBQWEsQ0FDckNDLGtCQUFPLENBQUNDLEdBQUcsRUFDWDtJQUNFSixPQUFPLEVBQUUsQ0FBRUssa0JBQVMsQ0FBRTtJQUN0QlQsYUFBYSxFQUFFO01BQUUsR0FBR0EsYUFBYTtNQUFFLEdBQUdVO0lBQWdCLENBQUM7SUFDdkQsR0FBR1Q7RUFDTCxDQUNGLENBQUM7QUFDSDtBQUFDVSxNQUFBLENBQUFDLE9BQUEsR0FBQUEsT0FBQSxDQUFBZixPQUFBIn0=