"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSqlRoute = registerSqlRoute;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerSqlRoute({
  router,
  facet
}) {
  router.post({
    path: `/api/sql/search`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(req);
    if (queryRes.success) {
      const result = {
        body: {
          ...queryRes.data
        }
      };
      return res.ok(result);
    }
    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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