"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserConfigFrom = void 0;
var _lodash = require("lodash");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* The file contains helper functions for visualizaitons operations
 * getUserConfigFrom - returns input objects'  user_configs or userConfigs, JSON parsed if necessary
 */

const getUserConfigFrom = container => {
  const config = (container === null || container === void 0 ? void 0 : container.user_configs) || (container === null || container === void 0 ? void 0 : container.userConfigs) || {};
  if ((0, _lodash.isEmpty)(config)) return {};
  if ((0, _lodash.isString)(config)) return JSON.parse(config);else return {};
};
exports.getUserConfigFrom = getUserConfigFrom;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwicmVxdWlyZSIsImdldFVzZXJDb25maWdGcm9tIiwiY29udGFpbmVyIiwiY29uZmlnIiwidXNlcl9jb25maWdzIiwidXNlckNvbmZpZ3MiLCJpc0VtcHR5IiwiaXNTdHJpbmciLCJKU09OIiwicGFyc2UiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsidmlzdWFsaXphdGlvbl9oZWxwZXJzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgaXNFbXB0eSwgaXNTdHJpbmcgfSBmcm9tICdsb2Rhc2gnO1xuXG4vKiBUaGUgZmlsZSBjb250YWlucyBoZWxwZXIgZnVuY3Rpb25zIGZvciB2aXN1YWxpemFpdG9ucyBvcGVyYXRpb25zXG4gKiBnZXRVc2VyQ29uZmlnRnJvbSAtIHJldHVybnMgaW5wdXQgb2JqZWN0cycgIHVzZXJfY29uZmlncyBvciB1c2VyQ29uZmlncywgSlNPTiBwYXJzZWQgaWYgbmVjZXNzYXJ5XG4gKi9cblxuZXhwb3J0IGNvbnN0IGdldFVzZXJDb25maWdGcm9tID0gKGNvbnRhaW5lcjogdW5rbm93bik6IG9iamVjdCA9PiB7XG4gIGNvbnN0IGNvbmZpZyA9IGNvbnRhaW5lcj8udXNlcl9jb25maWdzIHx8IGNvbnRhaW5lcj8udXNlckNvbmZpZ3MgfHwge307XG5cbiAgaWYgKGlzRW1wdHkoY29uZmlnKSkgcmV0dXJuIHt9O1xuXG4gIGlmIChpc1N0cmluZyhjb25maWcpKSByZXR1cm4gSlNPTi5wYXJzZShjb25maWcpO1xuICBlbHNlIHJldHVybiB7fTtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlBO0FBQ0E7QUFDQTs7QUFFTyxNQUFNQyxpQkFBaUIsR0FBSUMsU0FBa0IsSUFBYTtFQUMvRCxNQUFNQyxNQUFNLEdBQUcsQ0FBQUQsU0FBUyxhQUFUQSxTQUFTLHVCQUFUQSxTQUFTLENBQUVFLFlBQVksTUFBSUYsU0FBUyxhQUFUQSxTQUFTLHVCQUFUQSxTQUFTLENBQUVHLFdBQVcsS0FBSSxDQUFDLENBQUM7RUFFdEUsSUFBSSxJQUFBQyxlQUFPLEVBQUNILE1BQU0sQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0VBRTlCLElBQUksSUFBQUksZ0JBQVEsRUFBQ0osTUFBTSxDQUFDLEVBQUUsT0FBT0ssSUFBSSxDQUFDQyxLQUFLLENBQUNOLE1BQU0sQ0FBQyxDQUFDLEtBQzNDLE9BQU8sQ0FBQyxDQUFDO0FBQ2hCLENBQUM7QUFBQ08sT0FBQSxDQUFBVCxpQkFBQSxHQUFBQSxpQkFBQSJ9