"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBuilder = void 0;
var _lodash = require("lodash");
var _aggragations = require("../tree/aggragations");
var _expression = require("../expression");
var _explorer = require("../../../../common/constants/explorer");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class StatsBuilder {
  constructor(statsChunk) {
    this.statsChunk = statsChunk;
  }
  build() {
    // return a new stats subtree
    return new _aggragations.Aggregations('stats_command', [], !(0, _lodash.isEmpty)(this.statsChunk.partitions) ? this.buildParttions(this.statsChunk.partitions) : '', !(0, _lodash.isEmpty)(this.statsChunk.all_num) ? this.buildAllNum(this.statsChunk.all_num) : '', !(0, _lodash.isEmpty)(this.statsChunk.delim) ? this.buildDelim(this.statsChunk.delim) : '', !(0, _lodash.isEmpty)(this.statsChunk.aggregations) ? this.buildAggList(this.statsChunk.aggregations) : [], !(0, _lodash.isEmpty)(this.statsChunk.groupby) ? this.buildGroupList(this.statsChunk.groupby) : new _expression.GroupBy('stats_by_clause', [], [], null), !(0, _lodash.isEmpty)(this.statsChunk.dedup_split_value) ? this.buildDedupSplitValue(this.statsChunk.dedup_split_value) : '');
  }

  /**
   * Flags
   */
  buildParttions(partitions) {
    return `${partitions.keyword} ${partitions.sign} ${partitions.value}`;
  }
  buildAllNum(allNum) {
    return `${allNum.keyword} ${allNum.sign} ${allNum.value}`;
  }
  buildDelim(delim) {
    return `${delim.keyword} ${delim.sign} ${delim.value}`;
  }
  buildDedupSplitValue(dedupSplitvalue) {
    return `${dedupSplitvalue.keyword} ${dedupSplitvalue.sign} ${dedupSplitvalue.value}`;
  }

  /**
   * Aggregations
   */
  buildAggList(aggregations) {
    return aggregations.map(aggregation => {
      return this.buildAggTerm(aggregation);
    });
  }
  buildAggTerm(aggTerm) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.buildAggregateFunction(aggTerm.function), aggTerm.function_alias);
  }
  buildAggregateFunction(aggFunction) {
    return new _expression.AggregateFunction('stats_function', [], aggFunction.name, aggFunction.value_expression, aggFunction.percentile_agg_function);
  }

  /**
   * Groups
   */
  buildGroupList(groupby) {
    return new _expression.GroupBy('stats_by_clause', [], this.buildFieldList(groupby.group_fields), groupby.span ? this.buildSpan(groupby.span) : null);
  }
  buildFieldList(group_fields) {
    return group_fields.map(gf => {
      return new _expression.Field('field_expression', [], gf.name);
    });
  }
  buildSpan(span) {
    return new _expression.Span('span_clause', [], this.buildeSpanExpression(span.span_expression), span[_explorer.CUSTOM_LABEL]);
  }
  buildeSpanExpression(spanExpression) {
    return new _expression.SpanExpression('span_expression', [], spanExpression.field, spanExpression.literal_value, spanExpression.time_unit);
  }
}
exports.StatsBuilder = StatsBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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