"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YELLOW_ORANGE_RED_PALETTE = exports.YELLOW_GREEN_BLUE_PALETTE = exports.SPECTRUM = exports.SINGLE_COLOR_PALETTE = exports.RED_BLUE_PALETTE = exports.REDS_PALETTE = exports.PIE_PALETTES = exports.OPACITY = exports.MULTI_COLOR_PALETTE = exports.HEX_CONTRAST_COLOR = exports.HEATMAP_SINGLE_COLOR = exports.HEATMAP_PALETTE_COLOR = exports.GREYS_PALETTE = exports.GREENS_PALETTE = exports.DEFAULT_PALETTE = exports.COLOR_WHITE = exports.COLOR_PALETTES = exports.COLOR_BLACK = exports.BLUE_RED_PALETTE = exports.BLUES_PALETTE = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const BLUES_PALETTE = exports.BLUES_PALETTE = {
  name: 'Blues',
  label: 'Blues',
  colors: ['rgb(5,10,172)', 'rgb(40,60,190)', 'rgb(70,100,245)', 'rgb(90,120,245)', 'rgb(106,137,247)', 'rgb(220,220,220)']
};
const REDS_PALETTE = exports.REDS_PALETTE = {
  name: 'Reds',
  label: 'Reds',
  colors: ['rgb(220,220,220)', 'rgb(245,195,157)', 'rgb(245,160,105)', 'rgb(178,10,28)']
};
const GREENS_PALETTE = exports.GREENS_PALETTE = {
  name: 'Greens',
  label: 'Greens',
  colors: ['rgb(0,68,27)', 'rgb(0,109,44)', 'rgb(35,139,69)', 'rgb(65,171,93)', 'rgb(116,196,118)', 'rgb(161,217,155)', 'rgb(199,233,192)', 'rgb(229,245,224)', 'rgb(247,252,245)']
};
const GREYS_PALETTE = exports.GREYS_PALETTE = {
  name: 'Greys',
  label: 'Greys',
  colors: ['rgb(0,0,0)', 'rgb(255,255,255)']
};
const BLUE_RED_PALETTE = exports.BLUE_RED_PALETTE = {
  name: 'Bluered',
  label: 'Blue-Red',
  colors: ['rgb(0,0,255)', 'rgb(255,0,0)']
};
const RED_BLUE_PALETTE = exports.RED_BLUE_PALETTE = {
  name: 'RdBu',
  label: 'Red-Blue',
  colors: ['rgb(5,10,172)', 'rgb(106,137,247)', 'rgb(190,190,190)', 'rgb(220,170,132)', 'rgb(230,145,90)', 'rgb(178,10,28)']
};
const YELLOW_ORANGE_RED_PALETTE = exports.YELLOW_ORANGE_RED_PALETTE = {
  name: 'YlOrRd',
  label: 'Yellow-Orange-Red',
  colors: ['rgb(128,0,38)', 'rgb(189,0,38)', 'rgb(227,26,28)', 'rgb(252,78,42)', 'rgb(253,141,60)', 'rgb(254,178,76)', 'rgb(254,217,118)', 'rgb(255,237,160)', 'rgb(255,255,204)']
};
const YELLOW_GREEN_BLUE_PALETTE = exports.YELLOW_GREEN_BLUE_PALETTE = {
  name: 'YlGnBu',
  label: 'Yellow-Green-Blue',
  colors: ['rgb(8,29,88)', 'rgb(37,52,148)', 'rgb(34,94,168)', 'rgb(29,145,192)', 'rgb(65,182,196)', 'rgb(127,205,187)', 'rgb(199,233,180)', 'rgb(237,248,217)', 'rgb(255,255,217)']
};
const DEFAULT_PALETTE = exports.DEFAULT_PALETTE = 'default';
const SINGLE_COLOR_PALETTE = exports.SINGLE_COLOR_PALETTE = 'singleColor';
const MULTI_COLOR_PALETTE = exports.MULTI_COLOR_PALETTE = 'multicolor';
const COLOR_PALETTES = exports.COLOR_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single color',
  type: 'text'
}, {
  value: MULTI_COLOR_PALETTE,
  title: 'Multicolored',
  type: 'text'
}, {
  value: BLUES_PALETTE.name,
  title: BLUES_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUES_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: REDS_PALETTE.name,
  title: REDS_PALETTE.label,
  palette: (0, _eui.colorPalette)(REDS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREENS_PALETTE.name,
  title: GREENS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREENS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREYS_PALETTE.name,
  title: GREYS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREYS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: BLUE_RED_PALETTE.name,
  title: BLUE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: RED_BLUE_PALETTE.name,
  title: RED_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(RED_BLUE_PALETTE.colors, 20, true),
  type: 'gradient'
}, {
  value: YELLOW_ORANGE_RED_PALETTE.name,
  title: YELLOW_ORANGE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_ORANGE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: YELLOW_GREEN_BLUE_PALETTE.name,
  title: YELLOW_GREEN_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_GREEN_BLUE_PALETTE.colors, 20),
  type: 'gradient'
}];
const HEX_CONTRAST_COLOR = exports.HEX_CONTRAST_COLOR = 0xffffff;
const PIE_PALETTES = exports.PIE_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single Color',
  type: 'text'
}];
const HEATMAP_PALETTE_COLOR = exports.HEATMAP_PALETTE_COLOR = {
  name: REDS_PALETTE.label,
  color: REDS_PALETTE.label
};
const HEATMAP_SINGLE_COLOR = exports.HEATMAP_SINGLE_COLOR = {
  name: 'singleColor',
  color: '#000000'
};
const OPACITY = exports.OPACITY = 'opacity';
const SPECTRUM = exports.SPECTRUM = 'spectrum';
const COLOR_BLACK = exports.COLOR_BLACK = 'rgb(0,0,0)';
const COLOR_WHITE = exports.COLOR_WHITE = 'rgb(255,255,255)';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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