"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * The transform configuration in Jest allows you to 
 * specify custom transformation logic for specific file types during testing. 
 */
module.exports = {
  /**
   * This function is responsible for transforming the file.
   * @returns the string module.exports = {};, which is an empty CommonJS module.
   */
  process() {
    return {
      code: `module.exports = {};`
    };
  },
  /**
   * The cache key helps Jest determine if a file needs to be retransformed or if it can use the cached transformation result. 
   * @returns a unique string that serves as a cache key for the transformation. 
   */
  getCacheKey() {
    return 'svgTransform';
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJtb2R1bGUiLCJleHBvcnRzIiwicHJvY2VzcyIsImNvZGUiLCJnZXRDYWNoZUtleSJdLCJzb3VyY2VzIjpbInRyYW5zZm9ybU1vY2sudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vKipcbiAqIFRoZSB0cmFuc2Zvcm0gY29uZmlndXJhdGlvbiBpbiBKZXN0IGFsbG93cyB5b3UgdG8gXG4gKiBzcGVjaWZ5IGN1c3RvbSB0cmFuc2Zvcm1hdGlvbiBsb2dpYyBmb3Igc3BlY2lmaWMgZmlsZSB0eXBlcyBkdXJpbmcgdGVzdGluZy4gXG4gKi9cbm1vZHVsZS5leHBvcnRzID0ge1xuICAvKipcbiAgICogVGhpcyBmdW5jdGlvbiBpcyByZXNwb25zaWJsZSBmb3IgdHJhbnNmb3JtaW5nIHRoZSBmaWxlLlxuICAgKiBAcmV0dXJucyB0aGUgc3RyaW5nIG1vZHVsZS5leHBvcnRzID0ge307LCB3aGljaCBpcyBhbiBlbXB0eSBDb21tb25KUyBtb2R1bGUuXG4gICAqL1xuICBwcm9jZXNzKCkge1xuICAgIHJldHVybiB7XG4gICAgICBjb2RlOiBgbW9kdWxlLmV4cG9ydHMgPSB7fTtgLFxuICAgIH07XG4gIH0sXG4gIC8qKlxuICAgKiBUaGUgY2FjaGUga2V5IGhlbHBzIEplc3QgZGV0ZXJtaW5lIGlmIGEgZmlsZSBuZWVkcyB0byBiZSByZXRyYW5zZm9ybWVkIG9yIGlmIGl0IGNhbiB1c2UgdGhlIGNhY2hlZCB0cmFuc2Zvcm1hdGlvbiByZXN1bHQuIFxuICAgKiBAcmV0dXJucyBhIHVuaXF1ZSBzdHJpbmcgdGhhdCBzZXJ2ZXMgYXMgYSBjYWNoZSBrZXkgZm9yIHRoZSB0cmFuc2Zvcm1hdGlvbi4gXG4gICAqL1xuICBnZXRDYWNoZUtleSgpIHtcbiAgICByZXR1cm4gJ3N2Z1RyYW5zZm9ybSc7XG4gIH0sXG59OyJdLCJtYXBwaW5ncyI6Ijs7QUFBQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBQSxNQUFNLENBQUNDLE9BQU8sR0FBRztFQUNmO0FBQ0Y7QUFDQTtBQUNBO0VBQ0VDLE9BQU9BLENBQUEsRUFBRztJQUNSLE9BQU87TUFDTEMsSUFBSSxFQUFHO0lBQ1QsQ0FBQztFQUNILENBQUM7RUFDRDtBQUNGO0FBQ0E7QUFDQTtFQUNFQyxXQUFXQSxDQUFBLEVBQUc7SUFDWixPQUFPLGNBQWM7RUFDdkI7QUFDRixDQUFDIn0=