"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIndexState = exports.DirectQueryLoadingStatus = exports.CachedDataSourceStatus = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let DirectQueryLoadingStatus = exports.DirectQueryLoadingStatus = /*#__PURE__*/function (DirectQueryLoadingStatus) {
  DirectQueryLoadingStatus["SUCCESS"] = "success";
  DirectQueryLoadingStatus["FAILED"] = "failed";
  DirectQueryLoadingStatus["RUNNING"] = "running";
  DirectQueryLoadingStatus["SUBMITTED"] = "submitted";
  DirectQueryLoadingStatus["SCHEDULED"] = "scheduled";
  DirectQueryLoadingStatus["CANCELED"] = "canceled";
  DirectQueryLoadingStatus["WAITING"] = "waiting";
  DirectQueryLoadingStatus["INITIAL"] = "initial";
  return DirectQueryLoadingStatus;
}({});
/**
 * States for data-source driven indices, adhering to the OS-Spark state machine. See:
 * https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md#index-state-transition
 *
 * Non-exhaustive: There may be more index states in the future. This should usually be typed as
 * `ExternalIndexState | string`.
 */
let ExternalIndexState = exports.ExternalIndexState = /*#__PURE__*/function (ExternalIndexState) {
  ExternalIndexState["CREATING"] = "creating";
  ExternalIndexState["ACTIVE"] = "active";
  ExternalIndexState["REFRESHING"] = "refreshing";
  ExternalIndexState["RECOVERING"] = "recovering";
  ExternalIndexState["CANCELLING"] = "cancelling";
  return ExternalIndexState;
}({});
let CachedDataSourceStatus = exports.CachedDataSourceStatus = /*#__PURE__*/function (CachedDataSourceStatus) {
  CachedDataSourceStatus["Updated"] = "Updated";
  CachedDataSourceStatus["Failed"] = "Failed";
  CachedDataSourceStatus["Empty"] = "Empty";
  return CachedDataSourceStatus;
}({}); // Integration types