"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewMissingIndices = void 0;
var _common = require("../../../../opensearch_dashboards_utils/common/");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */

/**
 * Tried to call a method that relies on SearchSource having an dataView assigned
 */
class DataViewMissingIndices extends _common.OsdError {
  constructor(message) {
    const defaultMessage = "DataView's configured pattern does not match any indices";
    super(message && message.length ? `No matching indices found: ${message}` : defaultMessage);
  }
}
exports.DataViewMissingIndices = DataViewMissingIndices;