"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataView = void 0;
var _index_pattern = require("../../index_patterns/index_patterns/index_pattern");
var _ = require("../");
var _constants = require("../../constants");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * @experimental This class is experimental and may change in future versions
 */
class DataView extends _index_pattern.IndexPattern {
  constructor({
    spec = {},
    fieldFormats,
    shortDotsEnable = false,
    metaFields = [],
    savedObjectsClient
  }) {
    super({
      spec,
      fieldFormats,
      shortDotsEnable,
      metaFields,
      savedObjectsClient
    });
    _defineProperty(this, "savedObjectsClient", void 0);
    this.savedObjectsClient = savedObjectsClient;
    this.initializeDataSourceRef();
  }
  async initializeDataSourceRef() {
    var _this$dataSourceRef;
    if (!((_this$dataSourceRef = this.dataSourceRef) !== null && _this$dataSourceRef !== void 0 && _this$dataSourceRef.id)) return;
    const dataSourceSavedObject = await this.savedObjectsClient.get(this.dataSourceRef.type, this.dataSourceRef.id);
    const attributes = dataSourceSavedObject.attributes;
    this.dataSourceRef = {
      id: this.dataSourceRef.id,
      type: attributes.dataSourceEngineType || this.dataSourceRef.type,
      name: attributes.title || this.dataSourceRef.name || this.dataSourceRef.id
    };
  }

  /**
   * Converts a DataView to a serializable Dataset object
   * Maps dataSourceRef and includes only essential properties for backward compatibility
   */
  async toDataset() {
    const defaultType = _constants.DEFAULT_DATA.SET_TYPES.INDEX_PATTERN;
    const dataSourceReference = this.dataSourceRef || this.dataSource;
    let dataSource;
    let datasetType = this.type || defaultType;
    if (dataSourceReference !== null && dataSourceReference !== void 0 && dataSourceReference.id) {
      try {
        const dataSourceSavedObject = await this.savedObjectsClient.get('data-source', dataSourceReference.id);
        const attributes = dataSourceSavedObject.attributes;
        if (dataSourceReference.name) {
          const extractedType = (0, _.extractDatasetTypeFromUri)(dataSourceReference.name);
          if (extractedType) {
            datasetType = extractedType;
          }
        }
        dataSource = {
          id: dataSourceReference.id,
          title: attributes.title || dataSourceReference.name || dataSourceReference.id,
          type: attributes.dataSourceEngineType || 'OpenSearch'
        };
      } catch (error) {
        // If we can't fetch the data source, create a minimal version
        dataSource = {
          id: dataSourceReference.id,
          title: dataSourceReference.name || dataSourceReference.id,
          type: dataSourceReference.type || 'OpenSearch'
        };
      }
    }
    return {
      id: this.id || '',
      title: this.title,
      type: datasetType,
      timeFieldName: this.timeFieldName,
      dataSource
    };
  }
}
exports.DataView = DataView;