"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unpackBody = exports.packBody = exports.createRequestDecryptor = exports.createRequestEncryptor = void 0;
var node_crypto_1 = require("@elastic/node-crypto");
var node_jose_1 = require("node-jose");
var jwk_1 = require("./jwk");
var random_bytes_1 = require("./random-bytes");
function createRequestEncryptor(publicJWKS) {
    return __awaiter(this, void 0, void 0, function () {
        var jwkManager;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, jwk_1.createJWKManager)(publicJWKS)];
                case 1:
                    jwkManager = _a.sent();
                    return [2 /*return*/, {
                            encrypt: function (kid, input) {
                                return __awaiter(this, void 0, void 0, function () {
                                    var AESKeyBuffer, AES, encryptedPayload, encryptedKey;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                AESKeyBuffer = (0, random_bytes_1.generatePassphrase)();
                                                AES = (0, node_crypto_1.default)({ encryptionKey: AESKeyBuffer });
                                                return [4 /*yield*/, AES.encrypt(input)];
                                            case 1:
                                                encryptedPayload = _a.sent();
                                                return [4 /*yield*/, jwkManager.encrypt(kid, AESKeyBuffer)];
                                            case 2:
                                                encryptedKey = _a.sent();
                                                return [2 /*return*/, packBody(encryptedKey, encryptedPayload)];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
exports.createRequestEncryptor = createRequestEncryptor;
function createRequestDecryptor(privateJWKS) {
    return __awaiter(this, void 0, void 0, function () {
        var jwkManager;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, jwk_1.createJWKManager)(privateJWKS)];
                case 1:
                    jwkManager = _a.sent();
                    return [2 /*return*/, {
                            getPublicComponent: function (kid) {
                                return jwkManager.getPublicJWK(kid);
                            },
                            getWellKnowns: function () {
                                return jwkManager.getPublicJWKS();
                            },
                            decrypt: function (encryptedBody) {
                                return __awaiter(this, void 0, void 0, function () {
                                    var _a, encryptedAESKey, encryptedPayload, encryptionKeyBuffer, AES;
                                    return __generator(this, function (_b) {
                                        switch (_b.label) {
                                            case 0:
                                                _a = unpackBody(encryptedBody), encryptedAESKey = _a.encryptedAESKey, encryptedPayload = _a.encryptedPayload;
                                                return [4 /*yield*/, jwkManager.decrypt(encryptedAESKey)];
                                            case 1:
                                                encryptionKeyBuffer = (_b.sent()).payload;
                                                AES = (0, node_crypto_1.default)({ encryptionKey: encryptionKeyBuffer });
                                                return [2 /*return*/, AES.decrypt(encryptedPayload)];
                                        }
                                    });
                                });
                            },
                            getJWKMetadata: function (encryptedBody) {
                                return __awaiter(this, void 0, void 0, function () {
                                    var encryptedAESKey, _a, key, protectedFields, header;
                                    return __generator(this, function (_b) {
                                        switch (_b.label) {
                                            case 0:
                                                encryptedAESKey = unpackBody(encryptedBody).encryptedAESKey;
                                                return [4 /*yield*/, jwkManager.decrypt(encryptedAESKey)];
                                            case 1:
                                                _a = _b.sent(), key = _a.key, protectedFields = _a.protected, header = _a.header;
                                                return [2 /*return*/, { key: key, protected: protectedFields, header: header }];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
exports.createRequestDecryptor = createRequestDecryptor;
function packBody(encryptedAESKey, encryptedPayload) {
    var packedBodyStringifiedJSON = JSON.stringify({
        encryptedAESKey: encryptedAESKey,
        encryptedPayload: encryptedPayload,
    });
    return node_jose_1.util.base64url.encode(packedBodyStringifiedJSON, 'utf8');
}
exports.packBody = packBody;
function unpackBody(packedBody) {
    var decodedBody = node_jose_1.util.base64url.decode(packedBody);
    var _a = JSON.parse(decodedBody.toString('utf8')), encryptedAESKey = _a.encryptedAESKey, encryptedPayload = _a.encryptedPayload;
    return { encryptedAESKey: encryptedAESKey, encryptedPayload: encryptedPayload };
}
exports.unpackBody = unpackBody;
//# sourceMappingURL=request.js.map