"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavItem = EuiSideNavItem;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _inner_text = require("../inner_text");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * The props that are exposed to, or altered for, the consumer
 * for use in the object of items in `EuiSideNav`
 * can be found in the `side_nave_types.ts` file.
 */

var DefaultRenderItem = function DefaultRenderItem(_ref) {
  var href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    onClick = _ref.onClick,
    className = _ref.className,
    children = _ref.children,
    disabled = _ref.disabled,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["href", "target", "rel", "onClick", "className", "children", "disabled"]);
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      rel: rel,
      target: target
    });
    return /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({
      className: className,
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), children);
  }
  if (onClick || disabled) {
    return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
      type: "button",
      className: className,
      onClick: onClick,
      disabled: disabled
    }, rest), children);
  }
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: className
  }, rest), children);
};
function EuiSideNavItem(_ref2) {
  var isOpen = _ref2.isOpen,
    isSelected = _ref2.isSelected,
    isParent = _ref2.isParent,
    icon = _ref2.icon,
    onClick = _ref2.onClick,
    _href = _ref2.href,
    rel = _ref2.rel,
    target = _ref2.target,
    items = _ref2.items,
    children = _ref2.children,
    _ref2$renderItem = _ref2.renderItem,
    RenderItem = _ref2$renderItem === void 0 ? DefaultRenderItem : _ref2$renderItem,
    _ref2$depth = _ref2.depth,
    depth = _ref2$depth === void 0 ? 0 : _ref2$depth,
    className = _ref2.className,
    _ref2$truncate = _ref2.truncate,
    truncate = _ref2$truncate === void 0 ? true : _ref2$truncate,
    emphasize = _ref2.emphasize,
    buttonClassName = _ref2.buttonClassName,
    childrenOnly = _ref2.childrenOnly,
    rest = (0, _objectWithoutProperties2.default)(_ref2, ["isOpen", "isSelected", "isParent", "icon", "onClick", "href", "rel", "target", "items", "children", "renderItem", "depth", "className", "truncate", "emphasize", "buttonClassName", "childrenOnly"]);
  var isHrefValid = !_href || (0, _href_validator.validateHref)(_href);
  var href = isHrefValid ? _href : '';
  var isClickable = onClick || href;

  // Forcing accordion style item if not linked, but has children
  var _useState = (0, _react.useState)(isOpen),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    itemIsOpen = _useState2[0],
    setItemIsOpen = _useState2[1];
  (0, _react.useEffect)(function () {
    setItemIsOpen(isOpen);
  }, [isOpen]);
  var toggleItemOpen = function toggleItemOpen() {
    setItemIsOpen(function (isOpen) {
      return !isOpen;
    });
  };
  var childItems;
  if (items && itemIsOpen) {
    childItems = /*#__PURE__*/_react.default.createElement("div", {
      className: "euiSideNavItem__items"
    }, items);
  }
  var buttonIcon;
  if (icon) {
    buttonIcon = /*#__PURE__*/(0, _react.cloneElement)(icon, {
      className: (0, _classnames.default)('euiSideNavItemButton__icon', icon.props.className)
    });
  }
  var classes = (0, _classnames.default)('euiSideNavItem', {
    'euiSideNavItem--root': depth === 0,
    'euiSideNavItem--rootIcon': depth === 0 && icon,
    'euiSideNavItem--trunk': depth === 1,
    'euiSideNavItem--branch': depth > 1,
    'euiSideNavItem--hasChildItems': !!childItems,
    'euiSideNavItem--emphasized': emphasize
  }, className);
  var buttonClasses = (0, _classnames.default)('euiSideNavItemButton', {
    'euiSideNavItemButton--isClickable': isClickable,
    'euiSideNavItemButton-isOpen': depth > 0 && itemIsOpen && !isSelected,
    'euiSideNavItemButton-isSelected': isSelected
  }, buttonClassName);
  var caret;
  if (depth > 0 && childrenOnly) {
    caret = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
      type: itemIsOpen ? 'arrowDown' : 'arrowRight',
      size: "s"
    });
  }
  var buttonContent = /*#__PURE__*/_react.default.createElement("span", {
    className: "euiSideNavItemButton__content"
  }, buttonIcon, /*#__PURE__*/_react.default.createElement(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return /*#__PURE__*/_react.default.createElement("span", {
      ref: ref,
      title: truncate ? innerText : undefined,
      className: (0, _classnames.default)('euiSideNavItemButton__label', {
        'euiSideNavItemButton__label--truncated': truncate
      })
    }, children);
  }), caret);
  var renderItemProps = {
    href: href,
    rel: rel,
    target: target,
    onClick: childrenOnly ? toggleItemOpen : onClick,
    className: buttonClasses,
    children: buttonContent
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes
  }, /*#__PURE__*/_react.default.createElement(RenderItem, (0, _extends2.default)({}, renderItemProps, rest)), childItems);
}