function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Fragment } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { LEFT_ALIGNMENT, RIGHT_ALIGNMENT, CENTER_ALIGNMENT } from '../../services';
import { resolveWidthAsStyle } from './utils';
import { useIsWithinBreakpoints } from '../../services/hooks/useIsWithinBreakpoints';
export var EuiTableRowCell = function EuiTableRowCell(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? LEFT_ALIGNMENT : _ref$align,
    children = _ref.children,
    className = _ref.className,
    truncateText = _ref.truncateText,
    setScopeRow = _ref.setScopeRow,
    showOnHover = _ref.showOnHover,
    _ref$textOnly = _ref.textOnly,
    textOnly = _ref$textOnly === void 0 ? true : _ref$textOnly,
    hasActions = _ref.hasActions,
    isExpander = _ref.isExpander,
    _ref$mobileOptions = _ref.mobileOptions,
    mobileOptions = _ref$mobileOptions === void 0 ? {
      show: true
    } : _ref$mobileOptions,
    header = _ref.header,
    hideForMobile = _ref.hideForMobile,
    isMobileHeader = _ref.isMobileHeader,
    isMobileFullWidth = _ref.isMobileFullWidth,
    style = _ref.style,
    width = _ref.width,
    rest = _objectWithoutProperties(_ref, ["align", "children", "className", "truncateText", "setScopeRow", "showOnHover", "textOnly", "hasActions", "isExpander", "mobileOptions", "header", "hideForMobile", "isMobileHeader", "isMobileFullWidth", "style", "width"]);
  var cellClasses = classNames('euiTableRowCell', {
    'euiTableRowCell--hasActions': hasActions,
    'euiTableRowCell--isExpander': isExpander,
    'euiTableRowCell--hideForDesktop': mobileOptions.only || isMobileHeader,
    'euiTableRowCell--enlargeForMobile': mobileOptions.enlarge || isMobileHeader,
    'euiTableRowCell--isMobileFullWidth': mobileOptions.fullWidth || isMobileFullWidth || isMobileHeader
  });
  var contentClasses = classNames('euiTableCellContent', className, {
    'euiTableCellContent--alignRight': align === RIGHT_ALIGNMENT,
    'euiTableCellContent--alignCenter': align === CENTER_ALIGNMENT,
    'euiTableCellContent--showOnHover': showOnHover,
    'euiTableCellContent--truncateText': truncateText,
    // We're doing this rigamarole instead of creating `euiTableCellContent--textOnly` for BWC
    // purposes for the time-being.
    'euiTableCellContent--overflowingContent': textOnly !== true
  });
  var mobileContentClasses = classNames('euiTableCellContent', className, {
    'euiTableCellContent--alignRight': mobileOptions.align === RIGHT_ALIGNMENT || align === RIGHT_ALIGNMENT,
    'euiTableCellContent--alignCenter': mobileOptions.align === CENTER_ALIGNMENT || align === RIGHT_ALIGNMENT,
    'euiTableCellContent--showOnHover': mobileOptions.showOnHover || showOnHover,
    'euiTableCellContent--truncateText': mobileOptions.truncateText || truncateText,
    // We're doing this rigamarole instead of creating `euiTableCellContent--textOnly` for BWC
    // purposes for the time-being.
    'euiTableCellContent--overflowingContent': mobileOptions.textOnly !== true || textOnly !== true
  });
  var childClasses = classNames({
    euiTableCellContent__text: textOnly === true,
    euiTableCellContent__hoverItem: showOnHover
  });
  var widthValue = useIsWithinBreakpoints(['xs', 's', 'm']) && mobileOptions.width ? mobileOptions.width : width;
  var styleObj = resolveWidthAsStyle(style, widthValue);
  function modifyChildren(children) {
    var modifiedChildren = children;
    if (textOnly === true) {
      modifiedChildren = /*#__PURE__*/React.createElement("span", {
        className: childClasses
      }, children);
    } else if (/*#__PURE__*/React.isValidElement(children)) {
      modifiedChildren = React.Children.map(children, function (child) {
        return /*#__PURE__*/React.cloneElement(child, {
          className: classNames(child.props.className, childClasses)
        });
      });
    }
    return modifiedChildren;
  }
  var childrenNode = modifyChildren(children);
  var hideForMobileClasses = 'euiTableRowCell--hideForMobile';
  var showForMobileClasses = 'euiTableRowCell--hideForDesktop';
  var Element = setScopeRow ? 'th' : 'td';
  var sharedProps = _objectSpread({
    scope: setScopeRow ? 'row' : undefined,
    style: styleObj
  }, rest);
  if (mobileOptions.show === false || hideForMobile) {
    return /*#__PURE__*/React.createElement(Element, _extends({
      className: "".concat(cellClasses, " ").concat(hideForMobileClasses)
    }, sharedProps), /*#__PURE__*/React.createElement("div", {
      className: contentClasses
    }, childrenNode));
  } else {
    return /*#__PURE__*/React.createElement(Element, _extends({
      className: cellClasses
    }, sharedProps), (mobileOptions.header || header) && !isMobileHeader && /*#__PURE__*/React.createElement("div", {
      className: "euiTableRowCell__mobileHeader ".concat(showForMobileClasses)
    }, mobileOptions.header || header), mobileOptions.render ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement("div", {
      className: "".concat(mobileContentClasses, " ").concat(showForMobileClasses)
    }, modifyChildren(mobileOptions.render)), /*#__PURE__*/React.createElement("div", {
      className: "".concat(contentClasses, " ").concat(hideForMobileClasses)
    }, childrenNode)) : /*#__PURE__*/React.createElement("div", {
      className: contentClasses
    }, childrenNode));
  }
};
EuiTableRowCell.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  align: PropTypes.oneOf(["left", "right", "center"]),
  /**
     * Don't allow line breaks within cells
     */
  showOnHover: PropTypes.bool,
  /**
     * Setting `textOnly` to `false` will break words unnecessarily on FF and
     * IE.  To combat this problem on FF, wrap contents with the css utility
     * `.eui-textBreakWord`.
     */
  textOnly: PropTypes.bool,
  /**
     * _Should only be used for action cells_
     */
  truncateText: PropTypes.bool,
  width: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired]),
  /**
     * Indicates if the column is dedicated to icon-only actions (currently
     * affects mobile only)
     */
  hasActions: PropTypes.bool,
  /**
     * _DEPRECATED: use `mobileOptions.header`_
     * The column's header title for use in mobile view (will be added as a
     * data-attr)
     */
  header: PropTypes.string,
  /**
     * _DEPRECATED: use `mobileOptions.show = false`_
     * Indicates if the column should not show for mobile users (typically
     * hidden because a custom mobile header utilizes the column's contents)
     */
  hideForMobile: PropTypes.bool,
  /**
     * Indicates if the column is dedicated as the expandable row toggle
     */
  isExpander: PropTypes.bool,
  /**
     * _DEPRECATED: use `mobileOptions.fullWidth`_
     * Allocates 100% of the width of the container in mobile view
     * (typically cells are contained to 50%)
     */
  isMobileFullWidth: PropTypes.bool,
  /**
     * _DEPRECATED: use `mobileOptions.only = true & mobileOptions.header = * false`_
     * Indicates if the column was created to be the row's heading in mobile
     * view.  It won't display column's header inline and it the column will
     * be hidden at larger screens)
     */
  isMobileHeader: PropTypes.bool,
  /**
     * Mobile options for displaying differently at small screens
     */
  mobileOptions: PropTypes.shape({
    /**
       * If false, will not render the cell at all for mobile
       */
    show: PropTypes.bool,
    /**
       * Only show for mobile? If true, will not render the column at all for desktop
       */
    only: PropTypes.bool,
    /**
       * Custom render/children if different from desktop
       */
    render: PropTypes.node,
    /**
       * The column's header for use in mobile view (automatically passed down
       * when using `EuiBasicTable`).
       * Or pass `false` to not show a header at all.
       */
    header: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.bool.isRequired]),
    /**
       * Increase text size compared to rest of cells
       */
    enlarge: PropTypes.bool,
    /**
       * Allocates 100% of the width of the container in mobile view
       * (typically cells are contained to 50%)
       */
    fullWidth: PropTypes.bool,
    /**
       * Applies the value to the width of the cell in mobile view (typically 50%)
       */
    width: PropTypes.oneOfType([PropTypes.any, PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired])]),
    /**
       * Horizontal alignment of the text in the cell
       */
    align: PropTypes.oneOf(["left", "right", "center"]),
    /**
       * Don't allow line breaks within cells
       */
    showOnHover: PropTypes.bool,
    /**
       * Setting `textOnly` to `false` will break words unnecessarily on FF and
       * IE.  To combat this problem on FF, wrap contents with the css utility
       * `.eui-textBreakWord`.
       */
    textOnly: PropTypes.bool,
    /**
       * _Should only be used for action cells_
       */
    truncateText: PropTypes.bool
  }),
  /**
     * Indicates whether the cell should be marked as the heading for its row
     */
  setScopeRow: PropTypes.bool
};