"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fitText = exports.cutToLength = exports.measureOneBoxWidth = exports.VerticalAlignments = exports.measureText = exports.cssFontShorthand = exports.TEXT_BASELINE = exports.TEXT_ALIGNS = exports.FONT_STYLES = exports.FONT_WEIGHTS = exports.FONT_VARIANTS = void 0;
var monotonic_hill_climb_1 = require("../solvers/monotonic_hill_climb");
exports.FONT_VARIANTS = Object.freeze(['normal', 'small-caps']);
exports.FONT_WEIGHTS = Object.freeze([
    100,
    200,
    300,
    400,
    500,
    600,
    700,
    800,
    900,
    'normal',
    'bold',
    'lighter',
    'bolder',
    'inherit',
    'initial',
    'unset',
]);
exports.FONT_STYLES = Object.freeze(['normal', 'italic', 'oblique', 'inherit', 'initial', 'unset']);
exports.TEXT_ALIGNS = Object.freeze(['start', 'end', 'left', 'right', 'center']);
exports.TEXT_BASELINE = Object.freeze([
    'top',
    'hanging',
    'middle',
    'alphabetic',
    'ideographic',
    'bottom',
]);
function cssFontShorthand(_a, fontSize) {
    var fontStyle = _a.fontStyle, fontVariant = _a.fontVariant, fontWeight = _a.fontWeight, fontFamily = _a.fontFamily;
    return fontStyle + " " + fontVariant + " " + fontWeight + " " + fontSize + "px " + fontFamily;
}
exports.cssFontShorthand = cssFontShorthand;
function measureText(ctx) {
    return function (fontSize, boxes) {
        return boxes.map(function (box) {
            ctx.font = cssFontShorthand(box, fontSize);
            return ctx.measureText(box.text);
        });
    };
}
exports.measureText = measureText;
exports.VerticalAlignments = Object.freeze({
    top: 'top',
    middle: 'middle',
    bottom: 'bottom',
    alphabetic: 'alphabetic',
    hanging: 'hanging',
    ideographic: 'ideographic',
});
function measureOneBoxWidth(measure, fontSize, box) {
    return measure(fontSize, [box])[0].width;
}
exports.measureOneBoxWidth = measureOneBoxWidth;
function cutToLength(s, maxLength) {
    return s.length <= maxLength ? s : s.slice(0, Math.max(0, maxLength - 1)) + "\u2026";
}
exports.cutToLength = cutToLength;
function fitText(measure, desiredText, allottedWidth, fontSize, font) {
    var desiredLength = desiredText.length;
    var response = function (v) { return measure(fontSize, [__assign(__assign({}, font), { text: desiredText.slice(0, Math.max(0, v)) })])[0].width; };
    var visibleLength = monotonic_hill_climb_1.monotonicHillClimb(response, desiredLength, allottedWidth, monotonic_hill_climb_1.integerSnap);
    var text = visibleLength < 2 && desiredLength >= 2 ? '' : cutToLength(desiredText, visibleLength);
    var _a = measure(fontSize, [__assign(__assign({}, font), { text: text })])[0], width = _a.width, emHeightAscent = _a.emHeightAscent, emHeightDescent = _a.emHeightDescent;
    return {
        width: width,
        verticalOffset: -(emHeightDescent + emHeightAscent) / 2,
        text: text,
    };
}
exports.fitText = fitText;
//# sourceMappingURL=text_utils.js.map