// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
export var KeyringTraceFlag;
(function (KeyringTraceFlag) {
    /**
     * Bit flag indicating this wrapping key generated the data key.
     */
    KeyringTraceFlag[KeyringTraceFlag["WRAPPING_KEY_GENERATED_DATA_KEY"] = 1] = "WRAPPING_KEY_GENERATED_DATA_KEY";
    /**
     * Bit flag indicating this wrapping key encrypted the data key.
     */
    KeyringTraceFlag[KeyringTraceFlag["WRAPPING_KEY_ENCRYPTED_DATA_KEY"] = 2] = "WRAPPING_KEY_ENCRYPTED_DATA_KEY";
    /**
     * Bit flag indicating this wrapping key decrypted the data key.
     */
    KeyringTraceFlag[KeyringTraceFlag["WRAPPING_KEY_DECRYPTED_DATA_KEY"] = 4] = "WRAPPING_KEY_DECRYPTED_DATA_KEY";
    /**
     * Bit flag indicating this wrapping key signed the encryption context.
     */
    KeyringTraceFlag[KeyringTraceFlag["WRAPPING_KEY_SIGNED_ENC_CTX"] = 8] = "WRAPPING_KEY_SIGNED_ENC_CTX";
    /**
     * Bit flag indicating this wrapping key verified the signature of the encryption context.
     */
    KeyringTraceFlag[KeyringTraceFlag["WRAPPING_KEY_VERIFIED_ENC_CTX"] = 16] = "WRAPPING_KEY_VERIFIED_ENC_CTX";
    /* KeyringTraceFlags are organized here.
     * The three groupings are set, encrypt, and decrypt.
     * An unencrypted data key is set and is required to have a SET_FLAG.
     * For the encrypt path, the unencrypted data key must be generated.
     * For the decrypt path, the unencrypted data key must be decrypted.
     *
     * A encrypted data key must be encrypted
     * and the encryption context may be signed.
     *
     * When an encrypted data key is decrypted,
     * the encryption context may be verified.
     *
     * This organization is to keep a KeyringTrace for an encrypted data key
     * for listing the WRAPPING_KEY_VERIFIED_ENC_CTX flag.
     */
    KeyringTraceFlag[KeyringTraceFlag["ENCRYPT_FLAGS"] = 10] = "ENCRYPT_FLAGS";
    KeyringTraceFlag[KeyringTraceFlag["SET_FLAGS"] = 5] = "SET_FLAGS";
    KeyringTraceFlag[KeyringTraceFlag["DECRYPT_FLAGS"] = 20] = "DECRYPT_FLAGS";
})(KeyringTraceFlag || (KeyringTraceFlag = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2V5cmluZ190cmFjZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9rZXlyaW5nX3RyYWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7QUFvQ3RDLE1BQU0sQ0FBTixJQUFZLGdCQWdEWDtBQWhERCxXQUFZLGdCQUFnQjtJQUMxQjs7T0FFRztJQUNILDZHQUFtQyxDQUFBO0lBRW5DOztPQUVHO0lBQ0gsNkdBQXdDLENBQUE7SUFFeEM7O09BRUc7SUFDSCw2R0FBd0MsQ0FBQTtJQUV4Qzs7T0FFRztJQUNILHFHQUFvQyxDQUFBO0lBRXBDOztPQUVHO0lBQ0gsMEdBQXNDLENBQUE7SUFFdEM7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFFSCwwRUFBNkUsQ0FBQTtJQUU3RSxpRUFBNkUsQ0FBQTtJQUU3RSwwRUFDK0IsQ0FBQTtBQUNqQyxDQUFDLEVBaERXLGdCQUFnQixLQUFoQixnQkFBZ0IsUUFnRDNCIn0=