/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.stats;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.replication.action.stats.LeaderNodeStatsResponse;
import org.opensearch.replication.seqno.RemoteShardMetric;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\nH\u0014R&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lorg/opensearch/replication/action/stats/LeaderStatsResponse;", "Lorg/opensearch/action/support/nodes/BaseNodesResponse;", "Lorg/opensearch/replication/action/stats/LeaderNodeStatsResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "clusterName", "Lorg/opensearch/cluster/ClusterName;", "leaderNodeRespons", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "(Lorg/opensearch/cluster/ClusterName;Ljava/util/List;Ljava/util/List;)V", "remoteStats", "", "", "Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStats;", "getRemoteStats", "()Ljava/util/Map;", "setRemoteStats", "(Ljava/util/Map;)V", "stats", "Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStatsFrag;", "getStats", "()Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStatsFrag;", "setStats", "(Lorg/opensearch/replication/seqno/RemoteShardMetric$RemoteStatsFrag;)V", "readNodesFrom", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeNodesTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-cross-cluster-replication"})
public final class LeaderStatsResponse
extends BaseNodesResponse<LeaderNodeStatsResponse>
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, RemoteShardMetric.RemoteStats> remoteStats;
    @NotNull
    private RemoteShardMetric.RemoteStatsFrag stats;
    private static final Logger log = LogManager.getLogger(LeaderStatsResponse.class);

    @NotNull
    public final Map<String, RemoteShardMetric.RemoteStats> getRemoteStats() {
        return this.remoteStats;
    }

    public final void setRemoteStats(@NotNull Map<String, RemoteShardMetric.RemoteStats> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.remoteStats = map;
    }

    @NotNull
    public final RemoteShardMetric.RemoteStatsFrag getStats() {
        return this.stats;
    }

    public final void setStats(@NotNull RemoteShardMetric.RemoteStatsFrag remoteStatsFrag) {
        Intrinsics.checkNotNullParameter((Object)remoteStatsFrag, (String)"<set-?>");
        this.stats = remoteStatsFrag;
    }

    public LeaderStatsResponse(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.remoteStats = new LinkedHashMap();
        this.stats = new RemoteShardMetric.RemoteStatsFrag();
        Map map = inp.readMap(StreamInput::readString, RemoteShardMetric.RemoteStats::new);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"readMap(...)");
        this.remoteStats = map;
    }

    public LeaderStatsResponse(@Nullable ClusterName clusterName, @Nullable List<LeaderNodeStatsResponse> leaderNodeRespons, @Nullable List<? extends FailedNodeException> failures) {
        super(clusterName, leaderNodeRespons, failures);
        this.remoteStats = new LinkedHashMap();
        this.stats = new RemoteShardMetric.RemoteStatsFrag();
        if (leaderNodeRespons != null) {
            for (LeaderNodeStatsResponse response2 : leaderNodeRespons) {
                for (Map.Entry<ShardId, RemoteShardMetric.RemoteStats> entry : response2.getRemoteStats().entrySet()) {
                    String string;
                    Map<String, RemoteShardMetric.RemoteStats> map = this.remoteStats;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getKey().getIndexName(), (String)"getIndexName(...)");
                    String string2 = entry.getKey().getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIndexName(...)");
                    RemoteShardMetric.RemoteStats remoteStats = this.remoteStats.getOrDefault(string2, new RemoteShardMetric.RemoteStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null));
                    map.put(string, remoteStats);
                    RemoteShardMetric.RemoteStats remoteStats2 = this.remoteStats.get(entry.getKey().getIndexName());
                    Intrinsics.checkNotNull((Object)remoteStats2);
                    remoteStats2.add(entry.getValue());
                    this.stats.add(entry.getValue());
                }
            }
        }
    }

    @NotNull
    protected List<LeaderNodeStatsResponse> readNodesFrom(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        List list = inp.readList(arg_0 -> LeaderStatsResponse.readNodesFrom$lambda$0(inp, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        return list;
    }

    protected void writeNodesTo(@NotNull StreamOutput out, @Nullable List<LeaderNodeStatsResponse> leaderNodeRespons) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeList(leaderNodeRespons);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        builder.field("num_replicated_indices", this.remoteStats.size());
        this.stats.toXContent(builder, params);
        builder.field("index_stats").map(this.remoteStats);
        builder.endObject();
        return builder;
    }

    @NotNull
    public String toString() {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().prettyPrint();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"prettyPrint(...)");
        XContentBuilder builder = xContentBuilder;
        this.toXContent(builder, ToXContent.EMPTY_PARAMS);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final LeaderNodeStatsResponse readNodesFrom$lambda$0(StreamInput $inp, StreamInput it) {
        Intrinsics.checkNotNullParameter((Object)$inp, (String)"$inp");
        return new LeaderNodeStatsResponse($inp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/replication/action/stats/LeaderStatsResponse$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

