/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.stats;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.timeseries.stats.TimeSeriesStat;

public class Stats {
    private Map<String, TimeSeriesStat<?>> stats;

    public Stats(Map<String, TimeSeriesStat<?>> stats) {
        this.stats = stats;
    }

    public Map<String, TimeSeriesStat<?>> getStats() {
        return this.stats;
    }

    public TimeSeriesStat<?> getStat(String key) throws IllegalArgumentException {
        if (!this.stats.keySet().contains(key)) {
            throw new IllegalArgumentException("Stat=\"" + key + "\" does not exist");
        }
        return this.stats.get(key);
    }

    public Map<String, TimeSeriesStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, TimeSeriesStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, TimeSeriesStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<String, TimeSeriesStat<?>> entry : this.stats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }
}

