/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.util.ParseUtils;

public class DateRange
implements ToXContentObject,
Writeable {
    public static final String START_TIME_FIELD = "start_time";
    public static final String END_TIME_FIELD = "end_time";
    private final Instant startTime;
    private final Instant endTime;

    public DateRange(Instant startTime, Instant endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.validate();
    }

    public DateRange(StreamInput in) throws IOException {
        this.startTime = in.readInstant();
        this.endTime = in.readInstant();
        this.validate();
    }

    private void validate() {
        if (this.startTime == null) {
            throw new IllegalArgumentException("Detection data range's start time must not be null");
        }
        if (this.endTime == null) {
            throw new IllegalArgumentException("Detection data range's end time must not be null");
        }
        if (this.startTime.isAfter(this.endTime)) {
            throw new IllegalArgumentException("Detection data range's end time must be after start time");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(START_TIME_FIELD, this.startTime.toEpochMilli());
        xContentBuilder.field(END_TIME_FIELD, this.endTime.toEpochMilli());
        return xContentBuilder.endObject();
    }

    public static DateRange parse(XContentParser parser) throws IOException {
        Instant startTime = null;
        Instant endTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "start_time": {
                    startTime = ParseUtils.toInstant(parser);
                    continue block8;
                }
                case "end_time": {
                    endTime = ParseUtils.toInstant(parser);
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new DateRange(startTime, endTime);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange that = (DateRange)o;
        return Objects.equal((Object)this.getStartTime(), (Object)that.getStartTime()) && Objects.equal((Object)this.getEndTime(), (Object)that.getEndTime());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getStartTime(), this.getEndTime()});
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append("startTime", (Object)this.startTime).append("endTime", (Object)this.endTime).toString();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.startTime);
        out.writeInstant(this.endTime);
    }
}

