/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.rest.RestRequest;

public class IndexForecasterRequest
extends ActionRequest {
    private String forecastID;
    private long seqNo;
    private long primaryTerm;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private Forecaster forecaster;
    private RestRequest.Method method;
    private TimeValue requestTimeout;
    private Integer maxSingleStreamForecasters;
    private Integer maxHCForecasters;
    private Integer maxForecastFeatures;
    private Integer maxCategoricalFields;

    public IndexForecasterRequest(StreamInput in) throws IOException {
        super(in);
        this.forecastID = in.readString();
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.refreshPolicy = (WriteRequest.RefreshPolicy)in.readEnum(WriteRequest.RefreshPolicy.class);
        this.forecaster = new Forecaster(in);
        this.method = (RestRequest.Method)in.readEnum(RestRequest.Method.class);
        this.requestTimeout = in.readTimeValue();
        this.maxSingleStreamForecasters = in.readInt();
        this.maxHCForecasters = in.readInt();
        this.maxForecastFeatures = in.readInt();
        this.maxCategoricalFields = in.readInt();
    }

    public IndexForecasterRequest(String forecasterID, long seqNo, long primaryTerm, WriteRequest.RefreshPolicy refreshPolicy, Forecaster forecaster, RestRequest.Method method, TimeValue requestTimeout, Integer maxSingleEntityAnomalyDetectors, Integer maxMultiEntityAnomalyDetectors, Integer maxAnomalyFeatures, Integer maxCategoricalFields) {
        this.forecastID = forecasterID;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.forecaster = forecaster;
        this.method = method;
        this.requestTimeout = requestTimeout;
        this.maxSingleStreamForecasters = maxSingleEntityAnomalyDetectors;
        this.maxHCForecasters = maxMultiEntityAnomalyDetectors;
        this.maxForecastFeatures = maxAnomalyFeatures;
        this.maxCategoricalFields = maxCategoricalFields;
    }

    public String getForecasterID() {
        return this.forecastID;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public Forecaster getForecaster() {
        return this.forecaster;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getMaxSingleStreamForecasters() {
        return this.maxSingleStreamForecasters;
    }

    public Integer getMaxHCForecasters() {
        return this.maxHCForecasters;
    }

    public Integer getMaxForecastFeatures() {
        return this.maxForecastFeatures;
    }

    public Integer getMaxCategoricalFields() {
        return this.maxCategoricalFields;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.forecastID);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeEnum((Enum)this.refreshPolicy);
        this.forecaster.writeTo(out);
        out.writeEnum((Enum)this.method);
        out.writeTimeValue(this.requestTimeout);
        out.writeInt(this.maxSingleStreamForecasters.intValue());
        out.writeInt(this.maxHCForecasters.intValue());
        out.writeInt(this.maxForecastFeatures.intValue());
        out.writeInt(this.maxCategoricalFields.intValue());
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

