/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.forecast.ratelimit.ForecastCheckpointReadWorker;
import org.opensearch.forecast.ratelimit.ForecastColdStartWorker;
import org.opensearch.forecast.transport.ForecastRunOnceProfileAction;
import org.opensearch.forecast.transport.ForecastRunOnceProfileNodeRequest;
import org.opensearch.forecast.transport.ForecastRunOnceProfileNodeResponse;
import org.opensearch.forecast.transport.ForecastRunOnceProfileRequest;
import org.opensearch.forecast.transport.ForecastRunOnceProfileResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.transport.TransportService;

public class ForecastRunOnceProfileTransportAction
extends TransportNodesAction<ForecastRunOnceProfileRequest, ForecastRunOnceProfileResponse, ForecastRunOnceProfileNodeRequest, ForecastRunOnceProfileNodeResponse> {
    private static final Logger LOG = LogManager.getLogger(ForecastRunOnceProfileTransportAction.class);
    private final ForecastColdStartWorker coldStartWorker;
    private final ForecastCheckpointReadWorker checkpointReadWorker;
    private final NodeStateManager nodeStateManager;

    @Inject
    public ForecastRunOnceProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Settings settings, ForecastColdStartWorker coldStartWorker, ForecastCheckpointReadWorker checkpointReadWorker, NodeStateManager nodeStateManager) {
        super(ForecastRunOnceProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, ForecastRunOnceProfileRequest::new, ForecastRunOnceProfileNodeRequest::new, "management", ForecastRunOnceProfileNodeResponse.class);
        this.coldStartWorker = coldStartWorker;
        this.checkpointReadWorker = checkpointReadWorker;
        this.nodeStateManager = nodeStateManager;
    }

    protected ForecastRunOnceProfileResponse newResponse(ForecastRunOnceProfileRequest request, List<ForecastRunOnceProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new ForecastRunOnceProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ForecastRunOnceProfileNodeRequest newNodeRequest(ForecastRunOnceProfileRequest request) {
        return new ForecastRunOnceProfileNodeRequest(request);
    }

    protected ForecastRunOnceProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ForecastRunOnceProfileNodeResponse(in);
    }

    protected ForecastRunOnceProfileNodeResponse nodeOperation(ForecastRunOnceProfileNodeRequest request) {
        String configId = request.getConfigId();
        Optional<Exception> exception = this.nodeStateManager.fetchExceptionAndClear(configId);
        if (exception.isPresent()) {
            LOG.error("Run-once execution failed for config {} on node {}", (Object)configId, (Object)this.clusterService.localNode().getId(), exception);
        }
        return new ForecastRunOnceProfileNodeResponse(this.clusterService.localNode(), this.coldStartWorker.hasInflightRequest(configId) || this.checkpointReadWorker.hasInflightRequest(configId) || this.coldStartWorker.hasConfigIdInQueue(configId) || this.checkpointReadWorker.hasConfigIdInQueue(configId), exception.isEmpty() ? null : ExceptionUtil.getErrorMessage(exception.get()));
    }
}

