/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.DoublesMergeImpl;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.DoublesUnionImplR;
import com.yahoo.sketches.quantiles.DoublesUtil;
import com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;

final class DoublesUnionImpl
extends DoublesUnionImplR {
    private DoublesUnionImpl(int maxK) {
        super(maxK);
    }

    static DoublesUnionImpl heapInstance(int maxK) {
        return new DoublesUnionImpl(maxK);
    }

    static DoublesUnionImpl directInstance(int maxK, WritableMemory dstMem) {
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.newInstance(maxK, dstMem);
        DoublesUnionImpl union = new DoublesUnionImpl(maxK);
        union.maxK_ = maxK;
        union.gadget_ = sketch;
        return union;
    }

    static DoublesUnionImpl heapifyInstance(DoublesSketch sketch) {
        int k = sketch.getK();
        DoublesUnionImpl union = new DoublesUnionImpl(k);
        union.maxK_ = k;
        union.gadget_ = DoublesUtil.copyToHeap(sketch);
        return union;
    }

    static DoublesUnionImpl heapifyInstance(Memory srcMem) {
        HeapUpdateDoublesSketch sketch = HeapUpdateDoublesSketch.heapifyInstance(srcMem);
        DoublesUnionImpl union = new DoublesUnionImpl(sketch.getK());
        union.gadget_ = sketch;
        return union;
    }

    static DoublesUnionImpl wrapInstance(WritableMemory mem) {
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.wrapInstance(mem);
        DoublesUnionImpl union = new DoublesUnionImpl(sketch.getK());
        union.gadget_ = sketch;
        return union;
    }

    @Override
    public void update(DoublesSketch sketchIn) {
        this.gadget_ = DoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, sketchIn);
    }

    @Override
    public void update(Memory mem) {
        this.gadget_ = DoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, HeapUpdateDoublesSketch.heapifyInstance(mem));
    }

    @Override
    public void update(double dataItem) {
        if (this.gadget_ == null) {
            this.gadget_ = HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        this.gadget_.update(dataItem);
    }

    @Override
    public UpdateDoublesSketch getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        UpdateDoublesSketch ds = this.gadget_;
        this.gadget_ = null;
        return ds;
    }

    @Override
    public void reset() {
        this.gadget_ = null;
    }

    static UpdateDoublesSketch updateLogic(int myMaxK, UpdateDoublesSketch myQS, DoublesSketch other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
            }
        }
        UpdateDoublesSketch ret = null;
        switch (outCase) {
            case 0: {
                ret = null;
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                assert (other != null);
                if (!other.isEstimationMode()) {
                    ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                ret = myMaxK < other.getK() ? other.downSampleInternal(other, myMaxK, null) : DoublesUtil.copyToHeap(other);
                break;
            }
            case 3: {
                assert (other != null);
                assert (myQS != null);
                if (!other.isEstimationMode()) {
                    ret = myQS;
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                if (myQS.getK() <= other.getK()) {
                    DoublesMergeImpl.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                if (myQS.isEmpty()) {
                    if (myQS.isDirect()) {
                        WritableMemory mem = myQS.getMemory();
                        other.putMemory(mem, false);
                        ret = DirectUpdateDoublesSketch.wrapInstance(mem);
                        break;
                    }
                    ret = DoublesUtil.copyToHeap(other);
                    break;
                }
                UpdateDoublesSketch tmp = DoublesSketch.builder().setK(other.getK()).build();
                DoublesMergeImpl.downSamplingMergeInto(myQS, tmp);
                ret = myQS.isDirect() ? DoublesSketch.builder().setK(other.getK()).build(myQS.getMemory()) : DoublesSketch.builder().setK(other.getK()).build();
                DoublesMergeImpl.mergeInto(tmp, ret);
                DoublesMergeImpl.mergeInto(other, ret);
                break;
            }
            case 4: {
                ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
            }
        }
        return ret;
    }
}

