/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.hll.DirectHllArray;
import com.yahoo.sketches.hll.Hll8Array;
import com.yahoo.sketches.hll.HllPairIterator;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class DirectHll8Array
extends DirectHllArray {
    DirectHll8Array(int lgConfigK, WritableMemory wmem) {
        super(lgConfigK, TgtHllType.HLL_8, wmem);
    }

    DirectHll8Array(int lgConfigK, Memory mem) {
        super(lgConfigK, TgtHllType.HLL_8, mem);
    }

    @Override
    HllSketchImpl copy() {
        return Hll8Array.heapify(this.mem);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getLow26(coupon) & configKmask;
        int newVal = HllUtil.getValue(coupon);
        assert (newVal > 0);
        int curVal = this.getSlot(slotNo);
        if (newVal > curVal) {
            this.putSlot(slotNo, newVal);
            DirectHll8Array.hipAndKxQIncrementalUpdate(this, curVal, newVal);
            if (curVal == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll8Array.hll8ArrBytes(this.lgConfigK);
    }

    @Override
    PairIterator iterator() {
        return new DirectHll8Iterator(1 << this.lgConfigK);
    }

    @Override
    final int getSlot(int slotNo) {
        return this.mem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + slotNo)) & 0x3F;
    }

    @Override
    final void putSlot(int slotNo, int value) {
        this.wmem.putByte((long)(PreambleUtil.HLL_BYTE_ARR_START + slotNo), (byte)(value & 0x3F));
    }

    final class DirectHll8Iterator
    extends HllPairIterator {
        DirectHll8Iterator(int lengthPairs) {
            super(lengthPairs);
        }

        @Override
        int value() {
            byte tmp = DirectHll8Array.this.mem.getByte((long)(PreambleUtil.HLL_BYTE_ARR_START + this.index));
            return tmp & 0x3F;
        }
    }
}

