/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.hll.CouponMapping;
import com.yahoo.sketches.hll.CubicInterpolation;
import com.yahoo.sketches.hll.CurMode;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.TgtHllType;
import com.yahoo.sketches.hll.ToByteArrayImpl;

abstract class AbstractCoupons
extends HllSketchImpl {
    AbstractCoupons(int lgConfigK, TgtHllType tgtHllType, CurMode curMode) {
        super(lgConfigK, tgtHllType, curMode);
    }

    @Override
    double getCompositeEstimate() {
        return this.getEstimate();
    }

    abstract int getCouponCount();

    abstract int[] getCouponIntArr();

    @Override
    double getEstimate() {
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        return Math.max(est, (double)couponCount);
    }

    abstract int getLgCouponArrInts();

    @Override
    double getLowerBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        double tmp = est / (1.0 + (double)numStdDev * 4.99267578125E-5);
        return Math.max(tmp, (double)couponCount);
    }

    abstract Memory getMemory();

    @Override
    double getUpperBound(int numStdDev) {
        HllUtil.checkNumStdDev(numStdDev);
        int couponCount = this.getCouponCount();
        double est = CubicInterpolation.usingXAndYTables(CouponMapping.xArr, CouponMapping.yArr, couponCount);
        double tmp = est / (1.0 - (double)numStdDev * 4.99267578125E-5);
        return Math.max(tmp, (double)couponCount);
    }

    @Override
    int getUpdatableSerializationBytes() {
        return this.getMemDataStart() + (4 << this.getLgCouponArrInts());
    }

    @Override
    boolean isEmpty() {
        return this.getCouponCount() == 0;
    }

    @Override
    byte[] toCompactByteArray() {
        return ToByteArrayImpl.toCouponByteArray(this, true);
    }

    @Override
    byte[] toUpdatableByteArray() {
        return ToByteArrayImpl.toCouponByteArray(this, false);
    }

    static final int find(int[] array, int lgArrInts, int coupon) {
        int stride;
        int probe;
        int arrMask = array.length - 1;
        int loopIndex = probe = coupon & arrMask;
        do {
            int couponAtIdx;
            if ((couponAtIdx = array[probe]) == 0) {
                return ~probe;
            }
            if (coupon != couponAtIdx) continue;
            return probe;
        } while ((probe = probe + (stride = (coupon & 0x3FFFFFF) >>> lgArrInts | 1) & arrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }
}

