/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.VisitorFactory;
import com.amazon.randomcutforest.anomalydetection.AnomalyAttributionVisitor;
import com.amazon.randomcutforest.anomalydetection.AnomalyScoreVisitor;
import com.amazon.randomcutforest.anomalydetection.DynamicAttributionVisitor;
import com.amazon.randomcutforest.anomalydetection.DynamicScoreVisitor;
import com.amazon.randomcutforest.anomalydetection.SimulatedTransductiveScalarScoreVisitor;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.executor.AbstractForestTraversalExecutor;
import com.amazon.randomcutforest.executor.AbstractForestUpdateExecutor;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.ITraversable;
import com.amazon.randomcutforest.executor.ParallelForestTraversalExecutor;
import com.amazon.randomcutforest.executor.ParallelForestUpdateExecutor;
import com.amazon.randomcutforest.executor.PointStoreCoordinator;
import com.amazon.randomcutforest.executor.SamplerPlusTree;
import com.amazon.randomcutforest.executor.SequentialForestTraversalExecutor;
import com.amazon.randomcutforest.executor.SequentialForestUpdateExecutor;
import com.amazon.randomcutforest.imputation.ConditionalSampleSummarizer;
import com.amazon.randomcutforest.imputation.ImputeVisitor;
import com.amazon.randomcutforest.inspect.NearNeighborVisitor;
import com.amazon.randomcutforest.interpolation.SimpleInterpolationVisitor;
import com.amazon.randomcutforest.returntypes.ConditionalTreeSample;
import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;
import com.amazon.randomcutforest.returntypes.DensityOutput;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.InterpolationMeasure;
import com.amazon.randomcutforest.returntypes.Neighbor;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDiVectorAccumulator;
import com.amazon.randomcutforest.returntypes.OneSidedConvergingDoubleAccumulator;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.sampler.AbstractStreamSampler;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.PointStore;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.RandomCutTree;
import com.amazon.randomcutforest.util.ShingleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class RandomCutForest {
    public static final int DEFAULT_SAMPLE_SIZE = 256;
    public static final double DEFAULT_OUTPUT_AFTER_FRACTION = 0.25;
    public static final double DEFAULT_SAMPLE_SIZE_COEFFICIENT_IN_TIME_DECAY = 10.0;
    public static final int DEFAULT_NUMBER_OF_TREES = 50;
    public static final boolean DEFAULT_STORE_SEQUENCE_INDEXES_ENABLED = false;
    public static final double DEFAULT_INITIAL_ACCEPT_FRACTION = 1.0;
    public static final boolean DEFAULT_DYNAMIC_RESIZING_ENABLED = true;
    public static final boolean DEFAULT_INTERNAL_SHINGLING_ENABLED = false;
    public static final boolean DEFAULT_INTERNAL_ROTATION_ENABLED = false;
    public static final boolean DEFAULT_DIRECT_LOCATION_MAP = false;
    public static final Precision DEFAULT_PRECISION = Precision.FLOAT_32;
    public static final double DEFAULT_BOUNDING_BOX_CACHE_FRACTION = 1.0;
    public static final boolean DEFAULT_CENTER_OF_MASS_ENABLED = false;
    public static final int DEFAULT_SHINGLE_SIZE = 1;
    public static final boolean DEFAULT_PARALLEL_EXECUTION_ENABLED = false;
    public static final boolean DEFAULT_APPROXIMATE_ANOMALY_SCORE_HIGH_IS_CRITICAL = true;
    public static final double DEFAULT_APPROXIMATE_DYNAMIC_SCORE_PRECISION = 0.1;
    public static final int DEFAULT_APPROXIMATE_DYNAMIC_SCORE_MIN_VALUES_ACCEPTED = 5;
    protected Random random;
    protected final int dimensions;
    protected final int sampleSize;
    protected final int shingleSize;
    protected final int inputDimensions;
    protected final int outputAfter;
    protected final int numberOfTrees;
    protected double timeDecay;
    protected final boolean storeSequenceIndexesEnabled;
    protected final boolean internalShinglingEnabled;
    protected final double boundingBoxCacheFraction;
    protected final boolean centerOfMassEnabled;
    protected final boolean parallelExecutionEnabled;
    protected final int threadPoolSize;
    protected String executionMode;
    protected IStateCoordinator<?, float[]> stateCoordinator;
    protected ComponentList<?, float[]> components;
    private boolean outputReady;
    private final int initialPointStoreSize;
    private final int pointStoreCapacity;
    protected AbstractForestTraversalExecutor traversalExecutor;
    protected AbstractForestUpdateExecutor<?, float[]> updateExecutor;

    public <P> RandomCutForest(Builder<?> builder, IStateCoordinator<P, float[]> stateCoordinator, ComponentList<P, float[]> components, Random random) {
        this(builder, false);
        CommonUtils.checkNotNull(stateCoordinator, "updateCoordinator must not be null");
        CommonUtils.checkNotNull(components, "componentModels must not be null");
        CommonUtils.checkNotNull(random, "random must not be null");
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.random = random;
        this.initExecutors(stateCoordinator, components);
    }

    public RandomCutForest(Builder<?> builder) {
        this(builder, false);
        this.random = builder.getRandom();
        PointStore tempStore = ((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)PointStore.builder().internalRotationEnabled(builder.internalRotationEnabled)).capacity(this.pointStoreCapacity)).initialSize(this.initialPointStoreSize)).internalShinglingEnabled(this.internalShinglingEnabled)).shingleSize(this.shingleSize)).dimensions(this.dimensions)).build();
        PointStoreCoordinator<float[]> stateCoordinator = new PointStoreCoordinator<float[]>(tempStore);
        ComponentList components = new ComponentList(this.numberOfTrees);
        for (int i = 0; i < this.numberOfTrees; ++i) {
            RandomCutTree tree = ((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)new RandomCutTree.Builder().capacity(this.sampleSize)).randomSeed(this.random.nextLong())).pointStoreView(tempStore)).boundingBoxCacheFraction(this.boundingBoxCacheFraction)).centerOfMassEnabled(this.centerOfMassEnabled)).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).outputAfter(1)).build();
            CompactSampler sampler = ((CompactSampler.Builder)((AbstractStreamSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)CompactSampler.builder().capacity(this.sampleSize)).timeDecay(this.timeDecay)).randomSeed(this.random.nextLong())).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).initialAcceptFraction(builder.initialAcceptFraction)).build();
            components.add(new SamplerPlusTree<Integer, float[]>(sampler, tree));
        }
        this.stateCoordinator = stateCoordinator;
        this.components = components;
        this.initExecutors(stateCoordinator, components);
    }

    protected <PointReference> void initExecutors(IStateCoordinator<PointReference, float[]> updateCoordinator, ComponentList<PointReference, float[]> components) {
        if (this.parallelExecutionEnabled) {
            this.traversalExecutor = new ParallelForestTraversalExecutor(components, this.threadPoolSize);
            this.updateExecutor = new ParallelForestUpdateExecutor(updateCoordinator, components, this.threadPoolSize);
        } else {
            this.traversalExecutor = new SequentialForestTraversalExecutor(components);
            this.updateExecutor = new SequentialForestUpdateExecutor(updateCoordinator, components);
        }
    }

    protected RandomCutForest(Builder<?> builder, boolean notUsed) {
        CommonUtils.checkArgument(((Builder)builder).numberOfTrees > 0, "numberOfTrees must be greater than 0");
        CommonUtils.checkArgument(((Builder)builder).sampleSize > 0, "sampleSize must be greater than 0");
        ((Builder)builder).outputAfter.ifPresent(n -> CommonUtils.checkArgument(n > 0, "outputAfter must be greater than 0"));
        CommonUtils.checkArgument(((Builder)builder).dimensions > 0, "dimensions must be greater than 0");
        ((Builder)builder).timeDecay.ifPresent(timeDecay -> CommonUtils.checkArgument(timeDecay >= 0.0, "timeDecay must be greater than or equal to 0"));
        ((Builder)builder).threadPoolSize.ifPresent(n -> {
            CommonUtils.checkArgument(n >= 0, "cannot be negative");
            CommonUtils.checkArgument(n > 0 || !((Builder)builder).parallelExecutionEnabled, "threadPoolSize must be greater/equal than 0. To disable thread pool, set parallel execution to 'false'.");
        });
        CommonUtils.checkArgument(((Builder)builder).shingleSize == 1 || ((Builder)builder).dimensions % ((Builder)builder).shingleSize == 0, "wrong shingle size");
        if (builder.internalRotationEnabled) {
            CommonUtils.checkArgument(((Builder)builder).internalShinglingEnabled, " enable internal shingling");
        }
        builder.initialPointStoreSize.ifPresent(n -> CommonUtils.checkArgument(n > 0, "initial point store must be greater than 0"));
        CommonUtils.checkArgument(((Builder)builder).boundingBoxCacheFraction >= 0.0, "cache cannot be negative");
        CommonUtils.checkArgument(((Builder)builder).boundingBoxCacheFraction <= 1.0, "incorrect cache fraction range");
        this.numberOfTrees = ((Builder)builder).numberOfTrees;
        this.sampleSize = ((Builder)builder).sampleSize;
        this.outputAfter = ((Builder)builder).outputAfter.orElse(Math.max(1, (int)((double)this.sampleSize * 0.25)));
        this.internalShinglingEnabled = ((Builder)builder).internalShinglingEnabled;
        this.shingleSize = ((Builder)builder).shingleSize;
        this.dimensions = ((Builder)builder).dimensions;
        this.timeDecay = ((Builder)builder).timeDecay.orElse(1.0 / (10.0 * (double)this.sampleSize));
        this.storeSequenceIndexesEnabled = ((Builder)builder).storeSequenceIndexesEnabled;
        this.centerOfMassEnabled = ((Builder)builder).centerOfMassEnabled;
        this.parallelExecutionEnabled = ((Builder)builder).parallelExecutionEnabled;
        this.boundingBoxCacheFraction = ((Builder)builder).boundingBoxCacheFraction;
        ((Builder)builder).directLocationMapEnabled = ((Builder)builder).directLocationMapEnabled || this.shingleSize == 1;
        this.inputDimensions = this.internalShinglingEnabled ? this.dimensions / this.shingleSize : this.dimensions;
        this.pointStoreCapacity = Math.max(this.sampleSize * this.numberOfTrees + 1, 2 * this.sampleSize);
        this.initialPointStoreSize = builder.initialPointStoreSize.orElse(2 * this.sampleSize);
        this.threadPoolSize = this.parallelExecutionEnabled ? ((Builder)builder).threadPoolSize.orElse(Runtime.getRuntime().availableProcessors() - 1) : 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RandomCutForest defaultForest(int dimensions, long randomSeed) {
        return ((Builder)((Builder)RandomCutForest.builder().dimensions(dimensions)).randomSeed(randomSeed)).build();
    }

    public static RandomCutForest defaultForest(int dimensions) {
        return ((Builder)RandomCutForest.builder().dimensions(dimensions)).build();
    }

    public int getNumberOfTrees() {
        return this.numberOfTrees;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getShingleSize() {
        return this.shingleSize;
    }

    public int getOutputAfter() {
        return this.outputAfter;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public double getTimeDecay() {
        return this.timeDecay;
    }

    public boolean isStoreSequenceIndexesEnabled() {
        return this.storeSequenceIndexesEnabled;
    }

    public Precision getPrecision() {
        return Precision.FLOAT_32;
    }

    @Deprecated
    public boolean isCompact() {
        return true;
    }

    public boolean isInternalShinglingEnabled() {
        return this.internalShinglingEnabled;
    }

    public boolean isCenterOfMassEnabled() {
        return this.centerOfMassEnabled;
    }

    public boolean isParallelExecutionEnabled() {
        return this.parallelExecutionEnabled;
    }

    public double getBoundingBoxCacheFraction() {
        return this.boundingBoxCacheFraction;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public IStateCoordinator<?, ?> getUpdateCoordinator() {
        return this.stateCoordinator;
    }

    public ComponentList<?, ?> getComponents() {
        return this.components;
    }

    public float[] transformToShingledPoint(float[] point) {
        return this.stateCoordinator.getStore().transformToShingledPoint(point);
    }

    public boolean isRotationEnabled() {
        return this.stateCoordinator.getStore().isInternalRotationEnabled();
    }

    protected int[] transformIndices(int[] indexList, int length) {
        return this.internalShinglingEnabled && length == this.inputDimensions ? this.stateCoordinator.getStore().transformIndices(indexList) : indexList;
    }

    public float[] lastShingledPoint() {
        CommonUtils.checkArgument(this.internalShinglingEnabled, "incorrect use");
        return this.stateCoordinator.getStore().getInternalShingle();
    }

    public long nextSequenceIndex() {
        return this.stateCoordinator.getStore().getNextSequenceIndex();
    }

    public void update(float[] point, boolean updateShingleOnly) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(this.internalShinglingEnabled || point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        CommonUtils.checkArgument(!this.internalShinglingEnabled || point.length == this.inputDimensions, String.format("point.length must equal %d for internal shingling", this.inputDimensions));
        CommonUtils.checkArgument(!updateShingleOnly || this.internalShinglingEnabled, "update shingle setting is only valid for internal shingling");
        this.updateExecutor.update(point, updateShingleOnly);
    }

    @Deprecated
    public void update(double[] point) {
        this.update(CommonUtils.toFloatArray(point), false);
    }

    public void update(float[] point) {
        this.update(point, false);
    }

    public void update(double[] point, long sequenceNum) {
        CommonUtils.checkNotNull(point, "point must not be null");
        this.update(CommonUtils.toFloatArray(point), sequenceNum);
    }

    public void update(float[] point, long sequenceNum) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(!this.internalShinglingEnabled, "cannot be applied with internal shingling");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        this.updateExecutor.update(point, sequenceNum);
    }

    public void setBoundingBoxCacheFraction(double cacheFraction) {
        CommonUtils.checkArgument(0.0 <= cacheFraction, "cache cannot be negative");
        CommonUtils.checkArgument(cacheFraction <= 1.0, "cacheFraction must be between 0 and 1 (inclusive)");
        this.updateExecutor.getComponents().forEach(c -> c.setConfig("bounding_box_cache_fraction", cacheFraction));
    }

    public void setTimeDecay(double timeDecay) {
        CommonUtils.checkArgument(0.0 <= timeDecay, "timeDecay must be greater than or equal to 0");
        this.timeDecay = timeDecay;
        this.updateExecutor.getComponents().forEach(c -> c.setConfig("time_decay", timeDecay));
    }

    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(collector, "collector must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, collector);
    }

    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, ConvergingAccumulator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForest(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForestMulti(float[] point, IMultiVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(accumulator, "accumulator must not be null");
        CommonUtils.checkNotNull(finisher, "finisher must not be null");
        return this.traversalExecutor.traverseForestMulti(point, visitorFactory, accumulator, finisher);
    }

    public <R, S> S traverseForestMulti(float[] point, IMultiVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, () -> "point.length must equal to " + this.dimensions);
        CommonUtils.checkNotNull(visitorFactory, "visitorFactory must not be null");
        CommonUtils.checkNotNull(collector, "collector must not be null");
        return this.traversalExecutor.traverseForestMulti(point, visitorFactory, collector);
    }

    @Deprecated
    public double getAnomalyScore(double[] point) {
        return this.getAnomalyScore(CommonUtils.toFloatArray(point));
    }

    public double getAnomalyScore(float[] point) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        IVisitorFactory visitorFactory = (tree, x) -> new AnomalyScoreVisitor(tree.projectToTree(x), tree.getMass());
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = x -> x / (double)this.numberOfTrees;
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    @Deprecated
    public double getApproximateAnomalyScore(double[] point) {
        return this.getApproximateAnomalyScore(CommonUtils.toFloatArray(point));
    }

    public double getApproximateAnomalyScore(float[] point) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        IVisitorFactory visitorFactory = (tree, x) -> new AnomalyScoreVisitor(tree.projectToTree(x), tree.getMass());
        OneSidedConvergingDoubleAccumulator accumulator = new OneSidedConvergingDoubleAccumulator(true, 0.1, 5, this.numberOfTrees);
        Function<Double, Double> finisher = x -> x / (double)accumulator.getValuesAccepted();
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getAnomalyAttribution(double[] point) {
        return this.getAnomalyAttribution(CommonUtils.toFloatArray(point));
    }

    public DiVector getAnomalyAttribution(float[] point) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new AnomalyAttributionVisitor(tree.projectToTree((float[])y), tree.getMass()), (tree, x) -> x.lift(tree::liftFromTree));
        BinaryOperator accumulator = DiVector::addToLeft;
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)this.numberOfTrees);
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getApproximateAnomalyAttribution(double[] point) {
        return this.getApproximateAnomalyAttribution(CommonUtils.toFloatArray(point));
    }

    public DiVector getApproximateAnomalyAttribution(float[] point) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new AnomalyAttributionVisitor(tree.projectToTree((float[])y), tree.getMass()), (tree, x) -> x.lift(tree::liftFromTree));
        OneSidedConvergingDiVectorAccumulator accumulator = new OneSidedConvergingDiVectorAccumulator(this.dimensions, true, 0.1, 5, this.numberOfTrees);
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)accumulator.getValuesAccepted());
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    @Deprecated
    public DensityOutput getSimpleDensity(double[] point) {
        return this.getSimpleDensity(CommonUtils.toFloatArray(point));
    }

    public DensityOutput getSimpleDensity(float[] point) {
        if (!this.isOutputReady()) {
            return new DensityOutput(this.dimensions, this.sampleSize);
        }
        VisitorFactory<InterpolationMeasure> visitorFactory = new VisitorFactory<InterpolationMeasure>((tree, y) -> new SimpleInterpolationVisitor(tree.projectToTree((float[])y), tree.getMass(), 1.0, this.centerOfMassEnabled), (tree, x) -> x.lift(tree::liftFromTree));
        Collector<InterpolationMeasure, InterpolationMeasure, InterpolationMeasure> collector = InterpolationMeasure.collector(this.dimensions, 0, this.numberOfTrees);
        DensityOutput a = new DensityOutput(this.traverseForest(this.transformToShingledPoint(point), visitorFactory, collector));
        return new DensityOutput(this.traverseForest(this.transformToShingledPoint(point), visitorFactory, collector));
    }

    protected List<ConditionalTreeSample> getConditionalField(float[] point, int[] missingIndexes, double centrality) {
        CommonUtils.checkArgument(centrality >= 0.0, " cannot be negative");
        CommonUtils.checkArgument(centrality <= 1.0, "centrality needs to be in range [0,1]");
        CommonUtils.checkArgument(point != null, " cannot be null");
        if (!this.isOutputReady()) {
            return new ArrayList<ConditionalTreeSample>();
        }
        int[] liftedIndices = this.transformIndices(missingIndexes, point.length);
        IMultiVisitorFactory visitorFactory = (tree, y) -> new ImputeVisitor(y, tree.projectToTree(y), liftedIndices, tree.projectMissingIndices(liftedIndices), centrality, tree.getRandomSeed());
        return this.traverseForestMulti(this.transformToShingledPoint(point), visitorFactory, ConditionalTreeSample.collector);
    }

    public SampleSummary getConditionalFieldSummary(float[] point, int[] missingIndexes, int numberOfRepresentatives, double shrinkage, boolean addtypical, boolean project, double centrality, int shingleSize) {
        CommonUtils.checkArgument(centrality >= 0.0, " cannot be negative");
        CommonUtils.checkArgument(centrality <= 1.0, "centrality needs to be in range [0,1]");
        CommonUtils.checkArgument(point != null, " cannot be null");
        if (!this.isOutputReady()) {
            return new SampleSummary(this.dimensions);
        }
        int[] liftedIndices = this.transformIndices(missingIndexes, point.length);
        ConditionalSampleSummarizer summarizer = new ConditionalSampleSummarizer(liftedIndices, this.transformToShingledPoint(point), centrality, project, numberOfRepresentatives, shrinkage, shingleSize);
        return summarizer.summarize(this.getConditionalField(point, missingIndexes, centrality), addtypical);
    }

    public float[] imputeMissingValues(float[] point, int[] missingIndexes) {
        return this.getConditionalFieldSummary((float[])point, (int[])missingIndexes, (int)1, (double)0.0, (boolean)false, (boolean)false, (double)1.0, (int)1).median;
    }

    @Deprecated
    public float[] imputeMissingValues(float[] point, int numberOfMissingValues, int[] missingIndexes) {
        return this.imputeMissingValues(point, missingIndexes);
    }

    @Deprecated
    public double[] imputeMissingValues(double[] point, int numberOfMissingValues, int[] missingIndexes) {
        return CommonUtils.toDoubleArray(this.imputeMissingValues(CommonUtils.toFloatArray(point), numberOfMissingValues, missingIndexes));
    }

    @Deprecated
    double[] extrapolateBasic(double[] point, int horizon, int blockSize, boolean cyclic, int shingleIndex) {
        return CommonUtils.toDoubleArray(this.extrapolateBasic(CommonUtils.toFloatArray(point), horizon, blockSize, cyclic, shingleIndex));
    }

    @Deprecated
    float[] extrapolateBasic(float[] point, int horizon, int blockSize, boolean cyclic, int shingleIndex) {
        return this.extrapolateWithRanges((float[])point, (int)horizon, (int)blockSize, (boolean)cyclic, (int)shingleIndex, (double)1.0).values;
    }

    public RangeVector extrapolateWithRanges(float[] point, int horizon, int blockSize, boolean cyclic, int shingleIndex, double centrality) {
        CommonUtils.checkArgument(0 < blockSize && blockSize < this.dimensions, "blockSize must be between 0 and dimensions (exclusive)");
        CommonUtils.checkArgument(this.dimensions % blockSize == 0, "dimensions must be evenly divisible by blockSize");
        CommonUtils.checkArgument(0 <= shingleIndex && shingleIndex < this.dimensions / blockSize, "shingleIndex must be between 0 (inclusive) and dimensions / blockSize");
        RangeVector result = new RangeVector(blockSize * horizon);
        int[] missingIndexes = new int[blockSize];
        float[] queryPoint = Arrays.copyOf(point, this.dimensions);
        if (cyclic) {
            this.extrapolateBasicCyclic(result, horizon, blockSize, shingleIndex, queryPoint, missingIndexes, centrality);
        } else {
            this.extrapolateBasicSliding(result, horizon, blockSize, queryPoint, missingIndexes, centrality);
        }
        return result;
    }

    @Deprecated
    RangeVector extrapolateFromShingle(float[] shingle, int horizon, int blockSize, double centrality) {
        return this.extrapolateWithRanges(shingle, horizon, blockSize, this.isRotationEnabled(), (int)this.nextSequenceIndex() % this.shingleSize, centrality);
    }

    @Deprecated
    double[] extrapolateBasic(double[] point, int horizon, int blockSize, boolean cyclic) {
        return CommonUtils.toDoubleArray(this.extrapolateBasic(CommonUtils.toFloatArray(point), horizon, blockSize, cyclic, 0));
    }

    protected float[] extrapolateBasic(float[] point, int horizon, int blockSize, boolean cyclic) {
        return this.extrapolateBasic(point, horizon, blockSize, cyclic, 0);
    }

    @Deprecated
    public double[] extrapolateBasic(ShingleBuilder builder, int horizon) {
        return CommonUtils.toDoubleArray(this.extrapolateBasic(CommonUtils.toFloatArray(builder.getShingle()), horizon, builder.getInputPointSize(), builder.isCyclic(), builder.getShingleIndex()));
    }

    void extrapolateBasicSliding(RangeVector result, int horizon, int blockSize, float[] queryPoint, int[] missingIndexes, double centrality) {
        int resultIndex = 0;
        Arrays.fill(missingIndexes, 0);
        for (int y = 0; y < blockSize; ++y) {
            missingIndexes[y] = this.dimensions - blockSize + y;
        }
        for (int k = 0; k < horizon; ++k) {
            System.arraycopy(queryPoint, blockSize, queryPoint, 0, this.dimensions - blockSize);
            SampleSummary imputedSummary = this.getConditionalFieldSummary(queryPoint, missingIndexes, 1, 0.0, false, false, centrality, this.dimensions / blockSize);
            for (int y = 0; y < blockSize; ++y) {
                float f = imputedSummary.median[y];
                queryPoint[this.dimensions - blockSize + y] = f;
                result.values[resultIndex] = f;
                result.lower[resultIndex] = imputedSummary.lower[y];
                result.upper[resultIndex] = imputedSummary.upper[y];
                ++resultIndex;
            }
        }
    }

    void extrapolateBasicCyclic(RangeVector result, int horizon, int blockSize, int shingleIndex, float[] queryPoint, int[] missingIndexes, double centrality) {
        int resultIndex = 0;
        int currentPosition = shingleIndex;
        Arrays.fill(missingIndexes, 0);
        for (int k = 0; k < horizon; ++k) {
            for (int y = 0; y < blockSize; ++y) {
                missingIndexes[y] = (currentPosition + y) % this.dimensions;
            }
            SampleSummary imputedSummary = this.getConditionalFieldSummary(queryPoint, missingIndexes, 1, 0.0, false, false, centrality, 1);
            for (int y = 0; y < blockSize; ++y) {
                float f = imputedSummary.median[(currentPosition + y) % this.dimensions];
                queryPoint[(currentPosition + y) % this.dimensions] = f;
                result.values[resultIndex] = f;
                result.lower[resultIndex] = imputedSummary.lower[(currentPosition + y) % this.dimensions];
                result.upper[resultIndex] = imputedSummary.upper[(currentPosition + y) % this.dimensions];
                ++resultIndex;
            }
            currentPosition = (currentPosition + blockSize) % this.dimensions;
        }
    }

    public double[] extrapolate(int horizon) {
        return CommonUtils.toDoubleArray(this.extrapolateFromCurrentTime(horizon));
    }

    public float[] extrapolateFromCurrentTime(int horizon) {
        CommonUtils.checkArgument(this.internalShinglingEnabled, "incorrect use");
        IPointStore<?, float[]> store = this.stateCoordinator.getStore();
        return this.extrapolateBasic(this.lastShingledPoint(), horizon, this.inputDimensions, store.isInternalRotationEnabled(), (int)this.nextSequenceIndex() % this.shingleSize);
    }

    @Deprecated
    public List<Neighbor> getNearNeighborsInSample(double[] point, double distanceThreshold) {
        return this.getNearNeighborsInSample(CommonUtils.toFloatArray(point), distanceThreshold);
    }

    public List<Neighbor> getNearNeighborsInSample(float[] point, double distanceThreshold) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(distanceThreshold > 0.0, "distanceThreshold must be greater than 0");
        if (!this.isOutputReady()) {
            return Collections.emptyList();
        }
        IVisitorFactory visitorFactory = (tree, x) -> new NearNeighborVisitor(x, distanceThreshold);
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, Neighbor.collector());
    }

    @Deprecated
    public List<Neighbor> getNearNeighborsInSample(double[] point) {
        return this.getNearNeighborsInSample(CommonUtils.toFloatArray(point));
    }

    public List<Neighbor> getNearNeighborsInSample(float[] point) {
        return this.getNearNeighborsInSample(point, Double.POSITIVE_INFINITY);
    }

    public boolean isOutputReady() {
        return this.outputReady || (this.outputReady = this.stateCoordinator.getTotalUpdates() >= (long)this.outputAfter && this.components.stream().allMatch(ITraversable::isOutputReady));
    }

    public boolean samplersFull() {
        return this.stateCoordinator.getTotalUpdates() >= (long)this.sampleSize;
    }

    public long getTotalUpdates() {
        return this.stateCoordinator.getTotalUpdates();
    }

    public void pauseSampling() {
        this.updateExecutor.setCurrentlySampling(false);
    }

    public void resumeSampling() {
        this.updateExecutor.setCurrentlySampling(true);
    }

    public boolean isCurrentlySampling() {
        return this.updateExecutor.isCurrentlySampling();
    }

    public List<ICluster<float[]>> summarize(int maxAllowed, double shrinkage, int numberOfRepresentatives, double separationRatio, BiFunction<float[], float[], Double> distance, List<ICluster<float[]>> previous) {
        return this.stateCoordinator.getStore().summarize(maxAllowed, shrinkage, numberOfRepresentatives, separationRatio, distance, previous);
    }

    public List<ICluster<float[]>> summarize(int maxAllowed, double shrinkage, int numberOfRepresentatives, List<ICluster<float[]>> previous) {
        return this.summarize(maxAllowed, shrinkage, numberOfRepresentatives, Summarizer.DEFAULT_SEPARATION_RATIO_FOR_MERGE, Summarizer::L1distance, previous);
    }

    public double getDynamicScore(float[] point, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp) {
        CommonUtils.checkArgument(ignoreLeafMassThreshold >= 0, "ignoreLeafMassThreshold should be greater than or equal to 0");
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new DynamicScoreVisitor(tree.projectToTree((float[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, damp));
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = sum -> sum / (double)this.numberOfTrees;
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public double getDynamicSimulatedScore(float[] point, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp, Function<IBoundingBoxView, double[]> vecSep) {
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new SimulatedTransductiveScalarScoreVisitor(tree.projectToTree((float[])y), tree.getMass(), seen, unseen, damp, CommonUtils::defaultRCFgVecFunction, vecSep));
        BinaryOperator accumulator = Double::sum;
        Function<Double, Double> finisher = sum -> sum / (double)this.numberOfTrees;
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public double getApproximateDynamicScore(float[] point, double precision, boolean highIsCritical, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> damp) {
        CommonUtils.checkArgument(ignoreLeafMassThreshold >= 0, "ignoreLeafMassThreshold should be greater than or equal to 0");
        if (!this.isOutputReady()) {
            return 0.0;
        }
        VisitorFactory visitorFactory = new VisitorFactory((tree, y) -> new DynamicScoreVisitor(tree.projectToTree((float[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, damp));
        OneSidedConvergingDoubleAccumulator accumulator = new OneSidedConvergingDoubleAccumulator(highIsCritical, precision, 5, this.numberOfTrees);
        Function<Double, Double> finisher = x -> x / (double)accumulator.getValuesAccepted();
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getDynamicAttribution(float[] point, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> newDamp) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new DynamicAttributionVisitor(tree.projectToTree((float[])y), tree.getMass(), ignoreLeafMassThreshold, seen, unseen, newDamp), (tree, x) -> x.lift(tree::liftFromTree));
        BinaryOperator accumulator = DiVector::addToLeft;
        Function<DiVector, DiVector> finisher = x -> x.scale(1.0 / (double)this.numberOfTrees);
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public DiVector getApproximateDynamicAttribution(float[] point, double precision, boolean highIsCritical, int ignoreLeafMassThreshold, BiFunction<Double, Double, Double> seen, BiFunction<Double, Double, Double> unseen, BiFunction<Double, Double, Double> newDamp) {
        if (!this.isOutputReady()) {
            return new DiVector(this.dimensions);
        }
        VisitorFactory<DiVector> visitorFactory = new VisitorFactory<DiVector>((tree, y) -> new DynamicAttributionVisitor((float[])y, tree.getMass(), ignoreLeafMassThreshold, seen, unseen, newDamp), (tree, x) -> x.lift(tree::liftFromTree));
        OneSidedConvergingDiVectorAccumulator accumulator = new OneSidedConvergingDiVectorAccumulator(this.dimensions, highIsCritical, precision, 5, this.numberOfTrees);
        Function<DiVector, DiVector> finisher = vector -> vector.scale(1.0 / (double)accumulator.getValuesAccepted());
        return this.traverseForest(this.transformToShingledPoint(point), visitorFactory, accumulator, finisher);
    }

    public static class Builder<T extends Builder<T>> {
        private int dimensions;
        private int sampleSize = 256;
        private Optional<Integer> outputAfter = Optional.empty();
        private int numberOfTrees = 50;
        private Optional<Double> timeDecay = Optional.empty();
        private Optional<Long> randomSeed = Optional.empty();
        private boolean storeSequenceIndexesEnabled = false;
        private boolean centerOfMassEnabled = false;
        private boolean parallelExecutionEnabled = false;
        private Optional<Integer> threadPoolSize = Optional.empty();
        private boolean directLocationMapEnabled = false;
        private double boundingBoxCacheFraction = 1.0;
        private int shingleSize = 1;
        private boolean internalShinglingEnabled = false;
        protected boolean internalRotationEnabled = false;
        protected Optional<Integer> initialPointStoreSize = Optional.empty();
        protected double initialAcceptFraction = 1.0;

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T initialPointStoreSize(int initialPointStoreSize) {
            this.initialPointStoreSize = Optional.of(initialPointStoreSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        @Deprecated
        public T compact(boolean compact) {
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = internalShinglingEnabled;
            return (T)this;
        }

        public T internalRotationEnabled(boolean internalRotationEnabled) {
            this.internalRotationEnabled = internalRotationEnabled;
            return (T)this;
        }

        @Deprecated
        public T dynamicResizingEnabled(boolean dynamicResizingEnabled) {
            return (T)this;
        }

        @Deprecated
        public T precision(Precision precision) {
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public RandomCutForest build() {
            return new RandomCutForest(this);
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }
    }
}

