/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util.clusterMetricsMonitorHelpers;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndexStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper;", "Lorg/opensearch/core/action/ActionResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "clusterHealthResponse", "Lorg/opensearch/action/admin/cluster/health/ClusterHealthResponse;", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "indexSettingsResponse", "Lorg/opensearch/action/admin/indices/settings/get/GetSettingsResponse;", "indicesStatsResponse", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "(Lorg/opensearch/action/admin/cluster/health/ClusterHealthResponse;Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;Lorg/opensearch/action/admin/indices/settings/get/GetSettingsResponse;Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;)V", "indexInfoList", "", "Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper$IndexInfo;", "getIndexInfoList", "()Ljava/util/List;", "setIndexInfoList", "(Ljava/util/List;)V", "compileIndexInfo", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "IndexInfo", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nCatIndicesHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatIndicesHelpers.kt\norg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,860:1\n1855#2,2:861\n1855#2,2:863\n215#3,2:865\n*S KotlinDebug\n*F\n+ 1 CatIndicesHelpers.kt\norg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper\n*L\n106#1:861,2\n123#1:863,2\n125#1:865,2\n*E\n"})
public final class CatIndicesResponseWrapper
extends ActionResponse
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<IndexInfo> indexInfoList;
    @NotNull
    public static final String WRAPPER_FIELD = "indices";

    public CatIndicesResponseWrapper(@NotNull ClusterHealthResponse clusterHealthResponse, @NotNull ClusterStateResponse clusterStateResponse, @NotNull GetSettingsResponse indexSettingsResponse2, @NotNull IndicesStatsResponse indicesStatsResponse) {
        Intrinsics.checkNotNullParameter((Object)clusterHealthResponse, (String)"clusterHealthResponse");
        Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
        Intrinsics.checkNotNullParameter((Object)indexSettingsResponse2, (String)"indexSettingsResponse");
        Intrinsics.checkNotNullParameter((Object)indicesStatsResponse, (String)"indicesStatsResponse");
        this.indexInfoList = CollectionsKt.emptyList();
        this.indexInfoList = this.compileIndexInfo(clusterHealthResponse, clusterStateResponse, indexSettingsResponse2, indicesStatsResponse);
    }

    @NotNull
    public final List<IndexInfo> getIndexInfoList() {
        return this.indexInfoList;
    }

    public final void setIndexInfoList(@NotNull List<IndexInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.indexInfoList = list;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeList(this.indexInfoList);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.startArray(WRAPPER_FIELD);
        Iterable $this$forEach$iv = this.indexInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexInfo it = (IndexInfo)element$iv;
            boolean bl = false;
            it.toXContent(builder, params);
        }
        builder.endArray();
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    private final List<IndexInfo> compileIndexInfo(ClusterHealthResponse clusterHealthResponse, ClusterStateResponse clusterStateResponse, GetSettingsResponse indexSettingsResponse2, IndicesStatsResponse indicesStatsResponse) {
        Object element$iv;
        List list = new ArrayList();
        Map indicesSettings = indexSettingsResponse2.getIndexToSettings();
        Map indicesHealths = clusterHealthResponse.getIndices();
        Map indicesStats = indicesStatsResponse.getIndices();
        HashMap indicesMetadatas = new HashMap();
        org.opensearch.cluster.metadata.Metadata metadata = clusterStateResponse.getState().getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"getMetadata(...)");
        Object $this$forEach$iv = (Iterable)metadata;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            element$iv = iterator.next();
            IndexMetadata it = (IndexMetadata)element$iv;
            boolean bl = false;
            Map map = indicesMetadatas;
            Intrinsics.checkNotNullExpressionValue((Object)it.getIndex().getName(), (String)"getName(...)");
            Intrinsics.checkNotNull((Object)it);
            IndexMetadata indexMetadata = it;
            map.put(string, indexMetadata);
        }
        Intrinsics.checkNotNull((Object)indicesSettings);
        $this$forEach$iv = indicesSettings;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            CommonStats commonStats;
            CommonStats commonStats2;
            CommonStats commonStats3;
            CommonStats commonStats4;
            CommonStats commonStats5;
            CommonStats commonStats6;
            CommonStats commonStats7;
            CommonStats commonStats8;
            CommonStats commonStats9;
            CommonStats commonStats10;
            CommonStats commonStats11;
            CommonStats commonStats12;
            CommonStats commonStats13;
            CommonStats commonStats14;
            CommonStats commonStats15;
            CommonStats commonStats16;
            CommonStats commonStats17;
            CommonStats commonStats18;
            CommonStats commonStats19;
            CommonStats commonStats20;
            CommonStats commonStats21;
            CommonStats commonStats22;
            CommonStats commonStats23;
            CommonStats commonStats24;
            CommonStats commonStats25;
            CommonStats commonStats26;
            CommonStats commonStats27;
            CommonStats commonStats28;
            CommonStats commonStats29;
            CommonStats commonStats30;
            CommonStats commonStats31;
            CommonStats commonStats32;
            CommonStats commonStats33;
            CommonStats commonStats34;
            CommonStats commonStats35;
            CommonStats commonStats36;
            CommonStats commonStats37;
            CommonStats commonStats38;
            CommonStats commonStats39;
            CommonStats commonStats40;
            CommonStats commonStats41;
            CommonStats commonStats42;
            CommonStats commonStats43;
            CommonStats commonStats44;
            CommonStats commonStats45;
            CommonStats commonStats46;
            CommonStats commonStats47;
            CommonStats commonStats48;
            CommonStats commonStats49;
            CommonStats commonStats50;
            CommonStats commonStats51;
            CommonStats commonStats52;
            CommonStats commonStats53;
            CommonStats commonStats54;
            CommonStats commonStats55;
            CommonStats commonStats56;
            CommonStats commonStats57;
            CommonStats commonStats58;
            CommonStats commonStats59;
            CommonStats commonStats60;
            CommonStats commonStats61;
            CommonStats commonStats62;
            CommonStats commonStats63;
            CommonStats commonStats64;
            CommonStats commonStats65;
            CommonStats commonStats66;
            CommonStats commonStats67;
            CommonStats commonStats68;
            CommonStats commonStats69;
            CommonStats commonStats70;
            CommonStats commonStats71;
            CommonStats commonStats72;
            CommonStats commonStats73;
            CommonStats commonStats74;
            CommonStats commonStats75;
            CommonStats commonStats76;
            CommonStats commonStats77;
            CommonStats commonStats78;
            CommonStats commonStats79;
            CommonStats commonStats80;
            CommonStats commonStats81;
            CommonStats commonStats82;
            CommonStats commonStats83;
            CommonStats commonStats84;
            CommonStats commonStats85;
            CommonStats commonStats86;
            CommonStats commonStats87;
            CommonStats commonStats88;
            CommonStats commonStats89;
            CommonStats commonStats90;
            CommonStats commonStats91;
            CommonStats commonStats92;
            CommonStats commonStats93;
            CommonStats commonStats94;
            CommonStats commonStats95;
            CommonStats commonStats96;
            CommonStats commonStats97;
            CommonStats commonStats98;
            CommonStats commonStats99;
            CommonStats commonStats100;
            CommonStats commonStats101;
            CommonStats commonStats102;
            CommonStats commonStats103;
            CommonStats commonStats104;
            CommonStats commonStats105;
            CommonStats commonStats106;
            CommonStats commonStats107;
            CommonStats commonStats108;
            CommonStats commonStats109;
            CommonStats commonStats110;
            CommonStats commonStats111;
            CommonStats commonStats112;
            CommonStats commonStats113;
            CommonStats commonStats114;
            CommonStats commonStats115;
            CommonStats commonStats116;
            CommonStats commonStats117;
            CommonStats commonStats118;
            CommonStats commonStats119;
            CommonStats commonStats120;
            CommonStats commonStats121;
            CommonStats commonStats122;
            CommonStats commonStats123;
            CommonStats commonStats124;
            IndexMetadata indexMetadata;
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String indexName = (String)object.getKey();
            Settings settings = (Settings)object.getValue();
            if (!indicesMetadatas.containsKey(indexName)) continue;
            IndexMetadata indexMetadata2 = indexMetadata = (IndexMetadata)indicesMetadatas.get(indexName);
            IndexMetadata.State indexState = indexMetadata2 != null ? indexMetadata2.getState() : null;
            IndexStats indexStats = (IndexStats)indicesStats.get(indexName);
            Boolean searchThrottled = (Boolean)IndexSettings.INDEX_SEARCH_THROTTLED.get(settings);
            ClusterIndexHealth indexHealth = (ClusterIndexHealth)indicesHealths.get(indexName);
            String health = "";
            if (indexHealth != null) {
                String string = indexHealth.getStatus().toString();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                health = string2;
            } else if (indexStats != null) {
                health = "red*";
            }
            CommonStats primaryStats = null;
            CommonStats totalStats = null;
            if (indexStats == null || indexState == IndexMetadata.State.CLOSE) {
                primaryStats = new CommonStats();
                totalStats = new CommonStats();
            } else {
                primaryStats = indexStats.getPrimaries();
                totalStats = indexStats.getTotal();
            }
            String string = String.valueOf(indexState);
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            IndexMetadata indexMetadata3 = indexMetadata;
            String string4 = indexMetadata3 != null ? indexMetadata3.getIndexUUID() : null;
            ClusterIndexHealth clusterIndexHealth = indexHealth;
            String string5 = String.valueOf(clusterIndexHealth != null ? Integer.valueOf(clusterIndexHealth.getNumberOfShards()) : null);
            ClusterIndexHealth clusterIndexHealth2 = indexHealth;
            String string6 = String.valueOf(clusterIndexHealth2 != null ? Integer.valueOf(clusterIndexHealth2.getNumberOfReplicas()) : null);
            CommonStats commonStats125 = primaryStats;
            String string7 = String.valueOf(commonStats125 != null && (commonStats125 = commonStats125.getDocs()) != null ? Long.valueOf(commonStats125.getCount()) : null);
            CommonStats commonStats126 = primaryStats;
            String string8 = String.valueOf(commonStats126 != null && (commonStats126 = commonStats126.getDocs()) != null ? Long.valueOf(commonStats126.getDeleted()) : null);
            IndexMetadata indexMetadata4 = indexMetadata;
            String string9 = String.valueOf(indexMetadata4 != null ? Long.valueOf(indexMetadata4.getCreationDate()) : null);
            DateFormatter dateFormatter = DateFormatter.forPattern((String)"strict_date_time");
            IndexMetadata indexMetadata5 = indexMetadata;
            Intrinsics.checkNotNull((Object)indexMetadata5);
            CommonStats commonStats127 = totalStats;
            CommonStats commonStats128 = primaryStats;
            list.add(new IndexInfo(health, string3, indexName, string4, string5, string6, string7, string8, string9, dateFormatter.format((TemporalAccessor)ZonedDateTime.ofInstant(Instant.ofEpochMilli(indexMetadata5.getCreationDate()), ZoneOffset.UTC)), String.valueOf((commonStats124 = totalStats) != null && (commonStats124 = commonStats124.store) != null ? commonStats124.getSize() : null), String.valueOf((commonStats123 = primaryStats) != null && (commonStats123 = commonStats123.store) != null ? commonStats123.getSize() : null), String.valueOf((commonStats122 = totalStats) != null && (commonStats122 = commonStats122.completion) != null ? commonStats122.getSize() : null), String.valueOf((commonStats121 = primaryStats) != null && (commonStats121 = commonStats121.completion) != null ? commonStats121.getSize() : null), String.valueOf((commonStats120 = totalStats) != null && (commonStats120 = commonStats120.fieldData) != null ? commonStats120.getMemorySize() : null), String.valueOf((commonStats119 = primaryStats) != null && (commonStats119 = commonStats119.fieldData) != null ? commonStats119.getMemorySize() : null), String.valueOf((commonStats118 = totalStats) != null && (commonStats118 = commonStats118.fieldData) != null ? Long.valueOf(commonStats118.getEvictions()) : null), String.valueOf((commonStats117 = primaryStats) != null && (commonStats117 = commonStats117.fieldData) != null ? Long.valueOf(commonStats117.getEvictions()) : null), String.valueOf((commonStats116 = totalStats) != null && (commonStats116 = commonStats116.queryCache) != null ? commonStats116.getMemorySize() : null), String.valueOf((commonStats115 = primaryStats) != null && (commonStats115 = commonStats115.queryCache) != null ? commonStats115.getMemorySize() : null), String.valueOf((commonStats114 = totalStats) != null && (commonStats114 = commonStats114.queryCache) != null ? Long.valueOf(commonStats114.getEvictions()) : null), String.valueOf((commonStats113 = primaryStats) != null && (commonStats113 = commonStats113.queryCache) != null ? Long.valueOf(commonStats113.getEvictions()) : null), String.valueOf((commonStats112 = totalStats) != null && (commonStats112 = commonStats112.requestCache) != null ? commonStats112.getMemorySize() : null), String.valueOf((commonStats111 = primaryStats) != null && (commonStats111 = commonStats111.requestCache) != null ? commonStats111.getMemorySize() : null), String.valueOf((commonStats110 = totalStats) != null && (commonStats110 = commonStats110.requestCache) != null ? Long.valueOf(commonStats110.getEvictions()) : null), String.valueOf((commonStats109 = primaryStats) != null && (commonStats109 = commonStats109.requestCache) != null ? Long.valueOf(commonStats109.getEvictions()) : null), String.valueOf((commonStats108 = totalStats) != null && (commonStats108 = commonStats108.requestCache) != null ? Long.valueOf(commonStats108.getHitCount()) : null), String.valueOf((commonStats107 = primaryStats) != null && (commonStats107 = commonStats107.requestCache) != null ? Long.valueOf(commonStats107.getHitCount()) : null), String.valueOf((commonStats106 = totalStats) != null && (commonStats106 = commonStats106.requestCache) != null ? Long.valueOf(commonStats106.getMissCount()) : null), String.valueOf((commonStats105 = primaryStats) != null && (commonStats105 = commonStats105.requestCache) != null ? Long.valueOf(commonStats105.getMissCount()) : null), String.valueOf((commonStats104 = totalStats) != null && (commonStats104 = commonStats104.flush) != null ? Long.valueOf(commonStats104.getTotal()) : null), String.valueOf((commonStats103 = primaryStats) != null && (commonStats103 = commonStats103.flush) != null ? Long.valueOf(commonStats103.getTotal()) : null), String.valueOf((commonStats102 = totalStats) != null && (commonStats102 = commonStats102.flush) != null ? commonStats102.getTotalTime() : null), String.valueOf((commonStats101 = primaryStats) != null && (commonStats101 = commonStats101.flush) != null ? commonStats101.getTotalTime() : null), String.valueOf((commonStats100 = totalStats) != null && (commonStats100 = commonStats100.get) != null ? Long.valueOf(commonStats100.current()) : null), String.valueOf((commonStats99 = primaryStats) != null && (commonStats99 = commonStats99.get) != null ? Long.valueOf(commonStats99.current()) : null), String.valueOf((commonStats98 = totalStats) != null && (commonStats98 = commonStats98.get) != null ? commonStats98.getTime() : null), String.valueOf((commonStats97 = primaryStats) != null && (commonStats97 = commonStats97.get) != null ? commonStats97.getTime() : null), String.valueOf((commonStats96 = totalStats) != null && (commonStats96 = commonStats96.get) != null ? Long.valueOf(commonStats96.getCount()) : null), String.valueOf((commonStats95 = primaryStats) != null && (commonStats95 = commonStats95.get) != null ? Long.valueOf(commonStats95.getCount()) : null), String.valueOf((commonStats94 = totalStats) != null && (commonStats94 = commonStats94.get) != null ? commonStats94.getExistsTime() : null), String.valueOf((commonStats93 = primaryStats) != null && (commonStats93 = commonStats93.get) != null ? commonStats93.getExistsTime() : null), String.valueOf((commonStats92 = totalStats) != null && (commonStats92 = commonStats92.get) != null ? Long.valueOf(commonStats92.getExistsCount()) : null), String.valueOf((commonStats91 = primaryStats) != null && (commonStats91 = commonStats91.get) != null ? Long.valueOf(commonStats91.getExistsCount()) : null), String.valueOf((commonStats90 = totalStats) != null && (commonStats90 = commonStats90.get) != null ? commonStats90.getMissingTime() : null), String.valueOf((commonStats89 = primaryStats) != null && (commonStats89 = commonStats89.get) != null ? commonStats89.getMissingTime() : null), String.valueOf((commonStats88 = totalStats) != null && (commonStats88 = commonStats88.get) != null ? Long.valueOf(commonStats88.getMissingCount()) : null), String.valueOf((commonStats87 = primaryStats) != null && (commonStats87 = commonStats87.get) != null ? Long.valueOf(commonStats87.getMissingCount()) : null), String.valueOf((commonStats86 = totalStats) != null && (commonStats86 = commonStats86.indexing) != null && (commonStats86 = commonStats86.getTotal()) != null ? Long.valueOf(commonStats86.getDeleteCurrent()) : null), String.valueOf((commonStats85 = primaryStats) != null && (commonStats85 = commonStats85.indexing) != null && (commonStats85 = commonStats85.getTotal()) != null ? Long.valueOf(commonStats85.getDeleteCurrent()) : null), String.valueOf((commonStats84 = totalStats) != null && (commonStats84 = commonStats84.indexing) != null && (commonStats84 = commonStats84.getTotal()) != null ? commonStats84.getDeleteTime() : null), String.valueOf((commonStats83 = primaryStats) != null && (commonStats83 = commonStats83.indexing) != null && (commonStats83 = commonStats83.getTotal()) != null ? commonStats83.getDeleteTime() : null), String.valueOf((commonStats82 = totalStats) != null && (commonStats82 = commonStats82.indexing) != null && (commonStats82 = commonStats82.getTotal()) != null ? Long.valueOf(commonStats82.getDeleteCount()) : null), String.valueOf((commonStats81 = primaryStats) != null && (commonStats81 = commonStats81.indexing) != null && (commonStats81 = commonStats81.getTotal()) != null ? Long.valueOf(commonStats81.getDeleteCount()) : null), String.valueOf((commonStats80 = totalStats) != null && (commonStats80 = commonStats80.indexing) != null && (commonStats80 = commonStats80.getTotal()) != null ? Long.valueOf(commonStats80.getIndexCurrent()) : null), String.valueOf((commonStats79 = primaryStats) != null && (commonStats79 = commonStats79.indexing) != null && (commonStats79 = commonStats79.getTotal()) != null ? Long.valueOf(commonStats79.getIndexCurrent()) : null), String.valueOf((commonStats78 = totalStats) != null && (commonStats78 = commonStats78.indexing) != null && (commonStats78 = commonStats78.getTotal()) != null ? commonStats78.getIndexTime() : null), String.valueOf((commonStats77 = primaryStats) != null && (commonStats77 = commonStats77.indexing) != null && (commonStats77 = commonStats77.getTotal()) != null ? commonStats77.getIndexTime() : null), String.valueOf((commonStats76 = totalStats) != null && (commonStats76 = commonStats76.indexing) != null && (commonStats76 = commonStats76.getTotal()) != null ? Long.valueOf(commonStats76.getIndexCount()) : null), String.valueOf((commonStats75 = primaryStats) != null && (commonStats75 = commonStats75.indexing) != null && (commonStats75 = commonStats75.getTotal()) != null ? Long.valueOf(commonStats75.getIndexCount()) : null), String.valueOf((commonStats74 = totalStats) != null && (commonStats74 = commonStats74.indexing) != null && (commonStats74 = commonStats74.getTotal()) != null ? Long.valueOf(commonStats74.getIndexFailedCount()) : null), String.valueOf((commonStats73 = primaryStats) != null && (commonStats73 = commonStats73.indexing) != null && (commonStats73 = commonStats73.getTotal()) != null ? Long.valueOf(commonStats73.getIndexFailedCount()) : null), String.valueOf((commonStats72 = totalStats) != null && (commonStats72 = commonStats72.merge) != null ? Long.valueOf(commonStats72.getCurrent()) : null), String.valueOf((commonStats71 = primaryStats) != null && (commonStats71 = commonStats71.merge) != null ? Long.valueOf(commonStats71.getCurrent()) : null), String.valueOf((commonStats70 = totalStats) != null && (commonStats70 = commonStats70.merge) != null ? Long.valueOf(commonStats70.getCurrentNumDocs()) : null), String.valueOf((commonStats69 = primaryStats) != null && (commonStats69 = commonStats69.merge) != null ? Long.valueOf(commonStats69.getCurrentNumDocs()) : null), String.valueOf((commonStats68 = totalStats) != null && (commonStats68 = commonStats68.merge) != null ? commonStats68.getCurrentSize() : null), String.valueOf((commonStats67 = primaryStats) != null && (commonStats67 = commonStats67.merge) != null ? commonStats67.getCurrentSize() : null), String.valueOf((commonStats66 = totalStats) != null && (commonStats66 = commonStats66.merge) != null ? Long.valueOf(commonStats66.getTotal()) : null), String.valueOf((commonStats65 = primaryStats) != null && (commonStats65 = commonStats65.merge) != null ? Long.valueOf(commonStats65.getTotal()) : null), String.valueOf((commonStats64 = totalStats) != null && (commonStats64 = commonStats64.merge) != null ? Long.valueOf(commonStats64.getTotalNumDocs()) : null), String.valueOf((commonStats63 = primaryStats) != null && (commonStats63 = commonStats63.merge) != null ? Long.valueOf(commonStats63.getTotalNumDocs()) : null), String.valueOf((commonStats62 = totalStats) != null && (commonStats62 = commonStats62.merge) != null ? commonStats62.getTotalSize() : null), String.valueOf((commonStats61 = primaryStats) != null && (commonStats61 = commonStats61.merge) != null ? commonStats61.getTotalSize() : null), String.valueOf((commonStats60 = totalStats) != null && (commonStats60 = commonStats60.merge) != null ? commonStats60.getTotalTime() : null), String.valueOf((commonStats59 = primaryStats) != null && (commonStats59 = commonStats59.merge) != null ? commonStats59.getTotalTime() : null), String.valueOf((commonStats58 = totalStats) != null && (commonStats58 = commonStats58.refresh) != null ? Long.valueOf(commonStats58.getTotal()) : null), String.valueOf((commonStats57 = primaryStats) != null && (commonStats57 = commonStats57.refresh) != null ? Long.valueOf(commonStats57.getTotal()) : null), String.valueOf((commonStats56 = totalStats) != null && (commonStats56 = commonStats56.refresh) != null ? commonStats56.getTotalTime() : null), String.valueOf((commonStats55 = primaryStats) != null && (commonStats55 = commonStats55.refresh) != null ? commonStats55.getTotalTime() : null), String.valueOf((commonStats54 = totalStats) != null && (commonStats54 = commonStats54.refresh) != null ? Long.valueOf(commonStats54.getExternalTotal()) : null), String.valueOf((commonStats53 = primaryStats) != null && (commonStats53 = commonStats53.refresh) != null ? Long.valueOf(commonStats53.getExternalTotal()) : null), String.valueOf((commonStats52 = totalStats) != null && (commonStats52 = commonStats52.refresh) != null ? commonStats52.getExternalTotalTime() : null), String.valueOf((commonStats51 = primaryStats) != null && (commonStats51 = commonStats51.refresh) != null ? commonStats51.getExternalTotalTime() : null), String.valueOf((commonStats50 = totalStats) != null && (commonStats50 = commonStats50.refresh) != null ? Integer.valueOf(commonStats50.getListeners()) : null), String.valueOf((commonStats49 = primaryStats) != null && (commonStats49 = commonStats49.refresh) != null ? Integer.valueOf(commonStats49.getListeners()) : null), String.valueOf((commonStats48 = totalStats) != null && (commonStats48 = commonStats48.search) != null && (commonStats48 = commonStats48.getTotal()) != null ? Long.valueOf(commonStats48.getFetchCurrent()) : null), String.valueOf((commonStats47 = primaryStats) != null && (commonStats47 = commonStats47.search) != null && (commonStats47 = commonStats47.getTotal()) != null ? Long.valueOf(commonStats47.getFetchCurrent()) : null), String.valueOf((commonStats46 = totalStats) != null && (commonStats46 = commonStats46.search) != null && (commonStats46 = commonStats46.getTotal()) != null ? commonStats46.getFetchTime() : null), String.valueOf((commonStats45 = primaryStats) != null && (commonStats45 = commonStats45.search) != null && (commonStats45 = commonStats45.getTotal()) != null ? commonStats45.getFetchTime() : null), String.valueOf((commonStats44 = totalStats) != null && (commonStats44 = commonStats44.search) != null && (commonStats44 = commonStats44.getTotal()) != null ? Long.valueOf(commonStats44.getFetchCount()) : null), String.valueOf((commonStats43 = primaryStats) != null && (commonStats43 = commonStats43.search) != null && (commonStats43 = commonStats43.getTotal()) != null ? Long.valueOf(commonStats43.getFetchCount()) : null), String.valueOf((commonStats42 = totalStats) != null && (commonStats42 = commonStats42.search) != null ? Long.valueOf(commonStats42.getOpenContexts()) : null), String.valueOf((commonStats41 = primaryStats) != null && (commonStats41 = commonStats41.search) != null ? Long.valueOf(commonStats41.getOpenContexts()) : null), String.valueOf((commonStats40 = totalStats) != null && (commonStats40 = commonStats40.search) != null && (commonStats40 = commonStats40.getTotal()) != null ? Long.valueOf(commonStats40.getQueryCurrent()) : null), String.valueOf((commonStats39 = primaryStats) != null && (commonStats39 = commonStats39.search) != null && (commonStats39 = commonStats39.getTotal()) != null ? Long.valueOf(commonStats39.getQueryCurrent()) : null), String.valueOf((commonStats38 = totalStats) != null && (commonStats38 = commonStats38.search) != null && (commonStats38 = commonStats38.getTotal()) != null ? commonStats38.getQueryTime() : null), String.valueOf((commonStats37 = primaryStats) != null && (commonStats37 = commonStats37.search) != null && (commonStats37 = commonStats37.getTotal()) != null ? commonStats37.getQueryTime() : null), String.valueOf((commonStats36 = totalStats) != null && (commonStats36 = commonStats36.search) != null && (commonStats36 = commonStats36.getTotal()) != null ? Long.valueOf(commonStats36.getQueryCount()) : null), String.valueOf((commonStats35 = primaryStats) != null && (commonStats35 = commonStats35.search) != null && (commonStats35 = commonStats35.getTotal()) != null ? Long.valueOf(commonStats35.getQueryCount()) : null), String.valueOf((commonStats34 = totalStats) != null && (commonStats34 = commonStats34.search) != null && (commonStats34 = commonStats34.getTotal()) != null ? Long.valueOf(commonStats34.getScrollCurrent()) : null), String.valueOf((commonStats33 = primaryStats) != null && (commonStats33 = commonStats33.search) != null && (commonStats33 = commonStats33.getTotal()) != null ? Long.valueOf(commonStats33.getScrollCurrent()) : null), String.valueOf((commonStats32 = totalStats) != null && (commonStats32 = commonStats32.search) != null && (commonStats32 = commonStats32.getTotal()) != null ? commonStats32.getScrollTime() : null), String.valueOf((commonStats31 = primaryStats) != null && (commonStats31 = commonStats31.search) != null && (commonStats31 = commonStats31.getTotal()) != null ? commonStats31.getScrollTime() : null), String.valueOf((commonStats30 = totalStats) != null && (commonStats30 = commonStats30.search) != null && (commonStats30 = commonStats30.getTotal()) != null ? Long.valueOf(commonStats30.getScrollCount()) : null), String.valueOf((commonStats29 = primaryStats) != null && (commonStats29 = commonStats29.search) != null && (commonStats29 = commonStats29.getTotal()) != null ? Long.valueOf(commonStats29.getScrollCount()) : null), String.valueOf((commonStats28 = totalStats) != null && (commonStats28 = commonStats28.search) != null && (commonStats28 = commonStats28.getTotal()) != null ? Long.valueOf(commonStats28.getPitCurrent()) : null), String.valueOf((commonStats27 = primaryStats) != null && (commonStats27 = commonStats27.search) != null && (commonStats27 = commonStats27.getTotal()) != null ? Long.valueOf(commonStats27.getPitCurrent()) : null), String.valueOf((commonStats26 = totalStats) != null && (commonStats26 = commonStats26.search) != null && (commonStats26 = commonStats26.getTotal()) != null ? commonStats26.getPitTime() : null), String.valueOf((commonStats25 = primaryStats) != null && (commonStats25 = commonStats25.search) != null && (commonStats25 = commonStats25.getTotal()) != null ? commonStats25.getPitTime() : null), String.valueOf((commonStats24 = totalStats) != null && (commonStats24 = commonStats24.search) != null && (commonStats24 = commonStats24.getTotal()) != null ? Long.valueOf(commonStats24.getPitCount()) : null), String.valueOf((commonStats23 = primaryStats) != null && (commonStats23 = commonStats23.search) != null && (commonStats23 = commonStats23.getTotal()) != null ? Long.valueOf(commonStats23.getPitCount()) : null), String.valueOf((commonStats22 = totalStats) != null && (commonStats22 = commonStats22.segments) != null ? Long.valueOf(commonStats22.getCount()) : null), String.valueOf((commonStats21 = primaryStats) != null && (commonStats21 = commonStats21.segments) != null ? Long.valueOf(commonStats21.getCount()) : null), String.valueOf((commonStats20 = totalStats) != null && (commonStats20 = commonStats20.segments) != null ? commonStats20.getZeroMemory() : null), String.valueOf((commonStats19 = primaryStats) != null && (commonStats19 = commonStats19.segments) != null ? commonStats19.getZeroMemory() : null), String.valueOf((commonStats18 = totalStats) != null && (commonStats18 = commonStats18.segments) != null ? commonStats18.getIndexWriterMemory() : null), String.valueOf((commonStats17 = primaryStats) != null && (commonStats17 = commonStats17.segments) != null ? commonStats17.getIndexWriterMemory() : null), String.valueOf((commonStats16 = totalStats) != null && (commonStats16 = commonStats16.segments) != null ? commonStats16.getVersionMapMemory() : null), String.valueOf((commonStats15 = primaryStats) != null && (commonStats15 = commonStats15.segments) != null ? commonStats15.getVersionMapMemory() : null), String.valueOf((commonStats14 = totalStats) != null && (commonStats14 = commonStats14.segments) != null ? commonStats14.getBitsetMemory() : null), String.valueOf((commonStats13 = primaryStats) != null && (commonStats13 = commonStats13.segments) != null ? commonStats13.getBitsetMemory() : null), String.valueOf((commonStats12 = totalStats) != null && (commonStats12 = commonStats12.warmer) != null ? Long.valueOf(commonStats12.current()) : null), String.valueOf((commonStats11 = primaryStats) != null && (commonStats11 = commonStats11.warmer) != null ? Long.valueOf(commonStats11.current()) : null), String.valueOf((commonStats10 = totalStats) != null && (commonStats10 = commonStats10.warmer) != null ? Long.valueOf(commonStats10.total()) : null), String.valueOf((commonStats9 = primaryStats) != null && (commonStats9 = commonStats9.warmer) != null ? Long.valueOf(commonStats9.total()) : null), String.valueOf((commonStats8 = totalStats) != null && (commonStats8 = commonStats8.warmer) != null ? commonStats8.totalTime() : null), String.valueOf((commonStats7 = primaryStats) != null && (commonStats7 = commonStats7.warmer) != null ? commonStats7.totalTime() : null), String.valueOf((commonStats6 = totalStats) != null && (commonStats6 = commonStats6.search) != null && (commonStats6 = commonStats6.getTotal()) != null ? Long.valueOf(commonStats6.getSuggestCurrent()) : null), String.valueOf((commonStats5 = primaryStats) != null && (commonStats5 = commonStats5.search) != null && (commonStats5 = commonStats5.getTotal()) != null ? Long.valueOf(commonStats5.getSuggestCurrent()) : null), String.valueOf((commonStats4 = totalStats) != null && (commonStats4 = commonStats4.search) != null && (commonStats4 = commonStats4.getTotal()) != null ? commonStats4.getSuggestTime() : null), String.valueOf((commonStats3 = primaryStats) != null && (commonStats3 = commonStats3.search) != null && (commonStats3 = commonStats3.getTotal()) != null ? commonStats3.getSuggestTime() : null), String.valueOf((commonStats2 = totalStats) != null && (commonStats2 = commonStats2.search) != null && (commonStats2 = commonStats2.getTotal()) != null ? Long.valueOf(commonStats2.getSuggestCount()) : null), String.valueOf((commonStats = primaryStats) != null && (commonStats = commonStats.search) != null && (commonStats = commonStats.getTotal()) != null ? Long.valueOf(commonStats.getSuggestCount()) : null), String.valueOf(commonStats127 != null ? commonStats127.getTotalMemory() : null), String.valueOf(commonStats128 != null ? commonStats128.getTotalMemory() : null), String.valueOf(searchThrottled)));
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper$Companion;", "", "()V", "WRAPPER_FIELD", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0003\b\u009e\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00b2\u00032\u00020\u00012\u00020\u0002:\u0002\u00b2\u0003B\u00ed\n\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010 \u001a\u0004\u0018\u00010\u0004\u0012\b\u0010!\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\"\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010#\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010$\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010%\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010&\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010'\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010(\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010)\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010*\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010+\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010,\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010-\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010.\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010/\u001a\u0004\u0018\u00010\u0004\u0012\b\u00100\u001a\u0004\u0018\u00010\u0004\u0012\b\u00101\u001a\u0004\u0018\u00010\u0004\u0012\b\u00102\u001a\u0004\u0018\u00010\u0004\u0012\b\u00103\u001a\u0004\u0018\u00010\u0004\u0012\b\u00104\u001a\u0004\u0018\u00010\u0004\u0012\b\u00105\u001a\u0004\u0018\u00010\u0004\u0012\b\u00106\u001a\u0004\u0018\u00010\u0004\u0012\b\u00107\u001a\u0004\u0018\u00010\u0004\u0012\b\u00108\u001a\u0004\u0018\u00010\u0004\u0012\b\u00109\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010:\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010;\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010<\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010=\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010>\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010?\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010@\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010A\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010B\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010C\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010D\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010E\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010F\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010G\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010H\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010I\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010J\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010K\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010L\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010M\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010N\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010O\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010P\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010Q\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010R\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010S\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010T\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010U\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010V\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010W\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010X\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010Y\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010Z\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010[\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\\\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010]\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010^\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010_\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010`\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010a\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010c\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010d\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010e\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010g\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010h\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010i\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010j\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010k\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010l\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010m\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010n\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010o\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010p\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010q\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010s\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010u\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010v\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010w\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010x\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010y\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010z\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010{\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010|\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010}\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010~\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u007f\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0004\u0012\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0003\u0010\u008d\u0001J\f\u0010\u0098\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0099\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009a\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009b\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009c\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009d\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009e\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009f\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00aa\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ab\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ac\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ad\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ae\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00af\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ba\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bb\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bc\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bd\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00be\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bf\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00c9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ca\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00cb\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00cc\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00cd\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ce\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00cf\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00d9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00da\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00db\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00dc\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00dd\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00de\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00df\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00e9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ea\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00eb\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ec\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ed\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ee\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ef\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f0\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f1\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f2\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f3\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f4\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f5\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f6\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f7\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f8\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00f9\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00fa\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00fb\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00fc\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00fd\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00fe\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ff\u0002\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0080\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0081\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0082\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0083\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0084\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0085\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0086\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0087\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0088\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0089\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008a\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008b\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008c\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008d\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008e\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008f\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0090\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0091\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0092\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0093\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0094\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0095\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0096\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0097\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0098\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0099\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009a\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009b\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009c\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009d\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009e\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009f\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a0\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0083\r\u0010\u00a1\u0003\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010N\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010O\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010P\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010S\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010T\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010U\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010W\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010]\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010^\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010_\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010d\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010g\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010i\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010j\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010l\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010m\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010o\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010p\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010q\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010s\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010u\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010v\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010w\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010x\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010y\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010z\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010{\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010|\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010}\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010~\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u007f\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00042\u000b\b\u0002\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0017\u0010\u00a2\u0003\u001a\u00030\u00a3\u00032\n\u0010\u00a4\u0003\u001a\u0005\u0018\u00010\u00a5\u0003H\u00d6\u0003J\u000b\u0010\u00a6\u0003\u001a\u00030\u00a7\u0003H\u00d6\u0001J\n\u0010\u00a8\u0003\u001a\u00020\u0004H\u00d6\u0001J\u001e\u0010\u00a9\u0003\u001a\u00030\u00aa\u00032\b\u0010\u00ab\u0003\u001a\u00030\u00aa\u00032\b\u0010\u00ac\u0003\u001a\u00030\u00ad\u0003H\u0016J\u0014\u0010\u00ae\u0003\u001a\u00030\u00af\u00032\b\u0010\u00b0\u0003\u001a\u00030\u00b1\u0003H\u0016R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008e\u0001\u0010\u008f\u0001R\u0015\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0090\u0001\u0010\u008f\u0001R\u0015\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0091\u0001\u0010\u008f\u0001R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0092\u0001\u0010\u008f\u0001R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0093\u0001\u0010\u008f\u0001R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0094\u0001\u0010\u008f\u0001R\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0095\u0001\u0010\u008f\u0001R\u0015\u0010\"\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0096\u0001\u0010\u008f\u0001R\u0015\u0010$\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0097\u0001\u0010\u008f\u0001R\u0015\u0010&\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0098\u0001\u0010\u008f\u0001R\u0015\u0010,\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0099\u0001\u0010\u008f\u0001R\u0015\u0010.\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009a\u0001\u0010\u008f\u0001R\u0015\u00100\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009b\u0001\u0010\u008f\u0001R\u0015\u00102\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009c\u0001\u0010\u008f\u0001R\u0015\u0010(\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009d\u0001\u0010\u008f\u0001R\u0015\u0010*\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009e\u0001\u0010\u008f\u0001R\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u009f\u0001\u0010\u008f\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a0\u0001\u0010\u008f\u0001R\u0015\u00104\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a1\u0001\u0010\u008f\u0001R\u0015\u00106\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a2\u0001\u0010\u008f\u0001R\u0015\u00108\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a3\u0001\u0010\u008f\u0001R\u0015\u0010:\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a4\u0001\u0010\u008f\u0001R\u0015\u0010@\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a5\u0001\u0010\u008f\u0001R\u0015\u0010<\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a6\u0001\u0010\u008f\u0001R\u0015\u0010>\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a7\u0001\u0010\u008f\u0001R\u0016\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a8\u0001\u0010\u008f\u0001R\u0015\u0010B\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00a9\u0001\u0010\u008f\u0001R\u0015\u0010D\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00aa\u0001\u0010\u008f\u0001R\u0015\u0010F\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ab\u0001\u0010\u008f\u0001R\u0015\u0010H\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ac\u0001\u0010\u008f\u0001R\u0015\u0010J\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ad\u0001\u0010\u008f\u0001R\u0015\u0010L\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ae\u0001\u0010\u008f\u0001R\u0015\u0010N\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00af\u0001\u0010\u008f\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b0\u0001\u0010\u008f\u0001R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b1\u0001\u0010\u008f\u0001R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b2\u0001\u0010\u008f\u0001R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b3\u0001\u0010\u008f\u0001R\u0015\u0010#\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b4\u0001\u0010\u008f\u0001R\u0015\u0010%\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b5\u0001\u0010\u008f\u0001R\u0015\u0010'\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b6\u0001\u0010\u008f\u0001R\u0015\u0010-\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b7\u0001\u0010\u008f\u0001R\u0015\u0010/\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b8\u0001\u0010\u008f\u0001R\u0015\u00101\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b9\u0001\u0010\u008f\u0001R\u0015\u00103\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ba\u0001\u0010\u008f\u0001R\u0015\u0010)\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00bb\u0001\u0010\u008f\u0001R\u0015\u0010+\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00bc\u0001\u0010\u008f\u0001R\u0015\u00105\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00bd\u0001\u0010\u008f\u0001R\u0015\u00107\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00be\u0001\u0010\u008f\u0001R\u0015\u00109\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00bf\u0001\u0010\u008f\u0001R\u0015\u0010;\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c0\u0001\u0010\u008f\u0001R\u0015\u0010A\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c1\u0001\u0010\u008f\u0001R\u0015\u0010=\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c2\u0001\u0010\u008f\u0001R\u0015\u0010?\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c3\u0001\u0010\u008f\u0001R\u0016\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c4\u0001\u0010\u008f\u0001R\u0015\u0010C\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c5\u0001\u0010\u008f\u0001R\u0015\u0010E\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c6\u0001\u0010\u008f\u0001R\u0015\u0010G\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c7\u0001\u0010\u008f\u0001R\u0015\u0010I\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c8\u0001\u0010\u008f\u0001R\u0015\u0010K\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00c9\u0001\u0010\u008f\u0001R\u0015\u0010M\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ca\u0001\u0010\u008f\u0001R\u0015\u0010O\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00cb\u0001\u0010\u008f\u0001R\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00cc\u0001\u0010\u008f\u0001R\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00cd\u0001\u0010\u008f\u0001R\u0015\u0010W\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ce\u0001\u0010\u008f\u0001R\u0015\u0010U\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00cf\u0001\u0010\u008f\u0001R\u0015\u0010Y\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d0\u0001\u0010\u008f\u0001R\u0015\u0010S\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d1\u0001\u0010\u008f\u0001R\u0015\u0010Q\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d2\u0001\u0010\u008f\u0001R\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d3\u0001\u0010\u008f\u0001R\u0015\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d4\u0001\u0010\u008f\u0001R\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d5\u0001\u0010\u008f\u0001R\u0015\u0010!\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d6\u0001\u0010\u008f\u0001R\u0015\u0010[\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d7\u0001\u0010\u008f\u0001R\u0015\u0010]\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d8\u0001\u0010\u008f\u0001R\u0015\u0010_\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d9\u0001\u0010\u008f\u0001R\u0015\u0010a\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00da\u0001\u0010\u008f\u0001R\u0015\u0010o\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00db\u0001\u0010\u008f\u0001R\u0015\u0010q\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00dc\u0001\u0010\u008f\u0001R\u0015\u0010s\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00dd\u0001\u0010\u008f\u0001R\u0015\u0010c\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00de\u0001\u0010\u008f\u0001R\u0015\u0010e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00df\u0001\u0010\u008f\u0001R\u0015\u0010g\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e0\u0001\u0010\u008f\u0001R\u0015\u0010i\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e1\u0001\u0010\u008f\u0001R\u0015\u0010k\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e2\u0001\u0010\u008f\u0001R\u0015\u0010m\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e3\u0001\u0010\u008f\u0001R\u0015\u0010u\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e4\u0001\u0010\u008f\u0001R\u0015\u0010}\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e5\u0001\u0010\u008f\u0001R\u0015\u0010y\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e6\u0001\u0010\u008f\u0001R\u0015\u0010w\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e7\u0001\u0010\u008f\u0001R\u0015\u0010{\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e8\u0001\u0010\u008f\u0001R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00e9\u0001\u0010\u008f\u0001R\u0016\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ea\u0001\u0010\u008f\u0001R\u0016\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00eb\u0001\u0010\u008f\u0001R\u0016\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ec\u0001\u0010\u008f\u0001R\u0015\u0010\u007f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ed\u0001\u0010\u008f\u0001R\u0016\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ee\u0001\u0010\u008f\u0001R\u0016\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ef\u0001\u0010\u008f\u0001R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f0\u0001\u0010\u008f\u0001R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f1\u0001\u0010\u008f\u0001R\u0015\u0010V\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f2\u0001\u0010\u008f\u0001R\u0015\u0010T\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f3\u0001\u0010\u008f\u0001R\u0015\u0010X\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f4\u0001\u0010\u008f\u0001R\u0015\u0010R\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f5\u0001\u0010\u008f\u0001R\u0015\u0010P\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f6\u0001\u0010\u008f\u0001R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f7\u0001\u0010\u008f\u0001R\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f8\u0001\u0010\u008f\u0001R\u0015\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00f9\u0001\u0010\u008f\u0001R\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00fa\u0001\u0010\u008f\u0001R\u0015\u0010 \u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00fb\u0001\u0010\u008f\u0001R\u0015\u0010Z\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00fc\u0001\u0010\u008f\u0001R\u0015\u0010\\\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00fd\u0001\u0010\u008f\u0001R\u0015\u0010^\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00fe\u0001\u0010\u008f\u0001R\u0015\u0010`\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00ff\u0001\u0010\u008f\u0001R\u0015\u0010n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0080\u0002\u0010\u008f\u0001R\u0015\u0010p\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0081\u0002\u0010\u008f\u0001R\u0015\u0010r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0082\u0002\u0010\u008f\u0001R\u0015\u0010b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0083\u0002\u0010\u008f\u0001R\u0015\u0010d\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0084\u0002\u0010\u008f\u0001R\u0015\u0010f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0085\u0002\u0010\u008f\u0001R\u0015\u0010h\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0086\u0002\u0010\u008f\u0001R\u0015\u0010j\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0087\u0002\u0010\u008f\u0001R\u0015\u0010l\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0088\u0002\u0010\u008f\u0001R\u0016\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0089\u0002\u0010\u008f\u0001R\u0015\u0010t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008a\u0002\u0010\u008f\u0001R\u0015\u0010|\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008b\u0002\u0010\u008f\u0001R\u0015\u0010x\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008c\u0002\u0010\u008f\u0001R\u0015\u0010v\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008d\u0002\u0010\u008f\u0001R\u0015\u0010z\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008e\u0002\u0010\u008f\u0001R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008f\u0002\u0010\u008f\u0001R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0090\u0002\u0010\u008f\u0001R\u0016\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0091\u0002\u0010\u008f\u0001R\u0016\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0092\u0002\u0010\u008f\u0001R\u0016\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0093\u0002\u0010\u008f\u0001R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0094\u0002\u0010\u008f\u0001R\u0015\u0010~\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0095\u0002\u0010\u008f\u0001R\u0016\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0096\u0002\u0010\u008f\u0001R\u0016\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0097\u0002\u0010\u008f\u0001\u00a8\u0006\u00b3\u0003"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper$IndexInfo;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "health", "", "status", "index", "uuid", "pri", "rep", "docsCount", "docsDeleted", "creationDate", "creationDateString", "storeSize", "priStoreSize", "completionSize", "priCompletionSize", "fieldDataMemorySize", "priFieldDataMemorySize", "fieldDataEvictions", "priFieldDataEvictions", "queryCacheMemorySize", "priQueryCacheMemorySize", "queryCacheEvictions", "priQueryCacheEvictions", "requestCacheMemorySize", "priRequestCacheMemorySize", "requestCacheEvictions", "priRequestCacheEvictions", "requestCacheHitCount", "priRequestCacheHitCount", "requestCacheMissCount", "priRequestCacheMissCount", "flushTotal", "priFlushTotal", "flushTotalTime", "priFlushTotalTime", "getCurrent", "priGetCurrent", "getTime", "priGetTime", "getTotal", "priGetTotal", "getExistsTime", "priGetExistsTime", "getExistsTotal", "priGetExistsTotal", "getMissingTime", "priGetMissingTime", "getMissingTotal", "priGetMissingTotal", "indexingDeleteCurrent", "priIndexingDeleteCurrent", "indexingDeleteTime", "priIndexingDeleteTime", "indexingDeleteTotal", "priIndexingDeleteTotal", "indexingIndexCurrent", "priIndexingIndexCurrent", "indexingIndexTime", "priIndexingIndexTime", "indexingIndexTotal", "priIndexingIndexTotal", "indexingIndexFailed", "priIndexingIndexFailed", "mergesCurrent", "priMergesCurrent", "mergesCurrentDocs", "priMergesCurrentDocs", "mergesCurrentSize", "priMergesCurrentSize", "mergesTotal", "priMergesTotal", "mergesTotalDocs", "priMergesTotalDocs", "mergesTotalSize", "priMergesTotalSize", "mergesTotalTime", "priMergesTotalTime", "refreshTotal", "priRefreshTotal", "refreshTime", "priRefreshTime", "refreshExternalTotal", "priRefreshExternalTotal", "refreshExternalTime", "priRefreshExternalTime", "refreshListeners", "priRefreshListeners", "searchFetchCurrent", "priSearchFetchCurrent", "searchFetchTime", "priSearchFetchTime", "searchFetchTotal", "priSearchFetchTotal", "searchOpenContexts", "priSearchOpenContexts", "searchQueryCurrent", "priSearchQueryCurrent", "searchQueryTime", "priSearchQueryTime", "searchQueryTotal", "priSearchQueryTotal", "searchScrollCurrent", "priSearchScrollCurrent", "searchScrollTime", "priSearchScrollTime", "searchScrollTotal", "priSearchScrollTotal", "searchPointInTimeCurrent", "priSearchPointInTimeCurrent", "searchPointInTimeTime", "priSearchPointInTimeTime", "searchPointInTimeTotal", "priSearchPointInTimeTotal", "segmentsCount", "priSegmentsCount", "segmentsMemory", "priSegmentsMemory", "segmentsIndexWriterMemory", "priSegmentsIndexWriterMemory", "segmentsVersionMapMemory", "priSegmentsVersionMapMemory", "segmentsFixedBitsetMemory", "priSegmentsFixedBitsetMemory", "warmerCurrent", "priWarmerCurrent", "warmerTotal", "priWarmerTotal", "warmerTotalTime", "priWarmerTotalTime", "suggestCurrent", "priSuggestCurrent", "suggestTime", "priSuggestTime", "suggestTotal", "priSuggestTotal", "memoryTotal", "priMemoryTotal", "searchThrottled", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCompletionSize", "()Ljava/lang/String;", "getCreationDate", "getCreationDateString", "getDocsCount", "getDocsDeleted", "getFieldDataEvictions", "getFieldDataMemorySize", "getFlushTotal", "getFlushTotalTime", "getGetCurrent", "getGetExistsTime", "getGetExistsTotal", "getGetMissingTime", "getGetMissingTotal", "getGetTime", "getGetTotal", "getHealth", "getIndex", "getIndexingDeleteCurrent", "getIndexingDeleteTime", "getIndexingDeleteTotal", "getIndexingIndexCurrent", "getIndexingIndexFailed", "getIndexingIndexTime", "getIndexingIndexTotal", "getMemoryTotal", "getMergesCurrent", "getMergesCurrentDocs", "getMergesCurrentSize", "getMergesTotal", "getMergesTotalDocs", "getMergesTotalSize", "getMergesTotalTime", "getPri", "getPriCompletionSize", "getPriFieldDataEvictions", "getPriFieldDataMemorySize", "getPriFlushTotal", "getPriFlushTotalTime", "getPriGetCurrent", "getPriGetExistsTime", "getPriGetExistsTotal", "getPriGetMissingTime", "getPriGetMissingTotal", "getPriGetTime", "getPriGetTotal", "getPriIndexingDeleteCurrent", "getPriIndexingDeleteTime", "getPriIndexingDeleteTotal", "getPriIndexingIndexCurrent", "getPriIndexingIndexFailed", "getPriIndexingIndexTime", "getPriIndexingIndexTotal", "getPriMemoryTotal", "getPriMergesCurrent", "getPriMergesCurrentDocs", "getPriMergesCurrentSize", "getPriMergesTotal", "getPriMergesTotalDocs", "getPriMergesTotalSize", "getPriMergesTotalTime", "getPriQueryCacheEvictions", "getPriQueryCacheMemorySize", "getPriRefreshExternalTime", "getPriRefreshExternalTotal", "getPriRefreshListeners", "getPriRefreshTime", "getPriRefreshTotal", "getPriRequestCacheEvictions", "getPriRequestCacheHitCount", "getPriRequestCacheMemorySize", "getPriRequestCacheMissCount", "getPriSearchFetchCurrent", "getPriSearchFetchTime", "getPriSearchFetchTotal", "getPriSearchOpenContexts", "getPriSearchPointInTimeCurrent", "getPriSearchPointInTimeTime", "getPriSearchPointInTimeTotal", "getPriSearchQueryCurrent", "getPriSearchQueryTime", "getPriSearchQueryTotal", "getPriSearchScrollCurrent", "getPriSearchScrollTime", "getPriSearchScrollTotal", "getPriSegmentsCount", "getPriSegmentsFixedBitsetMemory", "getPriSegmentsIndexWriterMemory", "getPriSegmentsMemory", "getPriSegmentsVersionMapMemory", "getPriStoreSize", "getPriSuggestCurrent", "getPriSuggestTime", "getPriSuggestTotal", "getPriWarmerCurrent", "getPriWarmerTotal", "getPriWarmerTotalTime", "getQueryCacheEvictions", "getQueryCacheMemorySize", "getRefreshExternalTime", "getRefreshExternalTotal", "getRefreshListeners", "getRefreshTime", "getRefreshTotal", "getRep", "getRequestCacheEvictions", "getRequestCacheHitCount", "getRequestCacheMemorySize", "getRequestCacheMissCount", "getSearchFetchCurrent", "getSearchFetchTime", "getSearchFetchTotal", "getSearchOpenContexts", "getSearchPointInTimeCurrent", "getSearchPointInTimeTime", "getSearchPointInTimeTotal", "getSearchQueryCurrent", "getSearchQueryTime", "getSearchQueryTotal", "getSearchScrollCurrent", "getSearchScrollTime", "getSearchScrollTotal", "getSearchThrottled", "getSegmentsCount", "getSegmentsFixedBitsetMemory", "getSegmentsIndexWriterMemory", "getSegmentsMemory", "getSegmentsVersionMapMemory", "getStatus", "getStoreSize", "getSuggestCurrent", "getSuggestTime", "getSuggestTotal", "getUuid", "getWarmerCurrent", "getWarmerTotal", "getWarmerTotalTime", "component1", "component10", "component100", "component101", "component102", "component103", "component104", "component105", "component106", "component107", "component108", "component109", "component11", "component110", "component111", "component112", "component113", "component114", "component115", "component116", "component117", "component118", "component119", "component12", "component120", "component121", "component122", "component123", "component124", "component125", "component126", "component127", "component128", "component129", "component13", "component130", "component131", "component132", "component133", "component134", "component135", "component136", "component137", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component3", "component30", "component31", "component32", "component33", "component34", "component35", "component36", "component37", "component38", "component39", "component4", "component40", "component41", "component42", "component43", "component44", "component45", "component46", "component47", "component48", "component49", "component5", "component50", "component51", "component52", "component53", "component54", "component55", "component56", "component57", "component58", "component59", "component6", "component60", "component61", "component62", "component63", "component64", "component65", "component66", "component67", "component68", "component69", "component7", "component70", "component71", "component72", "component73", "component74", "component75", "component76", "component77", "component78", "component79", "component8", "component80", "component81", "component82", "component83", "component84", "component85", "component86", "component87", "component88", "component89", "component9", "component90", "component91", "component92", "component93", "component94", "component95", "component96", "component97", "component98", "component99", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
    public static final class IndexInfo
    implements ToXContentObject,
    Writeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String health;
        @Nullable
        private final String status;
        @Nullable
        private final String index;
        @Nullable
        private final String uuid;
        @Nullable
        private final String pri;
        @Nullable
        private final String rep;
        @Nullable
        private final String docsCount;
        @Nullable
        private final String docsDeleted;
        @Nullable
        private final String creationDate;
        @Nullable
        private final String creationDateString;
        @Nullable
        private final String storeSize;
        @Nullable
        private final String priStoreSize;
        @Nullable
        private final String completionSize;
        @Nullable
        private final String priCompletionSize;
        @Nullable
        private final String fieldDataMemorySize;
        @Nullable
        private final String priFieldDataMemorySize;
        @Nullable
        private final String fieldDataEvictions;
        @Nullable
        private final String priFieldDataEvictions;
        @Nullable
        private final String queryCacheMemorySize;
        @Nullable
        private final String priQueryCacheMemorySize;
        @Nullable
        private final String queryCacheEvictions;
        @Nullable
        private final String priQueryCacheEvictions;
        @Nullable
        private final String requestCacheMemorySize;
        @Nullable
        private final String priRequestCacheMemorySize;
        @Nullable
        private final String requestCacheEvictions;
        @Nullable
        private final String priRequestCacheEvictions;
        @Nullable
        private final String requestCacheHitCount;
        @Nullable
        private final String priRequestCacheHitCount;
        @Nullable
        private final String requestCacheMissCount;
        @Nullable
        private final String priRequestCacheMissCount;
        @Nullable
        private final String flushTotal;
        @Nullable
        private final String priFlushTotal;
        @Nullable
        private final String flushTotalTime;
        @Nullable
        private final String priFlushTotalTime;
        @Nullable
        private final String getCurrent;
        @Nullable
        private final String priGetCurrent;
        @Nullable
        private final String getTime;
        @Nullable
        private final String priGetTime;
        @Nullable
        private final String getTotal;
        @Nullable
        private final String priGetTotal;
        @Nullable
        private final String getExistsTime;
        @Nullable
        private final String priGetExistsTime;
        @Nullable
        private final String getExistsTotal;
        @Nullable
        private final String priGetExistsTotal;
        @Nullable
        private final String getMissingTime;
        @Nullable
        private final String priGetMissingTime;
        @Nullable
        private final String getMissingTotal;
        @Nullable
        private final String priGetMissingTotal;
        @Nullable
        private final String indexingDeleteCurrent;
        @Nullable
        private final String priIndexingDeleteCurrent;
        @Nullable
        private final String indexingDeleteTime;
        @Nullable
        private final String priIndexingDeleteTime;
        @Nullable
        private final String indexingDeleteTotal;
        @Nullable
        private final String priIndexingDeleteTotal;
        @Nullable
        private final String indexingIndexCurrent;
        @Nullable
        private final String priIndexingIndexCurrent;
        @Nullable
        private final String indexingIndexTime;
        @Nullable
        private final String priIndexingIndexTime;
        @Nullable
        private final String indexingIndexTotal;
        @Nullable
        private final String priIndexingIndexTotal;
        @Nullable
        private final String indexingIndexFailed;
        @Nullable
        private final String priIndexingIndexFailed;
        @Nullable
        private final String mergesCurrent;
        @Nullable
        private final String priMergesCurrent;
        @Nullable
        private final String mergesCurrentDocs;
        @Nullable
        private final String priMergesCurrentDocs;
        @Nullable
        private final String mergesCurrentSize;
        @Nullable
        private final String priMergesCurrentSize;
        @Nullable
        private final String mergesTotal;
        @Nullable
        private final String priMergesTotal;
        @Nullable
        private final String mergesTotalDocs;
        @Nullable
        private final String priMergesTotalDocs;
        @Nullable
        private final String mergesTotalSize;
        @Nullable
        private final String priMergesTotalSize;
        @Nullable
        private final String mergesTotalTime;
        @Nullable
        private final String priMergesTotalTime;
        @Nullable
        private final String refreshTotal;
        @Nullable
        private final String priRefreshTotal;
        @Nullable
        private final String refreshTime;
        @Nullable
        private final String priRefreshTime;
        @Nullable
        private final String refreshExternalTotal;
        @Nullable
        private final String priRefreshExternalTotal;
        @Nullable
        private final String refreshExternalTime;
        @Nullable
        private final String priRefreshExternalTime;
        @Nullable
        private final String refreshListeners;
        @Nullable
        private final String priRefreshListeners;
        @Nullable
        private final String searchFetchCurrent;
        @Nullable
        private final String priSearchFetchCurrent;
        @Nullable
        private final String searchFetchTime;
        @Nullable
        private final String priSearchFetchTime;
        @Nullable
        private final String searchFetchTotal;
        @Nullable
        private final String priSearchFetchTotal;
        @Nullable
        private final String searchOpenContexts;
        @Nullable
        private final String priSearchOpenContexts;
        @Nullable
        private final String searchQueryCurrent;
        @Nullable
        private final String priSearchQueryCurrent;
        @Nullable
        private final String searchQueryTime;
        @Nullable
        private final String priSearchQueryTime;
        @Nullable
        private final String searchQueryTotal;
        @Nullable
        private final String priSearchQueryTotal;
        @Nullable
        private final String searchScrollCurrent;
        @Nullable
        private final String priSearchScrollCurrent;
        @Nullable
        private final String searchScrollTime;
        @Nullable
        private final String priSearchScrollTime;
        @Nullable
        private final String searchScrollTotal;
        @Nullable
        private final String priSearchScrollTotal;
        @Nullable
        private final String searchPointInTimeCurrent;
        @Nullable
        private final String priSearchPointInTimeCurrent;
        @Nullable
        private final String searchPointInTimeTime;
        @Nullable
        private final String priSearchPointInTimeTime;
        @Nullable
        private final String searchPointInTimeTotal;
        @Nullable
        private final String priSearchPointInTimeTotal;
        @Nullable
        private final String segmentsCount;
        @Nullable
        private final String priSegmentsCount;
        @Nullable
        private final String segmentsMemory;
        @Nullable
        private final String priSegmentsMemory;
        @Nullable
        private final String segmentsIndexWriterMemory;
        @Nullable
        private final String priSegmentsIndexWriterMemory;
        @Nullable
        private final String segmentsVersionMapMemory;
        @Nullable
        private final String priSegmentsVersionMapMemory;
        @Nullable
        private final String segmentsFixedBitsetMemory;
        @Nullable
        private final String priSegmentsFixedBitsetMemory;
        @Nullable
        private final String warmerCurrent;
        @Nullable
        private final String priWarmerCurrent;
        @Nullable
        private final String warmerTotal;
        @Nullable
        private final String priWarmerTotal;
        @Nullable
        private final String warmerTotalTime;
        @Nullable
        private final String priWarmerTotalTime;
        @Nullable
        private final String suggestCurrent;
        @Nullable
        private final String priSuggestCurrent;
        @Nullable
        private final String suggestTime;
        @Nullable
        private final String priSuggestTime;
        @Nullable
        private final String suggestTotal;
        @Nullable
        private final String priSuggestTotal;
        @Nullable
        private final String memoryTotal;
        @Nullable
        private final String priMemoryTotal;
        @Nullable
        private final String searchThrottled;
        @NotNull
        public static final String HEALTH_FIELD = "health";
        @NotNull
        public static final String STATUS_FIELD = "status";
        @NotNull
        public static final String INDEX_FIELD = "index";
        @NotNull
        public static final String UUID_FIELD = "uuid";
        @NotNull
        public static final String PRI_FIELD = "pri";
        @NotNull
        public static final String REP_FIELD = "rep";
        @NotNull
        public static final String DOCS_COUNT_FIELD = "docs.count";
        @NotNull
        public static final String DOCS_DELETED_FIELD = "docs.deleted";
        @NotNull
        public static final String CREATION_DATE_FIELD = "creation.date";
        @NotNull
        public static final String CREATION_DATE_STRING_FIELD = "creation.date.string";
        @NotNull
        public static final String STORE_SIZE_FIELD = "store.size";
        @NotNull
        public static final String PRI_STORE_SIZE_FIELD = "pri.store.size";
        @NotNull
        public static final String COMPLETION_SIZE_FIELD = "completion.size";
        @NotNull
        public static final String PRI_COMPLETION_SIZE_FIELD = "pri.completion.size";
        @NotNull
        public static final String FIELD_DATA_MEMORY_SIZE_FIELD = "fielddata.memory_size";
        @NotNull
        public static final String PRI_FIELD_DATA_MEMORY_SIZE_FIELD = "pri.fielddata.memory_size";
        @NotNull
        public static final String FIELD_DATA_EVICTIONS_FIELD = "fielddata.evictions";
        @NotNull
        public static final String PRI_FIELD_DATA_EVICTIONS_FIELD = "pri.fielddata.evictions";
        @NotNull
        public static final String QUERY_CACHE_MEMORY_SIZE_FIELD = "query_cache.memory_size";
        @NotNull
        public static final String PRI_QUERY_CACHE_MEMORY_SIZE_FIELD = "pri.query_cache.memory_size";
        @NotNull
        public static final String QUERY_CACHE_EVICTIONS_FIELD = "query_cache.evictions";
        @NotNull
        public static final String PRI_QUERY_CACHE_EVICTIONS_FIELD = "pri.query_cache.evictions";
        @NotNull
        public static final String REQUEST_CACHE_MEMORY_SIZE_FIELD = "request_cache.memory_size";
        @NotNull
        public static final String PRI_REQUEST_CACHE_MEMORY_SIZE_FIELD = "pri.request_cache.memory_size";
        @NotNull
        public static final String REQUEST_CACHE_EVICTIONS_FIELD = "request_cache.evictions";
        @NotNull
        public static final String PRI_REQUEST_CACHE_EVICTIONS_FIELD = "pri.request_cache.evictions";
        @NotNull
        public static final String REQUEST_CACHE_HIT_COUNT_FIELD = "request_cache.hit_count";
        @NotNull
        public static final String PRI_REQUEST_CACHE_HIT_COUNT_FIELD = "pri.request_cache.hit_count";
        @NotNull
        public static final String REQUEST_CACHE_MISS_COUNT_FIELD = "request_cache.miss_count";
        @NotNull
        public static final String PRI_REQUEST_CACHE_MISS_COUNT_FIELD = "pri.request_cache.miss_count";
        @NotNull
        public static final String FLUSH_TOTAL_FIELD = "flush.total";
        @NotNull
        public static final String PRI_FLUSH_TOTAL_FIELD = "pri.flush.total";
        @NotNull
        public static final String FLUSH_TOTAL_TIME_FIELD = "flush.total_time";
        @NotNull
        public static final String PRI_FLUSH_TOTAL_TIME_FIELD = "pri.flush.total_time";
        @NotNull
        public static final String GET_CURRENT_FIELD = "get.current";
        @NotNull
        public static final String PRI_GET_CURRENT_FIELD = "pri.get.current";
        @NotNull
        public static final String GET_TIME_FIELD = "get.time";
        @NotNull
        public static final String PRI_GET_TIME_FIELD = "pri.get.time";
        @NotNull
        public static final String GET_TOTAL_FIELD = "get.total";
        @NotNull
        public static final String PRI_GET_TOTAL_FIELD = "pri.get.total";
        @NotNull
        public static final String GET_EXISTS_TIME_FIELD = "get.exists_time";
        @NotNull
        public static final String PRI_GET_EXISTS_TIME_FIELD = "pri.get.exists_time";
        @NotNull
        public static final String GET_EXISTS_TOTAL_FIELD = "get.exists_total";
        @NotNull
        public static final String PRI_GET_EXISTS_TOTAL_FIELD = "pri.get.exists_total";
        @NotNull
        public static final String GET_MISSING_TIME_FIELD = "get.missing_time";
        @NotNull
        public static final String PRI_GET_MISSING_TIME_FIELD = "pri.get.missing_time";
        @NotNull
        public static final String GET_MISSING_TOTAL_FIELD = "get.missing_total";
        @NotNull
        public static final String PRI_GET_MISSING_TOTAL_FIELD = "pri.get.missing_total";
        @NotNull
        public static final String INDEXING_DELETE_CURRENT_FIELD = "indexing.delete_current";
        @NotNull
        public static final String PRI_INDEXING_DELETE_CURRENT_FIELD = "pri.indexing.delete_current";
        @NotNull
        public static final String INDEXING_DELETE_TIME_FIELD = "indexing.delete_time";
        @NotNull
        public static final String PRI_INDEXING_DELETE_TIME_FIELD = "pri.indexing.delete_time";
        @NotNull
        public static final String INDEXING_DELETE_TOTAL_FIELD = "indexing.delete_total";
        @NotNull
        public static final String PRI_INDEXING_DELETE_TOTAL_FIELD = "pri.indexing.delete_total";
        @NotNull
        public static final String INDEXING_INDEX_CURRENT_FIELD = "indexing.index_current";
        @NotNull
        public static final String PRI_INDEXING_INDEX_CURRENT_FIELD = "pri.indexing.index_current";
        @NotNull
        public static final String INDEXING_INDEX_TIME_FIELD = "indexing.index_time";
        @NotNull
        public static final String PRI_INDEXING_INDEX_TIME_FIELD = "pri.indexing.index_time";
        @NotNull
        public static final String INDEXING_INDEX_TOTAL_FIELD = "indexing.index_total";
        @NotNull
        public static final String PRI_INDEXING_INDEX_TOTAL_FIELD = "pri.indexing.index_total";
        @NotNull
        public static final String INDEXING_INDEX_FAILED_FIELD = "indexing.index_failed";
        @NotNull
        public static final String PRI_INDEXING_INDEX_FAILED_FIELD = "pri.indexing.index_failed";
        @NotNull
        public static final String MERGES_CURRENT_FIELD = "merges.current";
        @NotNull
        public static final String PRI_MERGES_CURRENT_FIELD = "pri.merges.current";
        @NotNull
        public static final String MERGES_CURRENT_DOCS_FIELD = "merges.current_docs";
        @NotNull
        public static final String PRI_MERGES_CURRENT_DOCS_FIELD = "pri.merges.current_docs";
        @NotNull
        public static final String MERGES_CURRENT_SIZE_FIELD = "merges.current_size";
        @NotNull
        public static final String PRI_MERGES_CURRENT_SIZE_FIELD = "pri.merges.current_size";
        @NotNull
        public static final String MERGES_TOTAL_FIELD = "merges.total";
        @NotNull
        public static final String PRI_MERGES_TOTAL_FIELD = "pri.merges.total";
        @NotNull
        public static final String MERGES_TOTAL_DOCS_FIELD = "merges.total_docs";
        @NotNull
        public static final String PRI_MERGES_TOTAL_DOCS_FIELD = "pri.merges.total_docs";
        @NotNull
        public static final String MERGES_TOTAL_SIZE_FIELD = "merges.total_size";
        @NotNull
        public static final String PRI_MERGES_TOTAL_SIZE_FIELD = "pri.merges.total_size";
        @NotNull
        public static final String MERGES_TOTAL_TIME_FIELD = "merges.total_time";
        @NotNull
        public static final String PRI_MERGES_TOTAL_TIME_FIELD = "pri.merges.total_time";
        @NotNull
        public static final String REFRESH_TOTAL_FIELD = "refresh.total";
        @NotNull
        public static final String PRI_REFRESH_TOTAL_FIELD = "pri.refresh.total";
        @NotNull
        public static final String REFRESH_TIME_FIELD = "refresh.time";
        @NotNull
        public static final String PRI_REFRESH_TIME_FIELD = "pri.refresh.time";
        @NotNull
        public static final String REFRESH_EXTERNAL_TOTAL_FIELD = "refresh.external_total";
        @NotNull
        public static final String PRI_REFRESH_EXTERNAL_TOTAL_FIELD = "pri.refresh.external_total";
        @NotNull
        public static final String REFRESH_EXTERNAL_TIME_FIELD = "refresh.external_time";
        @NotNull
        public static final String PRI_REFRESH_EXTERNAL_TIME_FIELD = "pri.refresh.external_time";
        @NotNull
        public static final String REFRESH_LISTENERS_FIELD = "refresh.listeners";
        @NotNull
        public static final String PRI_REFRESH_LISTENERS_FIELD = "pri.refresh.listeners";
        @NotNull
        public static final String SEARCH_FETCH_CURRENT_FIELD = "search.fetch_current";
        @NotNull
        public static final String PRI_SEARCH_FETCH_CURRENT_FIELD = "pri.search.fetch_current";
        @NotNull
        public static final String SEARCH_FETCH_TIME_FIELD = "search.fetch_time";
        @NotNull
        public static final String PRI_SEARCH_FETCH_TIME_FIELD = "pri.search.fetch_time";
        @NotNull
        public static final String SEARCH_FETCH_TOTAL_FIELD = "search.fetch_total";
        @NotNull
        public static final String PRI_SEARCH_FETCH_TOTAL_FIELD = "pri.search.fetch_total";
        @NotNull
        public static final String SEARCH_OPEN_CONTEXTS_FIELD = "search.open_contexts";
        @NotNull
        public static final String PRI_SEARCH_OPEN_CONTEXTS_FIELD = "pri.search.open_contexts";
        @NotNull
        public static final String SEARCH_QUERY_CURRENT_FIELD = "search.query_current";
        @NotNull
        public static final String PRI_SEARCH_QUERY_CURRENT_FIELD = "pri.search.query_current";
        @NotNull
        public static final String SEARCH_QUERY_TIME_FIELD = "search.query_time";
        @NotNull
        public static final String PRI_SEARCH_QUERY_TIME_FIELD = "pri.search.query_time";
        @NotNull
        public static final String SEARCH_QUERY_TOTAL_FIELD = "search.query_total";
        @NotNull
        public static final String PRI_SEARCH_QUERY_TOTAL_FIELD = "pri.search.query_total";
        @NotNull
        public static final String SEARCH_SCROLL_CURRENT_FIELD = "search.scroll_current";
        @NotNull
        public static final String PRI_SEARCH_SCROLL_CURRENT_FIELD = "pri.search.scroll_current";
        @NotNull
        public static final String SEARCH_SCROLL_TIME_FIELD = "search.scroll_time";
        @NotNull
        public static final String PRI_SEARCH_SCROLL_TIME_FIELD = "pri.search.scroll_time";
        @NotNull
        public static final String SEARCH_SCROLL_TOTAL_FIELD = "search.scroll_total";
        @NotNull
        public static final String PRI_SEARCH_SCROLL_TOTAL_FIELD = "pri.search.scroll_total";
        @NotNull
        public static final String SEARCH_POINT_IN_TIME_CURRENT_FIELD = "search.point_in_time_current";
        @NotNull
        public static final String PRI_SEARCH_POINT_IN_TIME_CURRENT_FIELD = "pri.search.point_in_time_current";
        @NotNull
        public static final String SEARCH_POINT_IN_TIME_TIME_FIELD = "search.point_in_time_time";
        @NotNull
        public static final String PRI_SEARCH_POINT_IN_TIME_TIME_FIELD = "pri.search.point_in_time_time";
        @NotNull
        public static final String SEARCH_POINT_IN_TIME_TOTAL_FIELD = "search.point_in_time_total";
        @NotNull
        public static final String PRI_SEARCH_POINT_IN_TIME_TOTAL_FIELD = "pri.search.point_in_time_total";
        @NotNull
        public static final String SEGMENTS_COUNT_FIELD = "segments.count";
        @NotNull
        public static final String PRI_SEGMENTS_COUNT_FIELD = "pri.segments.count";
        @NotNull
        public static final String SEGMENTS_MEMORY_FIELD = "segments.memory";
        @NotNull
        public static final String PRI_SEGMENTS_MEMORY_FIELD = "pri.segments.memory";
        @NotNull
        public static final String SEGMENTS_INDEX_WRITER_MEMORY_FIELD = "segments.index_writer_memory";
        @NotNull
        public static final String PRI_SEGMENTS_INDEX_WRITER_MEMORY_FIELD = "pri.segments.index_writer_memory";
        @NotNull
        public static final String SEGMENTS_VERSION_MAP_MEMORY_FIELD = "segments.version_map_memory";
        @NotNull
        public static final String PRI_SEGMENTS_VERSION_MAP_MEMORY_FIELD = "pri.segments.version_map_memory";
        @NotNull
        public static final String SEGMENTS_FIXED_BITSET_MEMORY_FIELD = "segments.fixed_bitset_memory";
        @NotNull
        public static final String PRI_SEGMENTS_FIXED_BITSET_MEMORY_FIELD = "pri.segments.fixed_bitset_memory";
        @NotNull
        public static final String WARMER_CURRENT_FIELD = "warmer.current";
        @NotNull
        public static final String PRI_WARMER_CURRENT_FIELD = "pri.warmer.current";
        @NotNull
        public static final String WARMER_TOTAL_FIELD = "warmer.total";
        @NotNull
        public static final String PRI_WARMER_TOTAL_FIELD = "pri.warmer.total";
        @NotNull
        public static final String WARMER_TOTAL_TIME_FIELD = "warmer.total_time";
        @NotNull
        public static final String PRI_WARMER_TOTAL_TIME_FIELD = "pri.warmer.total_time";
        @NotNull
        public static final String SUGGEST_CURRENT_FIELD = "suggest.current";
        @NotNull
        public static final String PRI_SUGGEST_CURRENT_FIELD = "pri.suggest.current";
        @NotNull
        public static final String SUGGEST_TIME_FIELD = "suggest.time";
        @NotNull
        public static final String PRI_SUGGEST_TIME_FIELD = "pri.suggest.time";
        @NotNull
        public static final String SUGGEST_TOTAL_FIELD = "suggest.total";
        @NotNull
        public static final String PRI_SUGGEST_TOTAL_FIELD = "pri.suggest.total";
        @NotNull
        public static final String MEMORY_TOTAL_FIELD = "memory.total";
        @NotNull
        public static final String PRI_MEMORY_TOTAL_FIELD = "pri.memory.total";
        @NotNull
        public static final String SEARCH_THROTTLED_FIELD = "search.throttled";

        public IndexInfo(String health, String status, String index, String uuid, String pri, String rep, String docsCount, String docsDeleted, String creationDate, String creationDateString, String storeSize, String priStoreSize, String completionSize, String priCompletionSize, String fieldDataMemorySize, String priFieldDataMemorySize, String fieldDataEvictions, String priFieldDataEvictions, String queryCacheMemorySize, String priQueryCacheMemorySize, String queryCacheEvictions, String priQueryCacheEvictions, String requestCacheMemorySize, String priRequestCacheMemorySize, String requestCacheEvictions, String priRequestCacheEvictions, String requestCacheHitCount, String priRequestCacheHitCount, String requestCacheMissCount, String priRequestCacheMissCount, String flushTotal, String priFlushTotal, String flushTotalTime, String priFlushTotalTime, String getCurrent, String priGetCurrent, String getTime, String priGetTime, String getTotal, String priGetTotal, String getExistsTime, String priGetExistsTime, String getExistsTotal, String priGetExistsTotal, String getMissingTime, String priGetMissingTime, String getMissingTotal, String priGetMissingTotal, String indexingDeleteCurrent, String priIndexingDeleteCurrent, String indexingDeleteTime, String priIndexingDeleteTime, String indexingDeleteTotal, String priIndexingDeleteTotal, String indexingIndexCurrent, String priIndexingIndexCurrent, String indexingIndexTime, String priIndexingIndexTime, String indexingIndexTotal, String priIndexingIndexTotal, String indexingIndexFailed, String priIndexingIndexFailed, String mergesCurrent, String priMergesCurrent, String mergesCurrentDocs, String priMergesCurrentDocs, String mergesCurrentSize, String priMergesCurrentSize, String mergesTotal, String priMergesTotal, String mergesTotalDocs, String priMergesTotalDocs, String mergesTotalSize, String priMergesTotalSize, String mergesTotalTime, String priMergesTotalTime, String refreshTotal, String priRefreshTotal, String refreshTime, String priRefreshTime, String refreshExternalTotal, String priRefreshExternalTotal, String refreshExternalTime, String priRefreshExternalTime, String refreshListeners, String priRefreshListeners, String searchFetchCurrent, String priSearchFetchCurrent, String searchFetchTime, String priSearchFetchTime, String searchFetchTotal, String priSearchFetchTotal, String searchOpenContexts, String priSearchOpenContexts, String searchQueryCurrent, String priSearchQueryCurrent, String searchQueryTime, String priSearchQueryTime, String searchQueryTotal, String priSearchQueryTotal, String searchScrollCurrent, String priSearchScrollCurrent, String searchScrollTime, String priSearchScrollTime, String searchScrollTotal, String priSearchScrollTotal, String searchPointInTimeCurrent, String priSearchPointInTimeCurrent, String searchPointInTimeTime, String priSearchPointInTimeTime, String searchPointInTimeTotal, String priSearchPointInTimeTotal, String segmentsCount, String priSegmentsCount, String segmentsMemory, String priSegmentsMemory, String segmentsIndexWriterMemory, String priSegmentsIndexWriterMemory, String segmentsVersionMapMemory, String priSegmentsVersionMapMemory, String segmentsFixedBitsetMemory, String priSegmentsFixedBitsetMemory, String warmerCurrent, String priWarmerCurrent, String warmerTotal, String priWarmerTotal, String warmerTotalTime, String priWarmerTotalTime, String suggestCurrent, String priSuggestCurrent, String suggestTime, String priSuggestTime, String suggestTotal, String priSuggestTotal, String memoryTotal, String priMemoryTotal, String searchThrottled) {
            this.health = health;
            this.status = status;
            this.index = index;
            this.uuid = uuid;
            this.pri = pri;
            this.rep = rep;
            this.docsCount = docsCount;
            this.docsDeleted = docsDeleted;
            this.creationDate = creationDate;
            this.creationDateString = creationDateString;
            this.storeSize = storeSize;
            this.priStoreSize = priStoreSize;
            this.completionSize = completionSize;
            this.priCompletionSize = priCompletionSize;
            this.fieldDataMemorySize = fieldDataMemorySize;
            this.priFieldDataMemorySize = priFieldDataMemorySize;
            this.fieldDataEvictions = fieldDataEvictions;
            this.priFieldDataEvictions = priFieldDataEvictions;
            this.queryCacheMemorySize = queryCacheMemorySize;
            this.priQueryCacheMemorySize = priQueryCacheMemorySize;
            this.queryCacheEvictions = queryCacheEvictions;
            this.priQueryCacheEvictions = priQueryCacheEvictions;
            this.requestCacheMemorySize = requestCacheMemorySize;
            this.priRequestCacheMemorySize = priRequestCacheMemorySize;
            this.requestCacheEvictions = requestCacheEvictions;
            this.priRequestCacheEvictions = priRequestCacheEvictions;
            this.requestCacheHitCount = requestCacheHitCount;
            this.priRequestCacheHitCount = priRequestCacheHitCount;
            this.requestCacheMissCount = requestCacheMissCount;
            this.priRequestCacheMissCount = priRequestCacheMissCount;
            this.flushTotal = flushTotal;
            this.priFlushTotal = priFlushTotal;
            this.flushTotalTime = flushTotalTime;
            this.priFlushTotalTime = priFlushTotalTime;
            this.getCurrent = getCurrent;
            this.priGetCurrent = priGetCurrent;
            this.getTime = getTime;
            this.priGetTime = priGetTime;
            this.getTotal = getTotal;
            this.priGetTotal = priGetTotal;
            this.getExistsTime = getExistsTime;
            this.priGetExistsTime = priGetExistsTime;
            this.getExistsTotal = getExistsTotal;
            this.priGetExistsTotal = priGetExistsTotal;
            this.getMissingTime = getMissingTime;
            this.priGetMissingTime = priGetMissingTime;
            this.getMissingTotal = getMissingTotal;
            this.priGetMissingTotal = priGetMissingTotal;
            this.indexingDeleteCurrent = indexingDeleteCurrent;
            this.priIndexingDeleteCurrent = priIndexingDeleteCurrent;
            this.indexingDeleteTime = indexingDeleteTime;
            this.priIndexingDeleteTime = priIndexingDeleteTime;
            this.indexingDeleteTotal = indexingDeleteTotal;
            this.priIndexingDeleteTotal = priIndexingDeleteTotal;
            this.indexingIndexCurrent = indexingIndexCurrent;
            this.priIndexingIndexCurrent = priIndexingIndexCurrent;
            this.indexingIndexTime = indexingIndexTime;
            this.priIndexingIndexTime = priIndexingIndexTime;
            this.indexingIndexTotal = indexingIndexTotal;
            this.priIndexingIndexTotal = priIndexingIndexTotal;
            this.indexingIndexFailed = indexingIndexFailed;
            this.priIndexingIndexFailed = priIndexingIndexFailed;
            this.mergesCurrent = mergesCurrent;
            this.priMergesCurrent = priMergesCurrent;
            this.mergesCurrentDocs = mergesCurrentDocs;
            this.priMergesCurrentDocs = priMergesCurrentDocs;
            this.mergesCurrentSize = mergesCurrentSize;
            this.priMergesCurrentSize = priMergesCurrentSize;
            this.mergesTotal = mergesTotal;
            this.priMergesTotal = priMergesTotal;
            this.mergesTotalDocs = mergesTotalDocs;
            this.priMergesTotalDocs = priMergesTotalDocs;
            this.mergesTotalSize = mergesTotalSize;
            this.priMergesTotalSize = priMergesTotalSize;
            this.mergesTotalTime = mergesTotalTime;
            this.priMergesTotalTime = priMergesTotalTime;
            this.refreshTotal = refreshTotal;
            this.priRefreshTotal = priRefreshTotal;
            this.refreshTime = refreshTime;
            this.priRefreshTime = priRefreshTime;
            this.refreshExternalTotal = refreshExternalTotal;
            this.priRefreshExternalTotal = priRefreshExternalTotal;
            this.refreshExternalTime = refreshExternalTime;
            this.priRefreshExternalTime = priRefreshExternalTime;
            this.refreshListeners = refreshListeners;
            this.priRefreshListeners = priRefreshListeners;
            this.searchFetchCurrent = searchFetchCurrent;
            this.priSearchFetchCurrent = priSearchFetchCurrent;
            this.searchFetchTime = searchFetchTime;
            this.priSearchFetchTime = priSearchFetchTime;
            this.searchFetchTotal = searchFetchTotal;
            this.priSearchFetchTotal = priSearchFetchTotal;
            this.searchOpenContexts = searchOpenContexts;
            this.priSearchOpenContexts = priSearchOpenContexts;
            this.searchQueryCurrent = searchQueryCurrent;
            this.priSearchQueryCurrent = priSearchQueryCurrent;
            this.searchQueryTime = searchQueryTime;
            this.priSearchQueryTime = priSearchQueryTime;
            this.searchQueryTotal = searchQueryTotal;
            this.priSearchQueryTotal = priSearchQueryTotal;
            this.searchScrollCurrent = searchScrollCurrent;
            this.priSearchScrollCurrent = priSearchScrollCurrent;
            this.searchScrollTime = searchScrollTime;
            this.priSearchScrollTime = priSearchScrollTime;
            this.searchScrollTotal = searchScrollTotal;
            this.priSearchScrollTotal = priSearchScrollTotal;
            this.searchPointInTimeCurrent = searchPointInTimeCurrent;
            this.priSearchPointInTimeCurrent = priSearchPointInTimeCurrent;
            this.searchPointInTimeTime = searchPointInTimeTime;
            this.priSearchPointInTimeTime = priSearchPointInTimeTime;
            this.searchPointInTimeTotal = searchPointInTimeTotal;
            this.priSearchPointInTimeTotal = priSearchPointInTimeTotal;
            this.segmentsCount = segmentsCount;
            this.priSegmentsCount = priSegmentsCount;
            this.segmentsMemory = segmentsMemory;
            this.priSegmentsMemory = priSegmentsMemory;
            this.segmentsIndexWriterMemory = segmentsIndexWriterMemory;
            this.priSegmentsIndexWriterMemory = priSegmentsIndexWriterMemory;
            this.segmentsVersionMapMemory = segmentsVersionMapMemory;
            this.priSegmentsVersionMapMemory = priSegmentsVersionMapMemory;
            this.segmentsFixedBitsetMemory = segmentsFixedBitsetMemory;
            this.priSegmentsFixedBitsetMemory = priSegmentsFixedBitsetMemory;
            this.warmerCurrent = warmerCurrent;
            this.priWarmerCurrent = priWarmerCurrent;
            this.warmerTotal = warmerTotal;
            this.priWarmerTotal = priWarmerTotal;
            this.warmerTotalTime = warmerTotalTime;
            this.priWarmerTotalTime = priWarmerTotalTime;
            this.suggestCurrent = suggestCurrent;
            this.priSuggestCurrent = priSuggestCurrent;
            this.suggestTime = suggestTime;
            this.priSuggestTime = priSuggestTime;
            this.suggestTotal = suggestTotal;
            this.priSuggestTotal = priSuggestTotal;
            this.memoryTotal = memoryTotal;
            this.priMemoryTotal = priMemoryTotal;
            this.searchThrottled = searchThrottled;
        }

        @Nullable
        public final String getHealth() {
            return this.health;
        }

        @Nullable
        public final String getStatus() {
            return this.status;
        }

        @Nullable
        public final String getIndex() {
            return this.index;
        }

        @Nullable
        public final String getUuid() {
            return this.uuid;
        }

        @Nullable
        public final String getPri() {
            return this.pri;
        }

        @Nullable
        public final String getRep() {
            return this.rep;
        }

        @Nullable
        public final String getDocsCount() {
            return this.docsCount;
        }

        @Nullable
        public final String getDocsDeleted() {
            return this.docsDeleted;
        }

        @Nullable
        public final String getCreationDate() {
            return this.creationDate;
        }

        @Nullable
        public final String getCreationDateString() {
            return this.creationDateString;
        }

        @Nullable
        public final String getStoreSize() {
            return this.storeSize;
        }

        @Nullable
        public final String getPriStoreSize() {
            return this.priStoreSize;
        }

        @Nullable
        public final String getCompletionSize() {
            return this.completionSize;
        }

        @Nullable
        public final String getPriCompletionSize() {
            return this.priCompletionSize;
        }

        @Nullable
        public final String getFieldDataMemorySize() {
            return this.fieldDataMemorySize;
        }

        @Nullable
        public final String getPriFieldDataMemorySize() {
            return this.priFieldDataMemorySize;
        }

        @Nullable
        public final String getFieldDataEvictions() {
            return this.fieldDataEvictions;
        }

        @Nullable
        public final String getPriFieldDataEvictions() {
            return this.priFieldDataEvictions;
        }

        @Nullable
        public final String getQueryCacheMemorySize() {
            return this.queryCacheMemorySize;
        }

        @Nullable
        public final String getPriQueryCacheMemorySize() {
            return this.priQueryCacheMemorySize;
        }

        @Nullable
        public final String getQueryCacheEvictions() {
            return this.queryCacheEvictions;
        }

        @Nullable
        public final String getPriQueryCacheEvictions() {
            return this.priQueryCacheEvictions;
        }

        @Nullable
        public final String getRequestCacheMemorySize() {
            return this.requestCacheMemorySize;
        }

        @Nullable
        public final String getPriRequestCacheMemorySize() {
            return this.priRequestCacheMemorySize;
        }

        @Nullable
        public final String getRequestCacheEvictions() {
            return this.requestCacheEvictions;
        }

        @Nullable
        public final String getPriRequestCacheEvictions() {
            return this.priRequestCacheEvictions;
        }

        @Nullable
        public final String getRequestCacheHitCount() {
            return this.requestCacheHitCount;
        }

        @Nullable
        public final String getPriRequestCacheHitCount() {
            return this.priRequestCacheHitCount;
        }

        @Nullable
        public final String getRequestCacheMissCount() {
            return this.requestCacheMissCount;
        }

        @Nullable
        public final String getPriRequestCacheMissCount() {
            return this.priRequestCacheMissCount;
        }

        @Nullable
        public final String getFlushTotal() {
            return this.flushTotal;
        }

        @Nullable
        public final String getPriFlushTotal() {
            return this.priFlushTotal;
        }

        @Nullable
        public final String getFlushTotalTime() {
            return this.flushTotalTime;
        }

        @Nullable
        public final String getPriFlushTotalTime() {
            return this.priFlushTotalTime;
        }

        @Nullable
        public final String getGetCurrent() {
            return this.getCurrent;
        }

        @Nullable
        public final String getPriGetCurrent() {
            return this.priGetCurrent;
        }

        @Nullable
        public final String getGetTime() {
            return this.getTime;
        }

        @Nullable
        public final String getPriGetTime() {
            return this.priGetTime;
        }

        @Nullable
        public final String getGetTotal() {
            return this.getTotal;
        }

        @Nullable
        public final String getPriGetTotal() {
            return this.priGetTotal;
        }

        @Nullable
        public final String getGetExistsTime() {
            return this.getExistsTime;
        }

        @Nullable
        public final String getPriGetExistsTime() {
            return this.priGetExistsTime;
        }

        @Nullable
        public final String getGetExistsTotal() {
            return this.getExistsTotal;
        }

        @Nullable
        public final String getPriGetExistsTotal() {
            return this.priGetExistsTotal;
        }

        @Nullable
        public final String getGetMissingTime() {
            return this.getMissingTime;
        }

        @Nullable
        public final String getPriGetMissingTime() {
            return this.priGetMissingTime;
        }

        @Nullable
        public final String getGetMissingTotal() {
            return this.getMissingTotal;
        }

        @Nullable
        public final String getPriGetMissingTotal() {
            return this.priGetMissingTotal;
        }

        @Nullable
        public final String getIndexingDeleteCurrent() {
            return this.indexingDeleteCurrent;
        }

        @Nullable
        public final String getPriIndexingDeleteCurrent() {
            return this.priIndexingDeleteCurrent;
        }

        @Nullable
        public final String getIndexingDeleteTime() {
            return this.indexingDeleteTime;
        }

        @Nullable
        public final String getPriIndexingDeleteTime() {
            return this.priIndexingDeleteTime;
        }

        @Nullable
        public final String getIndexingDeleteTotal() {
            return this.indexingDeleteTotal;
        }

        @Nullable
        public final String getPriIndexingDeleteTotal() {
            return this.priIndexingDeleteTotal;
        }

        @Nullable
        public final String getIndexingIndexCurrent() {
            return this.indexingIndexCurrent;
        }

        @Nullable
        public final String getPriIndexingIndexCurrent() {
            return this.priIndexingIndexCurrent;
        }

        @Nullable
        public final String getIndexingIndexTime() {
            return this.indexingIndexTime;
        }

        @Nullable
        public final String getPriIndexingIndexTime() {
            return this.priIndexingIndexTime;
        }

        @Nullable
        public final String getIndexingIndexTotal() {
            return this.indexingIndexTotal;
        }

        @Nullable
        public final String getPriIndexingIndexTotal() {
            return this.priIndexingIndexTotal;
        }

        @Nullable
        public final String getIndexingIndexFailed() {
            return this.indexingIndexFailed;
        }

        @Nullable
        public final String getPriIndexingIndexFailed() {
            return this.priIndexingIndexFailed;
        }

        @Nullable
        public final String getMergesCurrent() {
            return this.mergesCurrent;
        }

        @Nullable
        public final String getPriMergesCurrent() {
            return this.priMergesCurrent;
        }

        @Nullable
        public final String getMergesCurrentDocs() {
            return this.mergesCurrentDocs;
        }

        @Nullable
        public final String getPriMergesCurrentDocs() {
            return this.priMergesCurrentDocs;
        }

        @Nullable
        public final String getMergesCurrentSize() {
            return this.mergesCurrentSize;
        }

        @Nullable
        public final String getPriMergesCurrentSize() {
            return this.priMergesCurrentSize;
        }

        @Nullable
        public final String getMergesTotal() {
            return this.mergesTotal;
        }

        @Nullable
        public final String getPriMergesTotal() {
            return this.priMergesTotal;
        }

        @Nullable
        public final String getMergesTotalDocs() {
            return this.mergesTotalDocs;
        }

        @Nullable
        public final String getPriMergesTotalDocs() {
            return this.priMergesTotalDocs;
        }

        @Nullable
        public final String getMergesTotalSize() {
            return this.mergesTotalSize;
        }

        @Nullable
        public final String getPriMergesTotalSize() {
            return this.priMergesTotalSize;
        }

        @Nullable
        public final String getMergesTotalTime() {
            return this.mergesTotalTime;
        }

        @Nullable
        public final String getPriMergesTotalTime() {
            return this.priMergesTotalTime;
        }

        @Nullable
        public final String getRefreshTotal() {
            return this.refreshTotal;
        }

        @Nullable
        public final String getPriRefreshTotal() {
            return this.priRefreshTotal;
        }

        @Nullable
        public final String getRefreshTime() {
            return this.refreshTime;
        }

        @Nullable
        public final String getPriRefreshTime() {
            return this.priRefreshTime;
        }

        @Nullable
        public final String getRefreshExternalTotal() {
            return this.refreshExternalTotal;
        }

        @Nullable
        public final String getPriRefreshExternalTotal() {
            return this.priRefreshExternalTotal;
        }

        @Nullable
        public final String getRefreshExternalTime() {
            return this.refreshExternalTime;
        }

        @Nullable
        public final String getPriRefreshExternalTime() {
            return this.priRefreshExternalTime;
        }

        @Nullable
        public final String getRefreshListeners() {
            return this.refreshListeners;
        }

        @Nullable
        public final String getPriRefreshListeners() {
            return this.priRefreshListeners;
        }

        @Nullable
        public final String getSearchFetchCurrent() {
            return this.searchFetchCurrent;
        }

        @Nullable
        public final String getPriSearchFetchCurrent() {
            return this.priSearchFetchCurrent;
        }

        @Nullable
        public final String getSearchFetchTime() {
            return this.searchFetchTime;
        }

        @Nullable
        public final String getPriSearchFetchTime() {
            return this.priSearchFetchTime;
        }

        @Nullable
        public final String getSearchFetchTotal() {
            return this.searchFetchTotal;
        }

        @Nullable
        public final String getPriSearchFetchTotal() {
            return this.priSearchFetchTotal;
        }

        @Nullable
        public final String getSearchOpenContexts() {
            return this.searchOpenContexts;
        }

        @Nullable
        public final String getPriSearchOpenContexts() {
            return this.priSearchOpenContexts;
        }

        @Nullable
        public final String getSearchQueryCurrent() {
            return this.searchQueryCurrent;
        }

        @Nullable
        public final String getPriSearchQueryCurrent() {
            return this.priSearchQueryCurrent;
        }

        @Nullable
        public final String getSearchQueryTime() {
            return this.searchQueryTime;
        }

        @Nullable
        public final String getPriSearchQueryTime() {
            return this.priSearchQueryTime;
        }

        @Nullable
        public final String getSearchQueryTotal() {
            return this.searchQueryTotal;
        }

        @Nullable
        public final String getPriSearchQueryTotal() {
            return this.priSearchQueryTotal;
        }

        @Nullable
        public final String getSearchScrollCurrent() {
            return this.searchScrollCurrent;
        }

        @Nullable
        public final String getPriSearchScrollCurrent() {
            return this.priSearchScrollCurrent;
        }

        @Nullable
        public final String getSearchScrollTime() {
            return this.searchScrollTime;
        }

        @Nullable
        public final String getPriSearchScrollTime() {
            return this.priSearchScrollTime;
        }

        @Nullable
        public final String getSearchScrollTotal() {
            return this.searchScrollTotal;
        }

        @Nullable
        public final String getPriSearchScrollTotal() {
            return this.priSearchScrollTotal;
        }

        @Nullable
        public final String getSearchPointInTimeCurrent() {
            return this.searchPointInTimeCurrent;
        }

        @Nullable
        public final String getPriSearchPointInTimeCurrent() {
            return this.priSearchPointInTimeCurrent;
        }

        @Nullable
        public final String getSearchPointInTimeTime() {
            return this.searchPointInTimeTime;
        }

        @Nullable
        public final String getPriSearchPointInTimeTime() {
            return this.priSearchPointInTimeTime;
        }

        @Nullable
        public final String getSearchPointInTimeTotal() {
            return this.searchPointInTimeTotal;
        }

        @Nullable
        public final String getPriSearchPointInTimeTotal() {
            return this.priSearchPointInTimeTotal;
        }

        @Nullable
        public final String getSegmentsCount() {
            return this.segmentsCount;
        }

        @Nullable
        public final String getPriSegmentsCount() {
            return this.priSegmentsCount;
        }

        @Nullable
        public final String getSegmentsMemory() {
            return this.segmentsMemory;
        }

        @Nullable
        public final String getPriSegmentsMemory() {
            return this.priSegmentsMemory;
        }

        @Nullable
        public final String getSegmentsIndexWriterMemory() {
            return this.segmentsIndexWriterMemory;
        }

        @Nullable
        public final String getPriSegmentsIndexWriterMemory() {
            return this.priSegmentsIndexWriterMemory;
        }

        @Nullable
        public final String getSegmentsVersionMapMemory() {
            return this.segmentsVersionMapMemory;
        }

        @Nullable
        public final String getPriSegmentsVersionMapMemory() {
            return this.priSegmentsVersionMapMemory;
        }

        @Nullable
        public final String getSegmentsFixedBitsetMemory() {
            return this.segmentsFixedBitsetMemory;
        }

        @Nullable
        public final String getPriSegmentsFixedBitsetMemory() {
            return this.priSegmentsFixedBitsetMemory;
        }

        @Nullable
        public final String getWarmerCurrent() {
            return this.warmerCurrent;
        }

        @Nullable
        public final String getPriWarmerCurrent() {
            return this.priWarmerCurrent;
        }

        @Nullable
        public final String getWarmerTotal() {
            return this.warmerTotal;
        }

        @Nullable
        public final String getPriWarmerTotal() {
            return this.priWarmerTotal;
        }

        @Nullable
        public final String getWarmerTotalTime() {
            return this.warmerTotalTime;
        }

        @Nullable
        public final String getPriWarmerTotalTime() {
            return this.priWarmerTotalTime;
        }

        @Nullable
        public final String getSuggestCurrent() {
            return this.suggestCurrent;
        }

        @Nullable
        public final String getPriSuggestCurrent() {
            return this.priSuggestCurrent;
        }

        @Nullable
        public final String getSuggestTime() {
            return this.suggestTime;
        }

        @Nullable
        public final String getPriSuggestTime() {
            return this.priSuggestTime;
        }

        @Nullable
        public final String getSuggestTotal() {
            return this.suggestTotal;
        }

        @Nullable
        public final String getPriSuggestTotal() {
            return this.priSuggestTotal;
        }

        @Nullable
        public final String getMemoryTotal() {
            return this.memoryTotal;
        }

        @Nullable
        public final String getPriMemoryTotal() {
            return this.priMemoryTotal;
        }

        @Nullable
        public final String getSearchThrottled() {
            return this.searchThrottled;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            builder.startObject().field(HEALTH_FIELD, this.health).field(STATUS_FIELD, this.status).field(INDEX_FIELD, this.index).field(UUID_FIELD, this.uuid).field(PRI_FIELD, this.pri).field(REP_FIELD, this.rep).field(DOCS_COUNT_FIELD, this.docsCount).field(DOCS_DELETED_FIELD, this.docsDeleted).field(CREATION_DATE_FIELD, this.creationDate).field(CREATION_DATE_STRING_FIELD, this.creationDateString).field(STORE_SIZE_FIELD, this.storeSize).field(PRI_STORE_SIZE_FIELD, this.priStoreSize).field(COMPLETION_SIZE_FIELD, this.completionSize).field(PRI_COMPLETION_SIZE_FIELD, this.priCompletionSize).field(FIELD_DATA_MEMORY_SIZE_FIELD, this.fieldDataMemorySize).field(PRI_FIELD_DATA_MEMORY_SIZE_FIELD, this.priFieldDataMemorySize).field(FIELD_DATA_EVICTIONS_FIELD, this.fieldDataEvictions).field(PRI_FIELD_DATA_EVICTIONS_FIELD, this.priFieldDataEvictions).field(QUERY_CACHE_MEMORY_SIZE_FIELD, this.queryCacheMemorySize).field(PRI_QUERY_CACHE_MEMORY_SIZE_FIELD, this.priQueryCacheMemorySize).field(QUERY_CACHE_EVICTIONS_FIELD, this.queryCacheEvictions).field(PRI_QUERY_CACHE_EVICTIONS_FIELD, this.priQueryCacheEvictions).field(REQUEST_CACHE_MEMORY_SIZE_FIELD, this.requestCacheMemorySize).field(PRI_REQUEST_CACHE_MEMORY_SIZE_FIELD, this.priRequestCacheMemorySize).field(REQUEST_CACHE_EVICTIONS_FIELD, this.requestCacheEvictions).field(PRI_REQUEST_CACHE_EVICTIONS_FIELD, this.priRequestCacheEvictions).field(REQUEST_CACHE_HIT_COUNT_FIELD, this.requestCacheHitCount).field(PRI_REQUEST_CACHE_HIT_COUNT_FIELD, this.priRequestCacheHitCount).field(REQUEST_CACHE_MISS_COUNT_FIELD, this.requestCacheMissCount).field(PRI_REQUEST_CACHE_MISS_COUNT_FIELD, this.priRequestCacheMissCount).field(FLUSH_TOTAL_FIELD, this.flushTotal).field(PRI_FLUSH_TOTAL_FIELD, this.priFlushTotal).field(FLUSH_TOTAL_TIME_FIELD, this.flushTotalTime).field(PRI_FLUSH_TOTAL_TIME_FIELD, this.priFlushTotalTime).field(GET_CURRENT_FIELD, this.getCurrent).field(PRI_GET_CURRENT_FIELD, this.priGetCurrent).field(GET_TIME_FIELD, this.getTime).field(PRI_GET_TIME_FIELD, this.priGetTime).field(GET_TOTAL_FIELD, this.getTotal).field(PRI_GET_TOTAL_FIELD, this.priGetTotal).field(GET_EXISTS_TIME_FIELD, this.getExistsTime).field(PRI_GET_EXISTS_TIME_FIELD, this.priGetExistsTime).field(GET_EXISTS_TOTAL_FIELD, this.getExistsTotal).field(PRI_GET_EXISTS_TOTAL_FIELD, this.priGetExistsTotal).field(GET_MISSING_TIME_FIELD, this.getMissingTime).field(PRI_GET_MISSING_TIME_FIELD, this.priGetMissingTime).field(GET_MISSING_TOTAL_FIELD, this.getMissingTotal).field(PRI_GET_MISSING_TOTAL_FIELD, this.priGetMissingTotal).field(INDEXING_DELETE_CURRENT_FIELD, this.indexingDeleteCurrent).field(PRI_INDEXING_DELETE_CURRENT_FIELD, this.priIndexingDeleteCurrent).field(INDEXING_DELETE_TIME_FIELD, this.indexingDeleteTime).field(PRI_INDEXING_DELETE_TIME_FIELD, this.priIndexingDeleteTime).field(INDEXING_DELETE_TOTAL_FIELD, this.indexingDeleteTotal).field(PRI_INDEXING_DELETE_TOTAL_FIELD, this.priIndexingDeleteTotal).field(INDEXING_INDEX_CURRENT_FIELD, this.indexingIndexCurrent).field(PRI_INDEXING_INDEX_CURRENT_FIELD, this.priIndexingIndexCurrent).field(INDEXING_INDEX_TIME_FIELD, this.indexingIndexTime).field(PRI_INDEXING_INDEX_TIME_FIELD, this.priIndexingIndexTime).field(INDEXING_INDEX_TOTAL_FIELD, this.indexingIndexTotal).field(PRI_INDEXING_INDEX_TOTAL_FIELD, this.priIndexingIndexTotal).field(INDEXING_INDEX_FAILED_FIELD, this.indexingIndexFailed).field(PRI_INDEXING_INDEX_FAILED_FIELD, this.priIndexingIndexFailed).field(MERGES_CURRENT_FIELD, this.mergesCurrent).field(PRI_MERGES_CURRENT_FIELD, this.priMergesCurrent).field(MERGES_CURRENT_DOCS_FIELD, this.mergesCurrentDocs).field(PRI_MERGES_CURRENT_DOCS_FIELD, this.priMergesCurrentDocs).field(MERGES_CURRENT_SIZE_FIELD, this.mergesCurrentSize).field(PRI_MERGES_CURRENT_SIZE_FIELD, this.priMergesCurrentSize).field(MERGES_TOTAL_FIELD, this.mergesTotal).field(PRI_MERGES_TOTAL_FIELD, this.priMergesTotal).field(MERGES_TOTAL_DOCS_FIELD, this.mergesTotalDocs).field(PRI_MERGES_TOTAL_DOCS_FIELD, this.priMergesTotalDocs).field(MERGES_TOTAL_SIZE_FIELD, this.mergesTotalSize).field(PRI_MERGES_TOTAL_SIZE_FIELD, this.priMergesTotalSize).field(MERGES_TOTAL_TIME_FIELD, this.mergesTotalTime).field(PRI_MERGES_TOTAL_TIME_FIELD, this.priMergesTotalTime).field(REFRESH_TOTAL_FIELD, this.refreshTotal).field(PRI_REFRESH_TOTAL_FIELD, this.priRefreshTotal).field(REFRESH_TIME_FIELD, this.refreshTime).field(PRI_REFRESH_TIME_FIELD, this.priRefreshTime).field(REFRESH_EXTERNAL_TOTAL_FIELD, this.refreshExternalTotal).field(PRI_REFRESH_EXTERNAL_TOTAL_FIELD, this.priRefreshExternalTotal).field(REFRESH_EXTERNAL_TIME_FIELD, this.refreshExternalTime).field(PRI_REFRESH_EXTERNAL_TIME_FIELD, this.priRefreshExternalTime).field(REFRESH_LISTENERS_FIELD, this.refreshListeners).field(PRI_REFRESH_LISTENERS_FIELD, this.priRefreshListeners).field(SEARCH_FETCH_CURRENT_FIELD, this.searchFetchCurrent).field(PRI_SEARCH_FETCH_CURRENT_FIELD, this.priSearchFetchCurrent).field(SEARCH_FETCH_TIME_FIELD, this.searchFetchTime).field(PRI_SEARCH_FETCH_TIME_FIELD, this.priSearchFetchTime).field(SEARCH_FETCH_TOTAL_FIELD, this.searchFetchTotal).field(PRI_SEARCH_FETCH_TOTAL_FIELD, this.priSearchFetchTotal).field(SEARCH_OPEN_CONTEXTS_FIELD, this.searchOpenContexts).field(PRI_SEARCH_OPEN_CONTEXTS_FIELD, this.priSearchOpenContexts).field(SEARCH_QUERY_CURRENT_FIELD, this.searchQueryCurrent).field(PRI_SEARCH_QUERY_CURRENT_FIELD, this.priSearchQueryCurrent).field(SEARCH_QUERY_TIME_FIELD, this.searchQueryTime).field(PRI_SEARCH_QUERY_TIME_FIELD, this.priSearchQueryTime).field(SEARCH_QUERY_TOTAL_FIELD, this.searchQueryTotal).field(PRI_SEARCH_QUERY_TOTAL_FIELD, this.priSearchQueryTotal).field(SEARCH_SCROLL_CURRENT_FIELD, this.searchScrollCurrent).field(PRI_SEARCH_SCROLL_CURRENT_FIELD, this.priSearchScrollCurrent).field(SEARCH_SCROLL_TIME_FIELD, this.searchScrollTime).field(PRI_SEARCH_SCROLL_TIME_FIELD, this.priSearchScrollTime).field(SEARCH_SCROLL_TOTAL_FIELD, this.searchScrollTotal).field(PRI_SEARCH_SCROLL_TOTAL_FIELD, this.priSearchScrollTotal).field(SEARCH_POINT_IN_TIME_CURRENT_FIELD, this.searchPointInTimeCurrent).field(PRI_SEARCH_POINT_IN_TIME_CURRENT_FIELD, this.priSearchPointInTimeCurrent).field(SEARCH_POINT_IN_TIME_TIME_FIELD, this.searchPointInTimeTime).field(PRI_SEARCH_POINT_IN_TIME_TIME_FIELD, this.priSearchPointInTimeTime).field(SEARCH_POINT_IN_TIME_TOTAL_FIELD, this.searchPointInTimeTotal).field(PRI_SEARCH_POINT_IN_TIME_TOTAL_FIELD, this.priSearchPointInTimeTotal).field(SEGMENTS_COUNT_FIELD, this.segmentsCount).field(PRI_SEGMENTS_COUNT_FIELD, this.priSegmentsCount).field(SEGMENTS_MEMORY_FIELD, this.segmentsMemory).field(PRI_SEGMENTS_MEMORY_FIELD, this.priSegmentsMemory).field(SEGMENTS_INDEX_WRITER_MEMORY_FIELD, this.segmentsIndexWriterMemory).field(PRI_SEGMENTS_INDEX_WRITER_MEMORY_FIELD, this.priSegmentsIndexWriterMemory).field(SEGMENTS_VERSION_MAP_MEMORY_FIELD, this.segmentsVersionMapMemory).field(PRI_SEGMENTS_VERSION_MAP_MEMORY_FIELD, this.priSegmentsVersionMapMemory).field(SEGMENTS_FIXED_BITSET_MEMORY_FIELD, this.segmentsFixedBitsetMemory).field(PRI_SEGMENTS_FIXED_BITSET_MEMORY_FIELD, this.priSegmentsFixedBitsetMemory).field(WARMER_CURRENT_FIELD, this.warmerCurrent).field(PRI_WARMER_CURRENT_FIELD, this.priWarmerCurrent).field(WARMER_TOTAL_FIELD, this.warmerTotal).field(PRI_WARMER_TOTAL_FIELD, this.priWarmerTotal).field(WARMER_TOTAL_TIME_FIELD, this.warmerTotalTime).field(PRI_WARMER_TOTAL_TIME_FIELD, this.priWarmerTotalTime).field(SUGGEST_CURRENT_FIELD, this.suggestCurrent).field(PRI_SUGGEST_CURRENT_FIELD, this.priSuggestCurrent).field(SUGGEST_TIME_FIELD, this.suggestTime).field(PRI_SUGGEST_TIME_FIELD, this.priSuggestTime).field(SUGGEST_TOTAL_FIELD, this.suggestTotal).field(PRI_SUGGEST_TOTAL_FIELD, this.priSuggestTotal).field(MEMORY_TOTAL_FIELD, this.memoryTotal).field(PRI_MEMORY_TOTAL_FIELD, this.priMemoryTotal).field(SEARCH_THROTTLED_FIELD, this.searchThrottled);
            XContentBuilder xContentBuilder = builder.endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
            return xContentBuilder;
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.health);
            out.writeString(this.status);
            out.writeString(this.index);
            out.writeString(this.uuid);
            out.writeString(this.pri);
            out.writeString(this.rep);
            out.writeString(this.docsCount);
            out.writeString(this.docsDeleted);
            out.writeString(this.creationDate);
            out.writeString(this.creationDateString);
            out.writeString(this.storeSize);
            out.writeString(this.priStoreSize);
            out.writeString(this.completionSize);
            out.writeString(this.priCompletionSize);
            out.writeString(this.fieldDataMemorySize);
            out.writeString(this.priFieldDataMemorySize);
            out.writeString(this.fieldDataEvictions);
            out.writeString(this.priFieldDataEvictions);
            out.writeString(this.queryCacheMemorySize);
            out.writeString(this.priQueryCacheMemorySize);
            out.writeString(this.queryCacheEvictions);
            out.writeString(this.priQueryCacheEvictions);
            out.writeString(this.requestCacheMemorySize);
            out.writeString(this.priRequestCacheMemorySize);
            out.writeString(this.requestCacheEvictions);
            out.writeString(this.priRequestCacheEvictions);
            out.writeString(this.requestCacheHitCount);
            out.writeString(this.priRequestCacheHitCount);
            out.writeString(this.requestCacheMissCount);
            out.writeString(this.priRequestCacheMissCount);
            out.writeString(this.flushTotal);
            out.writeString(this.priFlushTotal);
            out.writeString(this.flushTotalTime);
            out.writeString(this.priFlushTotalTime);
            out.writeString(this.getCurrent);
            out.writeString(this.priGetCurrent);
            out.writeString(this.getTime);
            out.writeString(this.priGetTime);
            out.writeString(this.getTotal);
            out.writeString(this.priGetTotal);
            out.writeString(this.getExistsTime);
            out.writeString(this.priGetExistsTime);
            out.writeString(this.getExistsTotal);
            out.writeString(this.priGetExistsTotal);
            out.writeString(this.getMissingTime);
            out.writeString(this.priGetMissingTime);
            out.writeString(this.getMissingTotal);
            out.writeString(this.priGetMissingTotal);
            out.writeString(this.indexingDeleteCurrent);
            out.writeString(this.priIndexingDeleteCurrent);
            out.writeString(this.indexingDeleteTime);
            out.writeString(this.priIndexingDeleteTime);
            out.writeString(this.indexingDeleteTotal);
            out.writeString(this.priIndexingDeleteTotal);
            out.writeString(this.indexingIndexCurrent);
            out.writeString(this.priIndexingIndexCurrent);
            out.writeString(this.indexingIndexTime);
            out.writeString(this.priIndexingIndexTime);
            out.writeString(this.indexingIndexTotal);
            out.writeString(this.priIndexingIndexTotal);
            out.writeString(this.indexingIndexFailed);
            out.writeString(this.priIndexingIndexFailed);
            out.writeString(this.mergesCurrent);
            out.writeString(this.priMergesCurrent);
            out.writeString(this.mergesCurrentDocs);
            out.writeString(this.priMergesCurrentDocs);
            out.writeString(this.mergesCurrentSize);
            out.writeString(this.priMergesCurrentSize);
            out.writeString(this.mergesTotal);
            out.writeString(this.priMergesTotal);
            out.writeString(this.mergesTotalDocs);
            out.writeString(this.priMergesTotalDocs);
            out.writeString(this.mergesTotalSize);
            out.writeString(this.priMergesTotalSize);
            out.writeString(this.mergesTotalTime);
            out.writeString(this.priMergesTotalTime);
            out.writeString(this.refreshTotal);
            out.writeString(this.priRefreshTotal);
            out.writeString(this.refreshTime);
            out.writeString(this.priRefreshTime);
            out.writeString(this.refreshExternalTotal);
            out.writeString(this.priRefreshExternalTotal);
            out.writeString(this.refreshExternalTime);
            out.writeString(this.priRefreshExternalTime);
            out.writeString(this.refreshListeners);
            out.writeString(this.priRefreshListeners);
            out.writeString(this.searchFetchCurrent);
            out.writeString(this.priSearchFetchCurrent);
            out.writeString(this.searchFetchTime);
            out.writeString(this.priSearchFetchTime);
            out.writeString(this.searchFetchTotal);
            out.writeString(this.priSearchFetchTotal);
            out.writeString(this.searchOpenContexts);
            out.writeString(this.priSearchOpenContexts);
            out.writeString(this.searchQueryCurrent);
            out.writeString(this.priSearchQueryCurrent);
            out.writeString(this.searchQueryTime);
            out.writeString(this.priSearchQueryTime);
            out.writeString(this.searchQueryTotal);
            out.writeString(this.priSearchQueryTotal);
            out.writeString(this.searchScrollCurrent);
            out.writeString(this.priSearchScrollCurrent);
            out.writeString(this.searchScrollTime);
            out.writeString(this.priSearchScrollTime);
            out.writeString(this.searchScrollTotal);
            out.writeString(this.priSearchScrollTotal);
            out.writeString(this.searchPointInTimeCurrent);
            out.writeString(this.priSearchPointInTimeCurrent);
            out.writeString(this.searchPointInTimeTime);
            out.writeString(this.priSearchPointInTimeTime);
            out.writeString(this.searchPointInTimeTotal);
            out.writeString(this.priSearchPointInTimeTotal);
            out.writeString(this.segmentsCount);
            out.writeString(this.priSegmentsCount);
            out.writeString(this.segmentsMemory);
            out.writeString(this.priSegmentsMemory);
            out.writeString(this.segmentsIndexWriterMemory);
            out.writeString(this.priSegmentsIndexWriterMemory);
            out.writeString(this.segmentsVersionMapMemory);
            out.writeString(this.priSegmentsVersionMapMemory);
            out.writeString(this.segmentsFixedBitsetMemory);
            out.writeString(this.priSegmentsFixedBitsetMemory);
            out.writeString(this.warmerCurrent);
            out.writeString(this.priWarmerCurrent);
            out.writeString(this.warmerTotal);
            out.writeString(this.priWarmerTotal);
            out.writeString(this.warmerTotalTime);
            out.writeString(this.priWarmerTotalTime);
            out.writeString(this.suggestCurrent);
            out.writeString(this.priSuggestCurrent);
            out.writeString(this.suggestTime);
            out.writeString(this.priSuggestTime);
            out.writeString(this.suggestTotal);
            out.writeString(this.priSuggestTotal);
            out.writeString(this.memoryTotal);
            out.writeString(this.priMemoryTotal);
            out.writeString(this.searchThrottled);
        }

        @Nullable
        public final String component1() {
            return this.health;
        }

        @Nullable
        public final String component2() {
            return this.status;
        }

        @Nullable
        public final String component3() {
            return this.index;
        }

        @Nullable
        public final String component4() {
            return this.uuid;
        }

        @Nullable
        public final String component5() {
            return this.pri;
        }

        @Nullable
        public final String component6() {
            return this.rep;
        }

        @Nullable
        public final String component7() {
            return this.docsCount;
        }

        @Nullable
        public final String component8() {
            return this.docsDeleted;
        }

        @Nullable
        public final String component9() {
            return this.creationDate;
        }

        @Nullable
        public final String component10() {
            return this.creationDateString;
        }

        @Nullable
        public final String component11() {
            return this.storeSize;
        }

        @Nullable
        public final String component12() {
            return this.priStoreSize;
        }

        @Nullable
        public final String component13() {
            return this.completionSize;
        }

        @Nullable
        public final String component14() {
            return this.priCompletionSize;
        }

        @Nullable
        public final String component15() {
            return this.fieldDataMemorySize;
        }

        @Nullable
        public final String component16() {
            return this.priFieldDataMemorySize;
        }

        @Nullable
        public final String component17() {
            return this.fieldDataEvictions;
        }

        @Nullable
        public final String component18() {
            return this.priFieldDataEvictions;
        }

        @Nullable
        public final String component19() {
            return this.queryCacheMemorySize;
        }

        @Nullable
        public final String component20() {
            return this.priQueryCacheMemorySize;
        }

        @Nullable
        public final String component21() {
            return this.queryCacheEvictions;
        }

        @Nullable
        public final String component22() {
            return this.priQueryCacheEvictions;
        }

        @Nullable
        public final String component23() {
            return this.requestCacheMemorySize;
        }

        @Nullable
        public final String component24() {
            return this.priRequestCacheMemorySize;
        }

        @Nullable
        public final String component25() {
            return this.requestCacheEvictions;
        }

        @Nullable
        public final String component26() {
            return this.priRequestCacheEvictions;
        }

        @Nullable
        public final String component27() {
            return this.requestCacheHitCount;
        }

        @Nullable
        public final String component28() {
            return this.priRequestCacheHitCount;
        }

        @Nullable
        public final String component29() {
            return this.requestCacheMissCount;
        }

        @Nullable
        public final String component30() {
            return this.priRequestCacheMissCount;
        }

        @Nullable
        public final String component31() {
            return this.flushTotal;
        }

        @Nullable
        public final String component32() {
            return this.priFlushTotal;
        }

        @Nullable
        public final String component33() {
            return this.flushTotalTime;
        }

        @Nullable
        public final String component34() {
            return this.priFlushTotalTime;
        }

        @Nullable
        public final String component35() {
            return this.getCurrent;
        }

        @Nullable
        public final String component36() {
            return this.priGetCurrent;
        }

        @Nullable
        public final String component37() {
            return this.getTime;
        }

        @Nullable
        public final String component38() {
            return this.priGetTime;
        }

        @Nullable
        public final String component39() {
            return this.getTotal;
        }

        @Nullable
        public final String component40() {
            return this.priGetTotal;
        }

        @Nullable
        public final String component41() {
            return this.getExistsTime;
        }

        @Nullable
        public final String component42() {
            return this.priGetExistsTime;
        }

        @Nullable
        public final String component43() {
            return this.getExistsTotal;
        }

        @Nullable
        public final String component44() {
            return this.priGetExistsTotal;
        }

        @Nullable
        public final String component45() {
            return this.getMissingTime;
        }

        @Nullable
        public final String component46() {
            return this.priGetMissingTime;
        }

        @Nullable
        public final String component47() {
            return this.getMissingTotal;
        }

        @Nullable
        public final String component48() {
            return this.priGetMissingTotal;
        }

        @Nullable
        public final String component49() {
            return this.indexingDeleteCurrent;
        }

        @Nullable
        public final String component50() {
            return this.priIndexingDeleteCurrent;
        }

        @Nullable
        public final String component51() {
            return this.indexingDeleteTime;
        }

        @Nullable
        public final String component52() {
            return this.priIndexingDeleteTime;
        }

        @Nullable
        public final String component53() {
            return this.indexingDeleteTotal;
        }

        @Nullable
        public final String component54() {
            return this.priIndexingDeleteTotal;
        }

        @Nullable
        public final String component55() {
            return this.indexingIndexCurrent;
        }

        @Nullable
        public final String component56() {
            return this.priIndexingIndexCurrent;
        }

        @Nullable
        public final String component57() {
            return this.indexingIndexTime;
        }

        @Nullable
        public final String component58() {
            return this.priIndexingIndexTime;
        }

        @Nullable
        public final String component59() {
            return this.indexingIndexTotal;
        }

        @Nullable
        public final String component60() {
            return this.priIndexingIndexTotal;
        }

        @Nullable
        public final String component61() {
            return this.indexingIndexFailed;
        }

        @Nullable
        public final String component62() {
            return this.priIndexingIndexFailed;
        }

        @Nullable
        public final String component63() {
            return this.mergesCurrent;
        }

        @Nullable
        public final String component64() {
            return this.priMergesCurrent;
        }

        @Nullable
        public final String component65() {
            return this.mergesCurrentDocs;
        }

        @Nullable
        public final String component66() {
            return this.priMergesCurrentDocs;
        }

        @Nullable
        public final String component67() {
            return this.mergesCurrentSize;
        }

        @Nullable
        public final String component68() {
            return this.priMergesCurrentSize;
        }

        @Nullable
        public final String component69() {
            return this.mergesTotal;
        }

        @Nullable
        public final String component70() {
            return this.priMergesTotal;
        }

        @Nullable
        public final String component71() {
            return this.mergesTotalDocs;
        }

        @Nullable
        public final String component72() {
            return this.priMergesTotalDocs;
        }

        @Nullable
        public final String component73() {
            return this.mergesTotalSize;
        }

        @Nullable
        public final String component74() {
            return this.priMergesTotalSize;
        }

        @Nullable
        public final String component75() {
            return this.mergesTotalTime;
        }

        @Nullable
        public final String component76() {
            return this.priMergesTotalTime;
        }

        @Nullable
        public final String component77() {
            return this.refreshTotal;
        }

        @Nullable
        public final String component78() {
            return this.priRefreshTotal;
        }

        @Nullable
        public final String component79() {
            return this.refreshTime;
        }

        @Nullable
        public final String component80() {
            return this.priRefreshTime;
        }

        @Nullable
        public final String component81() {
            return this.refreshExternalTotal;
        }

        @Nullable
        public final String component82() {
            return this.priRefreshExternalTotal;
        }

        @Nullable
        public final String component83() {
            return this.refreshExternalTime;
        }

        @Nullable
        public final String component84() {
            return this.priRefreshExternalTime;
        }

        @Nullable
        public final String component85() {
            return this.refreshListeners;
        }

        @Nullable
        public final String component86() {
            return this.priRefreshListeners;
        }

        @Nullable
        public final String component87() {
            return this.searchFetchCurrent;
        }

        @Nullable
        public final String component88() {
            return this.priSearchFetchCurrent;
        }

        @Nullable
        public final String component89() {
            return this.searchFetchTime;
        }

        @Nullable
        public final String component90() {
            return this.priSearchFetchTime;
        }

        @Nullable
        public final String component91() {
            return this.searchFetchTotal;
        }

        @Nullable
        public final String component92() {
            return this.priSearchFetchTotal;
        }

        @Nullable
        public final String component93() {
            return this.searchOpenContexts;
        }

        @Nullable
        public final String component94() {
            return this.priSearchOpenContexts;
        }

        @Nullable
        public final String component95() {
            return this.searchQueryCurrent;
        }

        @Nullable
        public final String component96() {
            return this.priSearchQueryCurrent;
        }

        @Nullable
        public final String component97() {
            return this.searchQueryTime;
        }

        @Nullable
        public final String component98() {
            return this.priSearchQueryTime;
        }

        @Nullable
        public final String component99() {
            return this.searchQueryTotal;
        }

        @Nullable
        public final String component100() {
            return this.priSearchQueryTotal;
        }

        @Nullable
        public final String component101() {
            return this.searchScrollCurrent;
        }

        @Nullable
        public final String component102() {
            return this.priSearchScrollCurrent;
        }

        @Nullable
        public final String component103() {
            return this.searchScrollTime;
        }

        @Nullable
        public final String component104() {
            return this.priSearchScrollTime;
        }

        @Nullable
        public final String component105() {
            return this.searchScrollTotal;
        }

        @Nullable
        public final String component106() {
            return this.priSearchScrollTotal;
        }

        @Nullable
        public final String component107() {
            return this.searchPointInTimeCurrent;
        }

        @Nullable
        public final String component108() {
            return this.priSearchPointInTimeCurrent;
        }

        @Nullable
        public final String component109() {
            return this.searchPointInTimeTime;
        }

        @Nullable
        public final String component110() {
            return this.priSearchPointInTimeTime;
        }

        @Nullable
        public final String component111() {
            return this.searchPointInTimeTotal;
        }

        @Nullable
        public final String component112() {
            return this.priSearchPointInTimeTotal;
        }

        @Nullable
        public final String component113() {
            return this.segmentsCount;
        }

        @Nullable
        public final String component114() {
            return this.priSegmentsCount;
        }

        @Nullable
        public final String component115() {
            return this.segmentsMemory;
        }

        @Nullable
        public final String component116() {
            return this.priSegmentsMemory;
        }

        @Nullable
        public final String component117() {
            return this.segmentsIndexWriterMemory;
        }

        @Nullable
        public final String component118() {
            return this.priSegmentsIndexWriterMemory;
        }

        @Nullable
        public final String component119() {
            return this.segmentsVersionMapMemory;
        }

        @Nullable
        public final String component120() {
            return this.priSegmentsVersionMapMemory;
        }

        @Nullable
        public final String component121() {
            return this.segmentsFixedBitsetMemory;
        }

        @Nullable
        public final String component122() {
            return this.priSegmentsFixedBitsetMemory;
        }

        @Nullable
        public final String component123() {
            return this.warmerCurrent;
        }

        @Nullable
        public final String component124() {
            return this.priWarmerCurrent;
        }

        @Nullable
        public final String component125() {
            return this.warmerTotal;
        }

        @Nullable
        public final String component126() {
            return this.priWarmerTotal;
        }

        @Nullable
        public final String component127() {
            return this.warmerTotalTime;
        }

        @Nullable
        public final String component128() {
            return this.priWarmerTotalTime;
        }

        @Nullable
        public final String component129() {
            return this.suggestCurrent;
        }

        @Nullable
        public final String component130() {
            return this.priSuggestCurrent;
        }

        @Nullable
        public final String component131() {
            return this.suggestTime;
        }

        @Nullable
        public final String component132() {
            return this.priSuggestTime;
        }

        @Nullable
        public final String component133() {
            return this.suggestTotal;
        }

        @Nullable
        public final String component134() {
            return this.priSuggestTotal;
        }

        @Nullable
        public final String component135() {
            return this.memoryTotal;
        }

        @Nullable
        public final String component136() {
            return this.priMemoryTotal;
        }

        @Nullable
        public final String component137() {
            return this.searchThrottled;
        }

        @NotNull
        public final IndexInfo copy(String health, String status, String index, String uuid, String pri, String rep, String docsCount, String docsDeleted, String creationDate, String creationDateString, String storeSize, String priStoreSize, String completionSize, String priCompletionSize, String fieldDataMemorySize, String priFieldDataMemorySize, String fieldDataEvictions, String priFieldDataEvictions, String queryCacheMemorySize, String priQueryCacheMemorySize, String queryCacheEvictions, String priQueryCacheEvictions, String requestCacheMemorySize, String priRequestCacheMemorySize, String requestCacheEvictions, String priRequestCacheEvictions, String requestCacheHitCount, String priRequestCacheHitCount, String requestCacheMissCount, String priRequestCacheMissCount, String flushTotal, String priFlushTotal, String flushTotalTime, String priFlushTotalTime, String getCurrent, String priGetCurrent, String getTime, String priGetTime, String getTotal, String priGetTotal, String getExistsTime, String priGetExistsTime, String getExistsTotal, String priGetExistsTotal, String getMissingTime, String priGetMissingTime, String getMissingTotal, String priGetMissingTotal, String indexingDeleteCurrent, String priIndexingDeleteCurrent, String indexingDeleteTime, String priIndexingDeleteTime, String indexingDeleteTotal, String priIndexingDeleteTotal, String indexingIndexCurrent, String priIndexingIndexCurrent, String indexingIndexTime, String priIndexingIndexTime, String indexingIndexTotal, String priIndexingIndexTotal, String indexingIndexFailed, String priIndexingIndexFailed, String mergesCurrent, String priMergesCurrent, String mergesCurrentDocs, String priMergesCurrentDocs, String mergesCurrentSize, String priMergesCurrentSize, String mergesTotal, String priMergesTotal, String mergesTotalDocs, String priMergesTotalDocs, String mergesTotalSize, String priMergesTotalSize, String mergesTotalTime, String priMergesTotalTime, String refreshTotal, String priRefreshTotal, String refreshTime, String priRefreshTime, String refreshExternalTotal, String priRefreshExternalTotal, String refreshExternalTime, String priRefreshExternalTime, String refreshListeners, String priRefreshListeners, String searchFetchCurrent, String priSearchFetchCurrent, String searchFetchTime, String priSearchFetchTime, String searchFetchTotal, String priSearchFetchTotal, String searchOpenContexts, String priSearchOpenContexts, String searchQueryCurrent, String priSearchQueryCurrent, String searchQueryTime, String priSearchQueryTime, String searchQueryTotal, String priSearchQueryTotal, String searchScrollCurrent, String priSearchScrollCurrent, String searchScrollTime, String priSearchScrollTime, String searchScrollTotal, String priSearchScrollTotal, String searchPointInTimeCurrent, String priSearchPointInTimeCurrent, String searchPointInTimeTime, String priSearchPointInTimeTime, String searchPointInTimeTotal, String priSearchPointInTimeTotal, String segmentsCount, String priSegmentsCount, String segmentsMemory, String priSegmentsMemory, String segmentsIndexWriterMemory, String priSegmentsIndexWriterMemory, String segmentsVersionMapMemory, String priSegmentsVersionMapMemory, String segmentsFixedBitsetMemory, String priSegmentsFixedBitsetMemory, String warmerCurrent, String priWarmerCurrent, String warmerTotal, String priWarmerTotal, String warmerTotalTime, String priWarmerTotalTime, String suggestCurrent, String priSuggestCurrent, String suggestTime, String priSuggestTime, String suggestTotal, String priSuggestTotal, String memoryTotal, String priMemoryTotal, String searchThrottled) {
            return new IndexInfo(health, status, index, uuid, pri, rep, docsCount, docsDeleted, creationDate, creationDateString, storeSize, priStoreSize, completionSize, priCompletionSize, fieldDataMemorySize, priFieldDataMemorySize, fieldDataEvictions, priFieldDataEvictions, queryCacheMemorySize, priQueryCacheMemorySize, queryCacheEvictions, priQueryCacheEvictions, requestCacheMemorySize, priRequestCacheMemorySize, requestCacheEvictions, priRequestCacheEvictions, requestCacheHitCount, priRequestCacheHitCount, requestCacheMissCount, priRequestCacheMissCount, flushTotal, priFlushTotal, flushTotalTime, priFlushTotalTime, getCurrent, priGetCurrent, getTime, priGetTime, getTotal, priGetTotal, getExistsTime, priGetExistsTime, getExistsTotal, priGetExistsTotal, getMissingTime, priGetMissingTime, getMissingTotal, priGetMissingTotal, indexingDeleteCurrent, priIndexingDeleteCurrent, indexingDeleteTime, priIndexingDeleteTime, indexingDeleteTotal, priIndexingDeleteTotal, indexingIndexCurrent, priIndexingIndexCurrent, indexingIndexTime, priIndexingIndexTime, indexingIndexTotal, priIndexingIndexTotal, indexingIndexFailed, priIndexingIndexFailed, mergesCurrent, priMergesCurrent, mergesCurrentDocs, priMergesCurrentDocs, mergesCurrentSize, priMergesCurrentSize, mergesTotal, priMergesTotal, mergesTotalDocs, priMergesTotalDocs, mergesTotalSize, priMergesTotalSize, mergesTotalTime, priMergesTotalTime, refreshTotal, priRefreshTotal, refreshTime, priRefreshTime, refreshExternalTotal, priRefreshExternalTotal, refreshExternalTime, priRefreshExternalTime, refreshListeners, priRefreshListeners, searchFetchCurrent, priSearchFetchCurrent, searchFetchTime, priSearchFetchTime, searchFetchTotal, priSearchFetchTotal, searchOpenContexts, priSearchOpenContexts, searchQueryCurrent, priSearchQueryCurrent, searchQueryTime, priSearchQueryTime, searchQueryTotal, priSearchQueryTotal, searchScrollCurrent, priSearchScrollCurrent, searchScrollTime, priSearchScrollTime, searchScrollTotal, priSearchScrollTotal, searchPointInTimeCurrent, priSearchPointInTimeCurrent, searchPointInTimeTime, priSearchPointInTimeTime, searchPointInTimeTotal, priSearchPointInTimeTotal, segmentsCount, priSegmentsCount, segmentsMemory, priSegmentsMemory, segmentsIndexWriterMemory, priSegmentsIndexWriterMemory, segmentsVersionMapMemory, priSegmentsVersionMapMemory, segmentsFixedBitsetMemory, priSegmentsFixedBitsetMemory, warmerCurrent, priWarmerCurrent, warmerTotal, priWarmerTotal, warmerTotalTime, priWarmerTotalTime, suggestCurrent, priSuggestCurrent, suggestTime, priSuggestTime, suggestTotal, priSuggestTotal, memoryTotal, priMemoryTotal, searchThrottled);
        }

        public static /* synthetic */ IndexInfo copy$default(IndexInfo indexInfo, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, String string33, String string34, String string35, String string36, String string37, String string38, String string39, String string40, String string41, String string42, String string43, String string44, String string45, String string46, String string47, String string48, String string49, String string50, String string51, String string52, String string53, String string54, String string55, String string56, String string57, String string58, String string59, String string60, String string61, String string62, String string63, String string64, String string65, String string66, String string67, String string68, String string69, String string70, String string71, String string72, String string73, String string74, String string75, String string76, String string77, String string78, String string79, String string80, String string81, String string82, String string83, String string84, String string85, String string86, String string87, String string88, String string89, String string90, String string91, String string92, String string93, String string94, String string95, String string96, String string97, String string98, String string99, String string100, String string101, String string102, String string103, String string104, String string105, String string106, String string107, String string108, String string109, String string110, String string111, String string112, String string113, String string114, String string115, String string116, String string117, String string118, String string119, String string120, String string121, String string122, String string123, String string124, String string125, String string126, String string127, String string128, String string129, String string130, String string131, String string132, String string133, String string134, String string135, String string136, String string137, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n & 1) != 0) {
                string = indexInfo.health;
            }
            if ((n & 2) != 0) {
                string2 = indexInfo.status;
            }
            if ((n & 4) != 0) {
                string3 = indexInfo.index;
            }
            if ((n & 8) != 0) {
                string4 = indexInfo.uuid;
            }
            if ((n & 0x10) != 0) {
                string5 = indexInfo.pri;
            }
            if ((n & 0x20) != 0) {
                string6 = indexInfo.rep;
            }
            if ((n & 0x40) != 0) {
                string7 = indexInfo.docsCount;
            }
            if ((n & 0x80) != 0) {
                string8 = indexInfo.docsDeleted;
            }
            if ((n & 0x100) != 0) {
                string9 = indexInfo.creationDate;
            }
            if ((n & 0x200) != 0) {
                string10 = indexInfo.creationDateString;
            }
            if ((n & 0x400) != 0) {
                string11 = indexInfo.storeSize;
            }
            if ((n & 0x800) != 0) {
                string12 = indexInfo.priStoreSize;
            }
            if ((n & 0x1000) != 0) {
                string13 = indexInfo.completionSize;
            }
            if ((n & 0x2000) != 0) {
                string14 = indexInfo.priCompletionSize;
            }
            if ((n & 0x4000) != 0) {
                string15 = indexInfo.fieldDataMemorySize;
            }
            if ((n & 0x8000) != 0) {
                string16 = indexInfo.priFieldDataMemorySize;
            }
            if ((n & 0x10000) != 0) {
                string17 = indexInfo.fieldDataEvictions;
            }
            if ((n & 0x20000) != 0) {
                string18 = indexInfo.priFieldDataEvictions;
            }
            if ((n & 0x40000) != 0) {
                string19 = indexInfo.queryCacheMemorySize;
            }
            if ((n & 0x80000) != 0) {
                string20 = indexInfo.priQueryCacheMemorySize;
            }
            if ((n & 0x100000) != 0) {
                string21 = indexInfo.queryCacheEvictions;
            }
            if ((n & 0x200000) != 0) {
                string22 = indexInfo.priQueryCacheEvictions;
            }
            if ((n & 0x400000) != 0) {
                string23 = indexInfo.requestCacheMemorySize;
            }
            if ((n & 0x800000) != 0) {
                string24 = indexInfo.priRequestCacheMemorySize;
            }
            if ((n & 0x1000000) != 0) {
                string25 = indexInfo.requestCacheEvictions;
            }
            if ((n & 0x2000000) != 0) {
                string26 = indexInfo.priRequestCacheEvictions;
            }
            if ((n & 0x4000000) != 0) {
                string27 = indexInfo.requestCacheHitCount;
            }
            if ((n & 0x8000000) != 0) {
                string28 = indexInfo.priRequestCacheHitCount;
            }
            if ((n & 0x10000000) != 0) {
                string29 = indexInfo.requestCacheMissCount;
            }
            if ((n & 0x20000000) != 0) {
                string30 = indexInfo.priRequestCacheMissCount;
            }
            if ((n & 0x40000000) != 0) {
                string31 = indexInfo.flushTotal;
            }
            if ((n & Integer.MIN_VALUE) != 0) {
                string32 = indexInfo.priFlushTotal;
            }
            if ((n2 & 1) != 0) {
                string33 = indexInfo.flushTotalTime;
            }
            if ((n2 & 2) != 0) {
                string34 = indexInfo.priFlushTotalTime;
            }
            if ((n2 & 4) != 0) {
                string35 = indexInfo.getCurrent;
            }
            if ((n2 & 8) != 0) {
                string36 = indexInfo.priGetCurrent;
            }
            if ((n2 & 0x10) != 0) {
                string37 = indexInfo.getTime;
            }
            if ((n2 & 0x20) != 0) {
                string38 = indexInfo.priGetTime;
            }
            if ((n2 & 0x40) != 0) {
                string39 = indexInfo.getTotal;
            }
            if ((n2 & 0x80) != 0) {
                string40 = indexInfo.priGetTotal;
            }
            if ((n2 & 0x100) != 0) {
                string41 = indexInfo.getExistsTime;
            }
            if ((n2 & 0x200) != 0) {
                string42 = indexInfo.priGetExistsTime;
            }
            if ((n2 & 0x400) != 0) {
                string43 = indexInfo.getExistsTotal;
            }
            if ((n2 & 0x800) != 0) {
                string44 = indexInfo.priGetExistsTotal;
            }
            if ((n2 & 0x1000) != 0) {
                string45 = indexInfo.getMissingTime;
            }
            if ((n2 & 0x2000) != 0) {
                string46 = indexInfo.priGetMissingTime;
            }
            if ((n2 & 0x4000) != 0) {
                string47 = indexInfo.getMissingTotal;
            }
            if ((n2 & 0x8000) != 0) {
                string48 = indexInfo.priGetMissingTotal;
            }
            if ((n2 & 0x10000) != 0) {
                string49 = indexInfo.indexingDeleteCurrent;
            }
            if ((n2 & 0x20000) != 0) {
                string50 = indexInfo.priIndexingDeleteCurrent;
            }
            if ((n2 & 0x40000) != 0) {
                string51 = indexInfo.indexingDeleteTime;
            }
            if ((n2 & 0x80000) != 0) {
                string52 = indexInfo.priIndexingDeleteTime;
            }
            if ((n2 & 0x100000) != 0) {
                string53 = indexInfo.indexingDeleteTotal;
            }
            if ((n2 & 0x200000) != 0) {
                string54 = indexInfo.priIndexingDeleteTotal;
            }
            if ((n2 & 0x400000) != 0) {
                string55 = indexInfo.indexingIndexCurrent;
            }
            if ((n2 & 0x800000) != 0) {
                string56 = indexInfo.priIndexingIndexCurrent;
            }
            if ((n2 & 0x1000000) != 0) {
                string57 = indexInfo.indexingIndexTime;
            }
            if ((n2 & 0x2000000) != 0) {
                string58 = indexInfo.priIndexingIndexTime;
            }
            if ((n2 & 0x4000000) != 0) {
                string59 = indexInfo.indexingIndexTotal;
            }
            if ((n2 & 0x8000000) != 0) {
                string60 = indexInfo.priIndexingIndexTotal;
            }
            if ((n2 & 0x10000000) != 0) {
                string61 = indexInfo.indexingIndexFailed;
            }
            if ((n2 & 0x20000000) != 0) {
                string62 = indexInfo.priIndexingIndexFailed;
            }
            if ((n2 & 0x40000000) != 0) {
                string63 = indexInfo.mergesCurrent;
            }
            if ((n2 & Integer.MIN_VALUE) != 0) {
                string64 = indexInfo.priMergesCurrent;
            }
            if ((n3 & 1) != 0) {
                string65 = indexInfo.mergesCurrentDocs;
            }
            if ((n3 & 2) != 0) {
                string66 = indexInfo.priMergesCurrentDocs;
            }
            if ((n3 & 4) != 0) {
                string67 = indexInfo.mergesCurrentSize;
            }
            if ((n3 & 8) != 0) {
                string68 = indexInfo.priMergesCurrentSize;
            }
            if ((n3 & 0x10) != 0) {
                string69 = indexInfo.mergesTotal;
            }
            if ((n3 & 0x20) != 0) {
                string70 = indexInfo.priMergesTotal;
            }
            if ((n3 & 0x40) != 0) {
                string71 = indexInfo.mergesTotalDocs;
            }
            if ((n3 & 0x80) != 0) {
                string72 = indexInfo.priMergesTotalDocs;
            }
            if ((n3 & 0x100) != 0) {
                string73 = indexInfo.mergesTotalSize;
            }
            if ((n3 & 0x200) != 0) {
                string74 = indexInfo.priMergesTotalSize;
            }
            if ((n3 & 0x400) != 0) {
                string75 = indexInfo.mergesTotalTime;
            }
            if ((n3 & 0x800) != 0) {
                string76 = indexInfo.priMergesTotalTime;
            }
            if ((n3 & 0x1000) != 0) {
                string77 = indexInfo.refreshTotal;
            }
            if ((n3 & 0x2000) != 0) {
                string78 = indexInfo.priRefreshTotal;
            }
            if ((n3 & 0x4000) != 0) {
                string79 = indexInfo.refreshTime;
            }
            if ((n3 & 0x8000) != 0) {
                string80 = indexInfo.priRefreshTime;
            }
            if ((n3 & 0x10000) != 0) {
                string81 = indexInfo.refreshExternalTotal;
            }
            if ((n3 & 0x20000) != 0) {
                string82 = indexInfo.priRefreshExternalTotal;
            }
            if ((n3 & 0x40000) != 0) {
                string83 = indexInfo.refreshExternalTime;
            }
            if ((n3 & 0x80000) != 0) {
                string84 = indexInfo.priRefreshExternalTime;
            }
            if ((n3 & 0x100000) != 0) {
                string85 = indexInfo.refreshListeners;
            }
            if ((n3 & 0x200000) != 0) {
                string86 = indexInfo.priRefreshListeners;
            }
            if ((n3 & 0x400000) != 0) {
                string87 = indexInfo.searchFetchCurrent;
            }
            if ((n3 & 0x800000) != 0) {
                string88 = indexInfo.priSearchFetchCurrent;
            }
            if ((n3 & 0x1000000) != 0) {
                string89 = indexInfo.searchFetchTime;
            }
            if ((n3 & 0x2000000) != 0) {
                string90 = indexInfo.priSearchFetchTime;
            }
            if ((n3 & 0x4000000) != 0) {
                string91 = indexInfo.searchFetchTotal;
            }
            if ((n3 & 0x8000000) != 0) {
                string92 = indexInfo.priSearchFetchTotal;
            }
            if ((n3 & 0x10000000) != 0) {
                string93 = indexInfo.searchOpenContexts;
            }
            if ((n3 & 0x20000000) != 0) {
                string94 = indexInfo.priSearchOpenContexts;
            }
            if ((n3 & 0x40000000) != 0) {
                string95 = indexInfo.searchQueryCurrent;
            }
            if ((n3 & Integer.MIN_VALUE) != 0) {
                string96 = indexInfo.priSearchQueryCurrent;
            }
            if ((n4 & 1) != 0) {
                string97 = indexInfo.searchQueryTime;
            }
            if ((n4 & 2) != 0) {
                string98 = indexInfo.priSearchQueryTime;
            }
            if ((n4 & 4) != 0) {
                string99 = indexInfo.searchQueryTotal;
            }
            if ((n4 & 8) != 0) {
                string100 = indexInfo.priSearchQueryTotal;
            }
            if ((n4 & 0x10) != 0) {
                string101 = indexInfo.searchScrollCurrent;
            }
            if ((n4 & 0x20) != 0) {
                string102 = indexInfo.priSearchScrollCurrent;
            }
            if ((n4 & 0x40) != 0) {
                string103 = indexInfo.searchScrollTime;
            }
            if ((n4 & 0x80) != 0) {
                string104 = indexInfo.priSearchScrollTime;
            }
            if ((n4 & 0x100) != 0) {
                string105 = indexInfo.searchScrollTotal;
            }
            if ((n4 & 0x200) != 0) {
                string106 = indexInfo.priSearchScrollTotal;
            }
            if ((n4 & 0x400) != 0) {
                string107 = indexInfo.searchPointInTimeCurrent;
            }
            if ((n4 & 0x800) != 0) {
                string108 = indexInfo.priSearchPointInTimeCurrent;
            }
            if ((n4 & 0x1000) != 0) {
                string109 = indexInfo.searchPointInTimeTime;
            }
            if ((n4 & 0x2000) != 0) {
                string110 = indexInfo.priSearchPointInTimeTime;
            }
            if ((n4 & 0x4000) != 0) {
                string111 = indexInfo.searchPointInTimeTotal;
            }
            if ((n4 & 0x8000) != 0) {
                string112 = indexInfo.priSearchPointInTimeTotal;
            }
            if ((n4 & 0x10000) != 0) {
                string113 = indexInfo.segmentsCount;
            }
            if ((n4 & 0x20000) != 0) {
                string114 = indexInfo.priSegmentsCount;
            }
            if ((n4 & 0x40000) != 0) {
                string115 = indexInfo.segmentsMemory;
            }
            if ((n4 & 0x80000) != 0) {
                string116 = indexInfo.priSegmentsMemory;
            }
            if ((n4 & 0x100000) != 0) {
                string117 = indexInfo.segmentsIndexWriterMemory;
            }
            if ((n4 & 0x200000) != 0) {
                string118 = indexInfo.priSegmentsIndexWriterMemory;
            }
            if ((n4 & 0x400000) != 0) {
                string119 = indexInfo.segmentsVersionMapMemory;
            }
            if ((n4 & 0x800000) != 0) {
                string120 = indexInfo.priSegmentsVersionMapMemory;
            }
            if ((n4 & 0x1000000) != 0) {
                string121 = indexInfo.segmentsFixedBitsetMemory;
            }
            if ((n4 & 0x2000000) != 0) {
                string122 = indexInfo.priSegmentsFixedBitsetMemory;
            }
            if ((n4 & 0x4000000) != 0) {
                string123 = indexInfo.warmerCurrent;
            }
            if ((n4 & 0x8000000) != 0) {
                string124 = indexInfo.priWarmerCurrent;
            }
            if ((n4 & 0x10000000) != 0) {
                string125 = indexInfo.warmerTotal;
            }
            if ((n4 & 0x20000000) != 0) {
                string126 = indexInfo.priWarmerTotal;
            }
            if ((n4 & 0x40000000) != 0) {
                string127 = indexInfo.warmerTotalTime;
            }
            if ((n4 & Integer.MIN_VALUE) != 0) {
                string128 = indexInfo.priWarmerTotalTime;
            }
            if ((n5 & 1) != 0) {
                string129 = indexInfo.suggestCurrent;
            }
            if ((n5 & 2) != 0) {
                string130 = indexInfo.priSuggestCurrent;
            }
            if ((n5 & 4) != 0) {
                string131 = indexInfo.suggestTime;
            }
            if ((n5 & 8) != 0) {
                string132 = indexInfo.priSuggestTime;
            }
            if ((n5 & 0x10) != 0) {
                string133 = indexInfo.suggestTotal;
            }
            if ((n5 & 0x20) != 0) {
                string134 = indexInfo.priSuggestTotal;
            }
            if ((n5 & 0x40) != 0) {
                string135 = indexInfo.memoryTotal;
            }
            if ((n5 & 0x80) != 0) {
                string136 = indexInfo.priMemoryTotal;
            }
            if ((n5 & 0x100) != 0) {
                string137 = indexInfo.searchThrottled;
            }
            return indexInfo.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, string25, string26, string27, string28, string29, string30, string31, string32, string33, string34, string35, string36, string37, string38, string39, string40, string41, string42, string43, string44, string45, string46, string47, string48, string49, string50, string51, string52, string53, string54, string55, string56, string57, string58, string59, string60, string61, string62, string63, string64, string65, string66, string67, string68, string69, string70, string71, string72, string73, string74, string75, string76, string77, string78, string79, string80, string81, string82, string83, string84, string85, string86, string87, string88, string89, string90, string91, string92, string93, string94, string95, string96, string97, string98, string99, string100, string101, string102, string103, string104, string105, string106, string107, string108, string109, string110, string111, string112, string113, string114, string115, string116, string117, string118, string119, string120, string121, string122, string123, string124, string125, string126, string127, string128, string129, string130, string131, string132, string133, string134, string135, string136, string137);
        }

        @NotNull
        public String toString() {
            return "IndexInfo(health=" + this.health + ", status=" + this.status + ", index=" + this.index + ", uuid=" + this.uuid + ", pri=" + this.pri + ", rep=" + this.rep + ", docsCount=" + this.docsCount + ", docsDeleted=" + this.docsDeleted + ", creationDate=" + this.creationDate + ", creationDateString=" + this.creationDateString + ", storeSize=" + this.storeSize + ", priStoreSize=" + this.priStoreSize + ", completionSize=" + this.completionSize + ", priCompletionSize=" + this.priCompletionSize + ", fieldDataMemorySize=" + this.fieldDataMemorySize + ", priFieldDataMemorySize=" + this.priFieldDataMemorySize + ", fieldDataEvictions=" + this.fieldDataEvictions + ", priFieldDataEvictions=" + this.priFieldDataEvictions + ", queryCacheMemorySize=" + this.queryCacheMemorySize + ", priQueryCacheMemorySize=" + this.priQueryCacheMemorySize + ", queryCacheEvictions=" + this.queryCacheEvictions + ", priQueryCacheEvictions=" + this.priQueryCacheEvictions + ", requestCacheMemorySize=" + this.requestCacheMemorySize + ", priRequestCacheMemorySize=" + this.priRequestCacheMemorySize + ", requestCacheEvictions=" + this.requestCacheEvictions + ", priRequestCacheEvictions=" + this.priRequestCacheEvictions + ", requestCacheHitCount=" + this.requestCacheHitCount + ", priRequestCacheHitCount=" + this.priRequestCacheHitCount + ", requestCacheMissCount=" + this.requestCacheMissCount + ", priRequestCacheMissCount=" + this.priRequestCacheMissCount + ", flushTotal=" + this.flushTotal + ", priFlushTotal=" + this.priFlushTotal + ", flushTotalTime=" + this.flushTotalTime + ", priFlushTotalTime=" + this.priFlushTotalTime + ", getCurrent=" + this.getCurrent + ", priGetCurrent=" + this.priGetCurrent + ", getTime=" + this.getTime + ", priGetTime=" + this.priGetTime + ", getTotal=" + this.getTotal + ", priGetTotal=" + this.priGetTotal + ", getExistsTime=" + this.getExistsTime + ", priGetExistsTime=" + this.priGetExistsTime + ", getExistsTotal=" + this.getExistsTotal + ", priGetExistsTotal=" + this.priGetExistsTotal + ", getMissingTime=" + this.getMissingTime + ", priGetMissingTime=" + this.priGetMissingTime + ", getMissingTotal=" + this.getMissingTotal + ", priGetMissingTotal=" + this.priGetMissingTotal + ", indexingDeleteCurrent=" + this.indexingDeleteCurrent + ", priIndexingDeleteCurrent=" + this.priIndexingDeleteCurrent + ", indexingDeleteTime=" + this.indexingDeleteTime + ", priIndexingDeleteTime=" + this.priIndexingDeleteTime + ", indexingDeleteTotal=" + this.indexingDeleteTotal + ", priIndexingDeleteTotal=" + this.priIndexingDeleteTotal + ", indexingIndexCurrent=" + this.indexingIndexCurrent + ", priIndexingIndexCurrent=" + this.priIndexingIndexCurrent + ", indexingIndexTime=" + this.indexingIndexTime + ", priIndexingIndexTime=" + this.priIndexingIndexTime + ", indexingIndexTotal=" + this.indexingIndexTotal + ", priIndexingIndexTotal=" + this.priIndexingIndexTotal + ", indexingIndexFailed=" + this.indexingIndexFailed + ", priIndexingIndexFailed=" + this.priIndexingIndexFailed + ", mergesCurrent=" + this.mergesCurrent + ", priMergesCurrent=" + this.priMergesCurrent + ", mergesCurrentDocs=" + this.mergesCurrentDocs + ", priMergesCurrentDocs=" + this.priMergesCurrentDocs + ", mergesCurrentSize=" + this.mergesCurrentSize + ", priMergesCurrentSize=" + this.priMergesCurrentSize + ", mergesTotal=" + this.mergesTotal + ", priMergesTotal=" + this.priMergesTotal + ", mergesTotalDocs=" + this.mergesTotalDocs + ", priMergesTotalDocs=" + this.priMergesTotalDocs + ", mergesTotalSize=" + this.mergesTotalSize + ", priMergesTotalSize=" + this.priMergesTotalSize + ", mergesTotalTime=" + this.mergesTotalTime + ", priMergesTotalTime=" + this.priMergesTotalTime + ", refreshTotal=" + this.refreshTotal + ", priRefreshTotal=" + this.priRefreshTotal + ", refreshTime=" + this.refreshTime + ", priRefreshTime=" + this.priRefreshTime + ", refreshExternalTotal=" + this.refreshExternalTotal + ", priRefreshExternalTotal=" + this.priRefreshExternalTotal + ", refreshExternalTime=" + this.refreshExternalTime + ", priRefreshExternalTime=" + this.priRefreshExternalTime + ", refreshListeners=" + this.refreshListeners + ", priRefreshListeners=" + this.priRefreshListeners + ", searchFetchCurrent=" + this.searchFetchCurrent + ", priSearchFetchCurrent=" + this.priSearchFetchCurrent + ", searchFetchTime=" + this.searchFetchTime + ", priSearchFetchTime=" + this.priSearchFetchTime + ", searchFetchTotal=" + this.searchFetchTotal + ", priSearchFetchTotal=" + this.priSearchFetchTotal + ", searchOpenContexts=" + this.searchOpenContexts + ", priSearchOpenContexts=" + this.priSearchOpenContexts + ", searchQueryCurrent=" + this.searchQueryCurrent + ", priSearchQueryCurrent=" + this.priSearchQueryCurrent + ", searchQueryTime=" + this.searchQueryTime + ", priSearchQueryTime=" + this.priSearchQueryTime + ", searchQueryTotal=" + this.searchQueryTotal + ", priSearchQueryTotal=" + this.priSearchQueryTotal + ", searchScrollCurrent=" + this.searchScrollCurrent + ", priSearchScrollCurrent=" + this.priSearchScrollCurrent + ", searchScrollTime=" + this.searchScrollTime + ", priSearchScrollTime=" + this.priSearchScrollTime + ", searchScrollTotal=" + this.searchScrollTotal + ", priSearchScrollTotal=" + this.priSearchScrollTotal + ", searchPointInTimeCurrent=" + this.searchPointInTimeCurrent + ", priSearchPointInTimeCurrent=" + this.priSearchPointInTimeCurrent + ", searchPointInTimeTime=" + this.searchPointInTimeTime + ", priSearchPointInTimeTime=" + this.priSearchPointInTimeTime + ", searchPointInTimeTotal=" + this.searchPointInTimeTotal + ", priSearchPointInTimeTotal=" + this.priSearchPointInTimeTotal + ", segmentsCount=" + this.segmentsCount + ", priSegmentsCount=" + this.priSegmentsCount + ", segmentsMemory=" + this.segmentsMemory + ", priSegmentsMemory=" + this.priSegmentsMemory + ", segmentsIndexWriterMemory=" + this.segmentsIndexWriterMemory + ", priSegmentsIndexWriterMemory=" + this.priSegmentsIndexWriterMemory + ", segmentsVersionMapMemory=" + this.segmentsVersionMapMemory + ", priSegmentsVersionMapMemory=" + this.priSegmentsVersionMapMemory + ", segmentsFixedBitsetMemory=" + this.segmentsFixedBitsetMemory + ", priSegmentsFixedBitsetMemory=" + this.priSegmentsFixedBitsetMemory + ", warmerCurrent=" + this.warmerCurrent + ", priWarmerCurrent=" + this.priWarmerCurrent + ", warmerTotal=" + this.warmerTotal + ", priWarmerTotal=" + this.priWarmerTotal + ", warmerTotalTime=" + this.warmerTotalTime + ", priWarmerTotalTime=" + this.priWarmerTotalTime + ", suggestCurrent=" + this.suggestCurrent + ", priSuggestCurrent=" + this.priSuggestCurrent + ", suggestTime=" + this.suggestTime + ", priSuggestTime=" + this.priSuggestTime + ", suggestTotal=" + this.suggestTotal + ", priSuggestTotal=" + this.priSuggestTotal + ", memoryTotal=" + this.memoryTotal + ", priMemoryTotal=" + this.priMemoryTotal + ", searchThrottled=" + this.searchThrottled + ")";
        }

        public int hashCode() {
            int result = this.health == null ? 0 : this.health.hashCode();
            result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
            result = result * 31 + (this.index == null ? 0 : this.index.hashCode());
            result = result * 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
            result = result * 31 + (this.pri == null ? 0 : this.pri.hashCode());
            result = result * 31 + (this.rep == null ? 0 : this.rep.hashCode());
            result = result * 31 + (this.docsCount == null ? 0 : this.docsCount.hashCode());
            result = result * 31 + (this.docsDeleted == null ? 0 : this.docsDeleted.hashCode());
            result = result * 31 + (this.creationDate == null ? 0 : this.creationDate.hashCode());
            result = result * 31 + (this.creationDateString == null ? 0 : this.creationDateString.hashCode());
            result = result * 31 + (this.storeSize == null ? 0 : this.storeSize.hashCode());
            result = result * 31 + (this.priStoreSize == null ? 0 : this.priStoreSize.hashCode());
            result = result * 31 + (this.completionSize == null ? 0 : this.completionSize.hashCode());
            result = result * 31 + (this.priCompletionSize == null ? 0 : this.priCompletionSize.hashCode());
            result = result * 31 + (this.fieldDataMemorySize == null ? 0 : this.fieldDataMemorySize.hashCode());
            result = result * 31 + (this.priFieldDataMemorySize == null ? 0 : this.priFieldDataMemorySize.hashCode());
            result = result * 31 + (this.fieldDataEvictions == null ? 0 : this.fieldDataEvictions.hashCode());
            result = result * 31 + (this.priFieldDataEvictions == null ? 0 : this.priFieldDataEvictions.hashCode());
            result = result * 31 + (this.queryCacheMemorySize == null ? 0 : this.queryCacheMemorySize.hashCode());
            result = result * 31 + (this.priQueryCacheMemorySize == null ? 0 : this.priQueryCacheMemorySize.hashCode());
            result = result * 31 + (this.queryCacheEvictions == null ? 0 : this.queryCacheEvictions.hashCode());
            result = result * 31 + (this.priQueryCacheEvictions == null ? 0 : this.priQueryCacheEvictions.hashCode());
            result = result * 31 + (this.requestCacheMemorySize == null ? 0 : this.requestCacheMemorySize.hashCode());
            result = result * 31 + (this.priRequestCacheMemorySize == null ? 0 : this.priRequestCacheMemorySize.hashCode());
            result = result * 31 + (this.requestCacheEvictions == null ? 0 : this.requestCacheEvictions.hashCode());
            result = result * 31 + (this.priRequestCacheEvictions == null ? 0 : this.priRequestCacheEvictions.hashCode());
            result = result * 31 + (this.requestCacheHitCount == null ? 0 : this.requestCacheHitCount.hashCode());
            result = result * 31 + (this.priRequestCacheHitCount == null ? 0 : this.priRequestCacheHitCount.hashCode());
            result = result * 31 + (this.requestCacheMissCount == null ? 0 : this.requestCacheMissCount.hashCode());
            result = result * 31 + (this.priRequestCacheMissCount == null ? 0 : this.priRequestCacheMissCount.hashCode());
            result = result * 31 + (this.flushTotal == null ? 0 : this.flushTotal.hashCode());
            result = result * 31 + (this.priFlushTotal == null ? 0 : this.priFlushTotal.hashCode());
            result = result * 31 + (this.flushTotalTime == null ? 0 : this.flushTotalTime.hashCode());
            result = result * 31 + (this.priFlushTotalTime == null ? 0 : this.priFlushTotalTime.hashCode());
            result = result * 31 + (this.getCurrent == null ? 0 : this.getCurrent.hashCode());
            result = result * 31 + (this.priGetCurrent == null ? 0 : this.priGetCurrent.hashCode());
            result = result * 31 + (this.getTime == null ? 0 : this.getTime.hashCode());
            result = result * 31 + (this.priGetTime == null ? 0 : this.priGetTime.hashCode());
            result = result * 31 + (this.getTotal == null ? 0 : this.getTotal.hashCode());
            result = result * 31 + (this.priGetTotal == null ? 0 : this.priGetTotal.hashCode());
            result = result * 31 + (this.getExistsTime == null ? 0 : this.getExistsTime.hashCode());
            result = result * 31 + (this.priGetExistsTime == null ? 0 : this.priGetExistsTime.hashCode());
            result = result * 31 + (this.getExistsTotal == null ? 0 : this.getExistsTotal.hashCode());
            result = result * 31 + (this.priGetExistsTotal == null ? 0 : this.priGetExistsTotal.hashCode());
            result = result * 31 + (this.getMissingTime == null ? 0 : this.getMissingTime.hashCode());
            result = result * 31 + (this.priGetMissingTime == null ? 0 : this.priGetMissingTime.hashCode());
            result = result * 31 + (this.getMissingTotal == null ? 0 : this.getMissingTotal.hashCode());
            result = result * 31 + (this.priGetMissingTotal == null ? 0 : this.priGetMissingTotal.hashCode());
            result = result * 31 + (this.indexingDeleteCurrent == null ? 0 : this.indexingDeleteCurrent.hashCode());
            result = result * 31 + (this.priIndexingDeleteCurrent == null ? 0 : this.priIndexingDeleteCurrent.hashCode());
            result = result * 31 + (this.indexingDeleteTime == null ? 0 : this.indexingDeleteTime.hashCode());
            result = result * 31 + (this.priIndexingDeleteTime == null ? 0 : this.priIndexingDeleteTime.hashCode());
            result = result * 31 + (this.indexingDeleteTotal == null ? 0 : this.indexingDeleteTotal.hashCode());
            result = result * 31 + (this.priIndexingDeleteTotal == null ? 0 : this.priIndexingDeleteTotal.hashCode());
            result = result * 31 + (this.indexingIndexCurrent == null ? 0 : this.indexingIndexCurrent.hashCode());
            result = result * 31 + (this.priIndexingIndexCurrent == null ? 0 : this.priIndexingIndexCurrent.hashCode());
            result = result * 31 + (this.indexingIndexTime == null ? 0 : this.indexingIndexTime.hashCode());
            result = result * 31 + (this.priIndexingIndexTime == null ? 0 : this.priIndexingIndexTime.hashCode());
            result = result * 31 + (this.indexingIndexTotal == null ? 0 : this.indexingIndexTotal.hashCode());
            result = result * 31 + (this.priIndexingIndexTotal == null ? 0 : this.priIndexingIndexTotal.hashCode());
            result = result * 31 + (this.indexingIndexFailed == null ? 0 : this.indexingIndexFailed.hashCode());
            result = result * 31 + (this.priIndexingIndexFailed == null ? 0 : this.priIndexingIndexFailed.hashCode());
            result = result * 31 + (this.mergesCurrent == null ? 0 : this.mergesCurrent.hashCode());
            result = result * 31 + (this.priMergesCurrent == null ? 0 : this.priMergesCurrent.hashCode());
            result = result * 31 + (this.mergesCurrentDocs == null ? 0 : this.mergesCurrentDocs.hashCode());
            result = result * 31 + (this.priMergesCurrentDocs == null ? 0 : this.priMergesCurrentDocs.hashCode());
            result = result * 31 + (this.mergesCurrentSize == null ? 0 : this.mergesCurrentSize.hashCode());
            result = result * 31 + (this.priMergesCurrentSize == null ? 0 : this.priMergesCurrentSize.hashCode());
            result = result * 31 + (this.mergesTotal == null ? 0 : this.mergesTotal.hashCode());
            result = result * 31 + (this.priMergesTotal == null ? 0 : this.priMergesTotal.hashCode());
            result = result * 31 + (this.mergesTotalDocs == null ? 0 : this.mergesTotalDocs.hashCode());
            result = result * 31 + (this.priMergesTotalDocs == null ? 0 : this.priMergesTotalDocs.hashCode());
            result = result * 31 + (this.mergesTotalSize == null ? 0 : this.mergesTotalSize.hashCode());
            result = result * 31 + (this.priMergesTotalSize == null ? 0 : this.priMergesTotalSize.hashCode());
            result = result * 31 + (this.mergesTotalTime == null ? 0 : this.mergesTotalTime.hashCode());
            result = result * 31 + (this.priMergesTotalTime == null ? 0 : this.priMergesTotalTime.hashCode());
            result = result * 31 + (this.refreshTotal == null ? 0 : this.refreshTotal.hashCode());
            result = result * 31 + (this.priRefreshTotal == null ? 0 : this.priRefreshTotal.hashCode());
            result = result * 31 + (this.refreshTime == null ? 0 : this.refreshTime.hashCode());
            result = result * 31 + (this.priRefreshTime == null ? 0 : this.priRefreshTime.hashCode());
            result = result * 31 + (this.refreshExternalTotal == null ? 0 : this.refreshExternalTotal.hashCode());
            result = result * 31 + (this.priRefreshExternalTotal == null ? 0 : this.priRefreshExternalTotal.hashCode());
            result = result * 31 + (this.refreshExternalTime == null ? 0 : this.refreshExternalTime.hashCode());
            result = result * 31 + (this.priRefreshExternalTime == null ? 0 : this.priRefreshExternalTime.hashCode());
            result = result * 31 + (this.refreshListeners == null ? 0 : this.refreshListeners.hashCode());
            result = result * 31 + (this.priRefreshListeners == null ? 0 : this.priRefreshListeners.hashCode());
            result = result * 31 + (this.searchFetchCurrent == null ? 0 : this.searchFetchCurrent.hashCode());
            result = result * 31 + (this.priSearchFetchCurrent == null ? 0 : this.priSearchFetchCurrent.hashCode());
            result = result * 31 + (this.searchFetchTime == null ? 0 : this.searchFetchTime.hashCode());
            result = result * 31 + (this.priSearchFetchTime == null ? 0 : this.priSearchFetchTime.hashCode());
            result = result * 31 + (this.searchFetchTotal == null ? 0 : this.searchFetchTotal.hashCode());
            result = result * 31 + (this.priSearchFetchTotal == null ? 0 : this.priSearchFetchTotal.hashCode());
            result = result * 31 + (this.searchOpenContexts == null ? 0 : this.searchOpenContexts.hashCode());
            result = result * 31 + (this.priSearchOpenContexts == null ? 0 : this.priSearchOpenContexts.hashCode());
            result = result * 31 + (this.searchQueryCurrent == null ? 0 : this.searchQueryCurrent.hashCode());
            result = result * 31 + (this.priSearchQueryCurrent == null ? 0 : this.priSearchQueryCurrent.hashCode());
            result = result * 31 + (this.searchQueryTime == null ? 0 : this.searchQueryTime.hashCode());
            result = result * 31 + (this.priSearchQueryTime == null ? 0 : this.priSearchQueryTime.hashCode());
            result = result * 31 + (this.searchQueryTotal == null ? 0 : this.searchQueryTotal.hashCode());
            result = result * 31 + (this.priSearchQueryTotal == null ? 0 : this.priSearchQueryTotal.hashCode());
            result = result * 31 + (this.searchScrollCurrent == null ? 0 : this.searchScrollCurrent.hashCode());
            result = result * 31 + (this.priSearchScrollCurrent == null ? 0 : this.priSearchScrollCurrent.hashCode());
            result = result * 31 + (this.searchScrollTime == null ? 0 : this.searchScrollTime.hashCode());
            result = result * 31 + (this.priSearchScrollTime == null ? 0 : this.priSearchScrollTime.hashCode());
            result = result * 31 + (this.searchScrollTotal == null ? 0 : this.searchScrollTotal.hashCode());
            result = result * 31 + (this.priSearchScrollTotal == null ? 0 : this.priSearchScrollTotal.hashCode());
            result = result * 31 + (this.searchPointInTimeCurrent == null ? 0 : this.searchPointInTimeCurrent.hashCode());
            result = result * 31 + (this.priSearchPointInTimeCurrent == null ? 0 : this.priSearchPointInTimeCurrent.hashCode());
            result = result * 31 + (this.searchPointInTimeTime == null ? 0 : this.searchPointInTimeTime.hashCode());
            result = result * 31 + (this.priSearchPointInTimeTime == null ? 0 : this.priSearchPointInTimeTime.hashCode());
            result = result * 31 + (this.searchPointInTimeTotal == null ? 0 : this.searchPointInTimeTotal.hashCode());
            result = result * 31 + (this.priSearchPointInTimeTotal == null ? 0 : this.priSearchPointInTimeTotal.hashCode());
            result = result * 31 + (this.segmentsCount == null ? 0 : this.segmentsCount.hashCode());
            result = result * 31 + (this.priSegmentsCount == null ? 0 : this.priSegmentsCount.hashCode());
            result = result * 31 + (this.segmentsMemory == null ? 0 : this.segmentsMemory.hashCode());
            result = result * 31 + (this.priSegmentsMemory == null ? 0 : this.priSegmentsMemory.hashCode());
            result = result * 31 + (this.segmentsIndexWriterMemory == null ? 0 : this.segmentsIndexWriterMemory.hashCode());
            result = result * 31 + (this.priSegmentsIndexWriterMemory == null ? 0 : this.priSegmentsIndexWriterMemory.hashCode());
            result = result * 31 + (this.segmentsVersionMapMemory == null ? 0 : this.segmentsVersionMapMemory.hashCode());
            result = result * 31 + (this.priSegmentsVersionMapMemory == null ? 0 : this.priSegmentsVersionMapMemory.hashCode());
            result = result * 31 + (this.segmentsFixedBitsetMemory == null ? 0 : this.segmentsFixedBitsetMemory.hashCode());
            result = result * 31 + (this.priSegmentsFixedBitsetMemory == null ? 0 : this.priSegmentsFixedBitsetMemory.hashCode());
            result = result * 31 + (this.warmerCurrent == null ? 0 : this.warmerCurrent.hashCode());
            result = result * 31 + (this.priWarmerCurrent == null ? 0 : this.priWarmerCurrent.hashCode());
            result = result * 31 + (this.warmerTotal == null ? 0 : this.warmerTotal.hashCode());
            result = result * 31 + (this.priWarmerTotal == null ? 0 : this.priWarmerTotal.hashCode());
            result = result * 31 + (this.warmerTotalTime == null ? 0 : this.warmerTotalTime.hashCode());
            result = result * 31 + (this.priWarmerTotalTime == null ? 0 : this.priWarmerTotalTime.hashCode());
            result = result * 31 + (this.suggestCurrent == null ? 0 : this.suggestCurrent.hashCode());
            result = result * 31 + (this.priSuggestCurrent == null ? 0 : this.priSuggestCurrent.hashCode());
            result = result * 31 + (this.suggestTime == null ? 0 : this.suggestTime.hashCode());
            result = result * 31 + (this.priSuggestTime == null ? 0 : this.priSuggestTime.hashCode());
            result = result * 31 + (this.suggestTotal == null ? 0 : this.suggestTotal.hashCode());
            result = result * 31 + (this.priSuggestTotal == null ? 0 : this.priSuggestTotal.hashCode());
            result = result * 31 + (this.memoryTotal == null ? 0 : this.memoryTotal.hashCode());
            result = result * 31 + (this.priMemoryTotal == null ? 0 : this.priMemoryTotal.hashCode());
            result = result * 31 + (this.searchThrottled == null ? 0 : this.searchThrottled.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexInfo)) {
                return false;
            }
            IndexInfo indexInfo = (IndexInfo)other;
            if (!Intrinsics.areEqual((Object)this.health, (Object)indexInfo.health)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.status, (Object)indexInfo.status)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.index, (Object)indexInfo.index)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)indexInfo.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pri, (Object)indexInfo.pri)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rep, (Object)indexInfo.rep)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docsCount, (Object)indexInfo.docsCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docsDeleted, (Object)indexInfo.docsDeleted)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creationDate, (Object)indexInfo.creationDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creationDateString, (Object)indexInfo.creationDateString)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.storeSize, (Object)indexInfo.storeSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priStoreSize, (Object)indexInfo.priStoreSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.completionSize, (Object)indexInfo.completionSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priCompletionSize, (Object)indexInfo.priCompletionSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldDataMemorySize, (Object)indexInfo.fieldDataMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priFieldDataMemorySize, (Object)indexInfo.priFieldDataMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldDataEvictions, (Object)indexInfo.fieldDataEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priFieldDataEvictions, (Object)indexInfo.priFieldDataEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryCacheMemorySize, (Object)indexInfo.queryCacheMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priQueryCacheMemorySize, (Object)indexInfo.priQueryCacheMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryCacheEvictions, (Object)indexInfo.queryCacheEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priQueryCacheEvictions, (Object)indexInfo.priQueryCacheEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestCacheMemorySize, (Object)indexInfo.requestCacheMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRequestCacheMemorySize, (Object)indexInfo.priRequestCacheMemorySize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestCacheEvictions, (Object)indexInfo.requestCacheEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRequestCacheEvictions, (Object)indexInfo.priRequestCacheEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestCacheHitCount, (Object)indexInfo.requestCacheHitCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRequestCacheHitCount, (Object)indexInfo.priRequestCacheHitCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestCacheMissCount, (Object)indexInfo.requestCacheMissCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRequestCacheMissCount, (Object)indexInfo.priRequestCacheMissCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flushTotal, (Object)indexInfo.flushTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priFlushTotal, (Object)indexInfo.priFlushTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flushTotalTime, (Object)indexInfo.flushTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priFlushTotalTime, (Object)indexInfo.priFlushTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getCurrent, (Object)indexInfo.getCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetCurrent, (Object)indexInfo.priGetCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getTime, (Object)indexInfo.getTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetTime, (Object)indexInfo.priGetTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getTotal, (Object)indexInfo.getTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetTotal, (Object)indexInfo.priGetTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getExistsTime, (Object)indexInfo.getExistsTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetExistsTime, (Object)indexInfo.priGetExistsTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getExistsTotal, (Object)indexInfo.getExistsTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetExistsTotal, (Object)indexInfo.priGetExistsTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getMissingTime, (Object)indexInfo.getMissingTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetMissingTime, (Object)indexInfo.priGetMissingTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getMissingTotal, (Object)indexInfo.getMissingTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priGetMissingTotal, (Object)indexInfo.priGetMissingTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteCurrent, (Object)indexInfo.indexingDeleteCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingDeleteCurrent, (Object)indexInfo.priIndexingDeleteCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteTime, (Object)indexInfo.indexingDeleteTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingDeleteTime, (Object)indexInfo.priIndexingDeleteTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteTotal, (Object)indexInfo.indexingDeleteTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingDeleteTotal, (Object)indexInfo.priIndexingDeleteTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexCurrent, (Object)indexInfo.indexingIndexCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingIndexCurrent, (Object)indexInfo.priIndexingIndexCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexTime, (Object)indexInfo.indexingIndexTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingIndexTime, (Object)indexInfo.priIndexingIndexTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexTotal, (Object)indexInfo.indexingIndexTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingIndexTotal, (Object)indexInfo.priIndexingIndexTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexFailed, (Object)indexInfo.indexingIndexFailed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priIndexingIndexFailed, (Object)indexInfo.priIndexingIndexFailed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrent, (Object)indexInfo.mergesCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesCurrent, (Object)indexInfo.priMergesCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrentDocs, (Object)indexInfo.mergesCurrentDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesCurrentDocs, (Object)indexInfo.priMergesCurrentDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrentSize, (Object)indexInfo.mergesCurrentSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesCurrentSize, (Object)indexInfo.priMergesCurrentSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotal, (Object)indexInfo.mergesTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesTotal, (Object)indexInfo.priMergesTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalDocs, (Object)indexInfo.mergesTotalDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesTotalDocs, (Object)indexInfo.priMergesTotalDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalSize, (Object)indexInfo.mergesTotalSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesTotalSize, (Object)indexInfo.priMergesTotalSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalTime, (Object)indexInfo.mergesTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMergesTotalTime, (Object)indexInfo.priMergesTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshTotal, (Object)indexInfo.refreshTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRefreshTotal, (Object)indexInfo.priRefreshTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshTime, (Object)indexInfo.refreshTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRefreshTime, (Object)indexInfo.priRefreshTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshExternalTotal, (Object)indexInfo.refreshExternalTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRefreshExternalTotal, (Object)indexInfo.priRefreshExternalTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshExternalTime, (Object)indexInfo.refreshExternalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRefreshExternalTime, (Object)indexInfo.priRefreshExternalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshListeners, (Object)indexInfo.refreshListeners)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priRefreshListeners, (Object)indexInfo.priRefreshListeners)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchCurrent, (Object)indexInfo.searchFetchCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchFetchCurrent, (Object)indexInfo.priSearchFetchCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchTime, (Object)indexInfo.searchFetchTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchFetchTime, (Object)indexInfo.priSearchFetchTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchTotal, (Object)indexInfo.searchFetchTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchFetchTotal, (Object)indexInfo.priSearchFetchTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchOpenContexts, (Object)indexInfo.searchOpenContexts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchOpenContexts, (Object)indexInfo.priSearchOpenContexts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryCurrent, (Object)indexInfo.searchQueryCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchQueryCurrent, (Object)indexInfo.priSearchQueryCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryTime, (Object)indexInfo.searchQueryTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchQueryTime, (Object)indexInfo.priSearchQueryTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryTotal, (Object)indexInfo.searchQueryTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchQueryTotal, (Object)indexInfo.priSearchQueryTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollCurrent, (Object)indexInfo.searchScrollCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchScrollCurrent, (Object)indexInfo.priSearchScrollCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollTime, (Object)indexInfo.searchScrollTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchScrollTime, (Object)indexInfo.priSearchScrollTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollTotal, (Object)indexInfo.searchScrollTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchScrollTotal, (Object)indexInfo.priSearchScrollTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchPointInTimeCurrent, (Object)indexInfo.searchPointInTimeCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchPointInTimeCurrent, (Object)indexInfo.priSearchPointInTimeCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchPointInTimeTime, (Object)indexInfo.searchPointInTimeTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchPointInTimeTime, (Object)indexInfo.priSearchPointInTimeTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchPointInTimeTotal, (Object)indexInfo.searchPointInTimeTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSearchPointInTimeTotal, (Object)indexInfo.priSearchPointInTimeTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsCount, (Object)indexInfo.segmentsCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSegmentsCount, (Object)indexInfo.priSegmentsCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsMemory, (Object)indexInfo.segmentsMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSegmentsMemory, (Object)indexInfo.priSegmentsMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsIndexWriterMemory, (Object)indexInfo.segmentsIndexWriterMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSegmentsIndexWriterMemory, (Object)indexInfo.priSegmentsIndexWriterMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsVersionMapMemory, (Object)indexInfo.segmentsVersionMapMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSegmentsVersionMapMemory, (Object)indexInfo.priSegmentsVersionMapMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsFixedBitsetMemory, (Object)indexInfo.segmentsFixedBitsetMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSegmentsFixedBitsetMemory, (Object)indexInfo.priSegmentsFixedBitsetMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.warmerCurrent, (Object)indexInfo.warmerCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priWarmerCurrent, (Object)indexInfo.priWarmerCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.warmerTotal, (Object)indexInfo.warmerTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priWarmerTotal, (Object)indexInfo.priWarmerTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.warmerTotalTime, (Object)indexInfo.warmerTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priWarmerTotalTime, (Object)indexInfo.priWarmerTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestCurrent, (Object)indexInfo.suggestCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSuggestCurrent, (Object)indexInfo.priSuggestCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestTime, (Object)indexInfo.suggestTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSuggestTime, (Object)indexInfo.priSuggestTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestTotal, (Object)indexInfo.suggestTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priSuggestTotal, (Object)indexInfo.priSuggestTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.memoryTotal, (Object)indexInfo.memoryTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.priMemoryTotal, (Object)indexInfo.priMemoryTotal)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.searchThrottled, (Object)indexInfo.searchThrottled);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0003\b\u0089\u0001\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010i\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010j\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010k\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010w\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010x\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010y\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010z\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010{\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010|\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010}\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u007f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0081\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0082\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0083\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0084\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0085\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0086\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0087\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0088\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0089\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008a\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008b\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008c\u0001\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008d\u0001"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatIndicesResponseWrapper$IndexInfo$Companion;", "", "()V", "COMPLETION_SIZE_FIELD", "", "CREATION_DATE_FIELD", "CREATION_DATE_STRING_FIELD", "DOCS_COUNT_FIELD", "DOCS_DELETED_FIELD", "FIELD_DATA_EVICTIONS_FIELD", "FIELD_DATA_MEMORY_SIZE_FIELD", "FLUSH_TOTAL_FIELD", "FLUSH_TOTAL_TIME_FIELD", "GET_CURRENT_FIELD", "GET_EXISTS_TIME_FIELD", "GET_EXISTS_TOTAL_FIELD", "GET_MISSING_TIME_FIELD", "GET_MISSING_TOTAL_FIELD", "GET_TIME_FIELD", "GET_TOTAL_FIELD", "HEALTH_FIELD", "INDEXING_DELETE_CURRENT_FIELD", "INDEXING_DELETE_TIME_FIELD", "INDEXING_DELETE_TOTAL_FIELD", "INDEXING_INDEX_CURRENT_FIELD", "INDEXING_INDEX_FAILED_FIELD", "INDEXING_INDEX_TIME_FIELD", "INDEXING_INDEX_TOTAL_FIELD", "INDEX_FIELD", "MEMORY_TOTAL_FIELD", "MERGES_CURRENT_DOCS_FIELD", "MERGES_CURRENT_FIELD", "MERGES_CURRENT_SIZE_FIELD", "MERGES_TOTAL_DOCS_FIELD", "MERGES_TOTAL_FIELD", "MERGES_TOTAL_SIZE_FIELD", "MERGES_TOTAL_TIME_FIELD", "PRI_COMPLETION_SIZE_FIELD", "PRI_FIELD", "PRI_FIELD_DATA_EVICTIONS_FIELD", "PRI_FIELD_DATA_MEMORY_SIZE_FIELD", "PRI_FLUSH_TOTAL_FIELD", "PRI_FLUSH_TOTAL_TIME_FIELD", "PRI_GET_CURRENT_FIELD", "PRI_GET_EXISTS_TIME_FIELD", "PRI_GET_EXISTS_TOTAL_FIELD", "PRI_GET_MISSING_TIME_FIELD", "PRI_GET_MISSING_TOTAL_FIELD", "PRI_GET_TIME_FIELD", "PRI_GET_TOTAL_FIELD", "PRI_INDEXING_DELETE_CURRENT_FIELD", "PRI_INDEXING_DELETE_TIME_FIELD", "PRI_INDEXING_DELETE_TOTAL_FIELD", "PRI_INDEXING_INDEX_CURRENT_FIELD", "PRI_INDEXING_INDEX_FAILED_FIELD", "PRI_INDEXING_INDEX_TIME_FIELD", "PRI_INDEXING_INDEX_TOTAL_FIELD", "PRI_MEMORY_TOTAL_FIELD", "PRI_MERGES_CURRENT_DOCS_FIELD", "PRI_MERGES_CURRENT_FIELD", "PRI_MERGES_CURRENT_SIZE_FIELD", "PRI_MERGES_TOTAL_DOCS_FIELD", "PRI_MERGES_TOTAL_FIELD", "PRI_MERGES_TOTAL_SIZE_FIELD", "PRI_MERGES_TOTAL_TIME_FIELD", "PRI_QUERY_CACHE_EVICTIONS_FIELD", "PRI_QUERY_CACHE_MEMORY_SIZE_FIELD", "PRI_REFRESH_EXTERNAL_TIME_FIELD", "PRI_REFRESH_EXTERNAL_TOTAL_FIELD", "PRI_REFRESH_LISTENERS_FIELD", "PRI_REFRESH_TIME_FIELD", "PRI_REFRESH_TOTAL_FIELD", "PRI_REQUEST_CACHE_EVICTIONS_FIELD", "PRI_REQUEST_CACHE_HIT_COUNT_FIELD", "PRI_REQUEST_CACHE_MEMORY_SIZE_FIELD", "PRI_REQUEST_CACHE_MISS_COUNT_FIELD", "PRI_SEARCH_FETCH_CURRENT_FIELD", "PRI_SEARCH_FETCH_TIME_FIELD", "PRI_SEARCH_FETCH_TOTAL_FIELD", "PRI_SEARCH_OPEN_CONTEXTS_FIELD", "PRI_SEARCH_POINT_IN_TIME_CURRENT_FIELD", "PRI_SEARCH_POINT_IN_TIME_TIME_FIELD", "PRI_SEARCH_POINT_IN_TIME_TOTAL_FIELD", "PRI_SEARCH_QUERY_CURRENT_FIELD", "PRI_SEARCH_QUERY_TIME_FIELD", "PRI_SEARCH_QUERY_TOTAL_FIELD", "PRI_SEARCH_SCROLL_CURRENT_FIELD", "PRI_SEARCH_SCROLL_TIME_FIELD", "PRI_SEARCH_SCROLL_TOTAL_FIELD", "PRI_SEGMENTS_COUNT_FIELD", "PRI_SEGMENTS_FIXED_BITSET_MEMORY_FIELD", "PRI_SEGMENTS_INDEX_WRITER_MEMORY_FIELD", "PRI_SEGMENTS_MEMORY_FIELD", "PRI_SEGMENTS_VERSION_MAP_MEMORY_FIELD", "PRI_STORE_SIZE_FIELD", "PRI_SUGGEST_CURRENT_FIELD", "PRI_SUGGEST_TIME_FIELD", "PRI_SUGGEST_TOTAL_FIELD", "PRI_WARMER_CURRENT_FIELD", "PRI_WARMER_TOTAL_FIELD", "PRI_WARMER_TOTAL_TIME_FIELD", "QUERY_CACHE_EVICTIONS_FIELD", "QUERY_CACHE_MEMORY_SIZE_FIELD", "REFRESH_EXTERNAL_TIME_FIELD", "REFRESH_EXTERNAL_TOTAL_FIELD", "REFRESH_LISTENERS_FIELD", "REFRESH_TIME_FIELD", "REFRESH_TOTAL_FIELD", "REP_FIELD", "REQUEST_CACHE_EVICTIONS_FIELD", "REQUEST_CACHE_HIT_COUNT_FIELD", "REQUEST_CACHE_MEMORY_SIZE_FIELD", "REQUEST_CACHE_MISS_COUNT_FIELD", "SEARCH_FETCH_CURRENT_FIELD", "SEARCH_FETCH_TIME_FIELD", "SEARCH_FETCH_TOTAL_FIELD", "SEARCH_OPEN_CONTEXTS_FIELD", "SEARCH_POINT_IN_TIME_CURRENT_FIELD", "SEARCH_POINT_IN_TIME_TIME_FIELD", "SEARCH_POINT_IN_TIME_TOTAL_FIELD", "SEARCH_QUERY_CURRENT_FIELD", "SEARCH_QUERY_TIME_FIELD", "SEARCH_QUERY_TOTAL_FIELD", "SEARCH_SCROLL_CURRENT_FIELD", "SEARCH_SCROLL_TIME_FIELD", "SEARCH_SCROLL_TOTAL_FIELD", "SEARCH_THROTTLED_FIELD", "SEGMENTS_COUNT_FIELD", "SEGMENTS_FIXED_BITSET_MEMORY_FIELD", "SEGMENTS_INDEX_WRITER_MEMORY_FIELD", "SEGMENTS_MEMORY_FIELD", "SEGMENTS_VERSION_MAP_MEMORY_FIELD", "STATUS_FIELD", "STORE_SIZE_FIELD", "SUGGEST_CURRENT_FIELD", "SUGGEST_TIME_FIELD", "SUGGEST_TOTAL_FIELD", "UUID_FIELD", "WARMER_CURRENT_FIELD", "WARMER_TOTAL_FIELD", "WARMER_TOTAL_TIME_FIELD", "opensearch-alerting"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

