/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PrivateKey;
import org.bouncycastle.jcajce.provider.DSTU4145Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.DSTU4145PrivateKeySpec;

class ProvDSTU4145PrivateKey
implements Destroyable,
DSTU4145PrivateKey,
ProvKey<AsymmetricDSTU4145PrivateKey> {
    private static final long serialVersionUID = 7245981689601667138L;
    private transient AsymmetricDSTU4145PrivateKey baseKey;

    ProvDSTU4145PrivateKey(Algorithm algorithm, DSTU4145PrivateKey dSTU4145PrivateKey) {
        DSTU4145ParameterSpec dSTU4145ParameterSpec = dSTU4145PrivateKey.getParams();
        this.baseKey = new AsymmetricDSTU4145PrivateKey(algorithm, DSTU4145Util.convertToECParams(dSTU4145ParameterSpec), dSTU4145PrivateKey.getS());
    }

    ProvDSTU4145PrivateKey(Algorithm algorithm, DSTU4145PrivateKeySpec dSTU4145PrivateKeySpec) {
        this.baseKey = new AsymmetricDSTU4145PrivateKey(algorithm, DSTU4145Util.convertToECParams(dSTU4145PrivateKeySpec.getParams()), dSTU4145PrivateKeySpec.getS());
    }

    ProvDSTU4145PrivateKey(AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey) {
        this.baseKey = asymmetricDSTU4145PrivateKey;
    }

    @Override
    public AsymmetricDSTU4145PrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public DSTU4145ParameterSpec getParams() {
        return DSTU4145Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDSTU4145PrivateKey)) {
            return false;
        }
        ProvDSTU4145PrivateKey provDSTU4145PrivateKey = (ProvDSTU4145PrivateKey)object;
        return this.baseKey.equals(provDSTU4145PrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DSTU4145");
        }
        try {
            return KeyUtil.privateKeyToString("DSTU4145", this.baseKey.getS(), this.baseKey.getParameters().getDomainParameters());
        }
        catch (Exception exception) {
            return KeyUtil.restrictedToString("DSTU4145");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSTU4145PrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

