/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.slice;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.slice.DocValuesSliceQuery;
import org.opensearch.search.slice.TermsSliceQuery;

@PublicApi(since="1.0.0")
public class SliceBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ObjectParser<SliceBuilder, Void> PARSER = new ObjectParser("slice", SliceBuilder::new);
    private String field = "_id";
    private int id = -1;
    private int max = -1;

    private SliceBuilder() {
    }

    public SliceBuilder(int id, int max) {
        this("_id", id, max);
    }

    public SliceBuilder(String field, int id, int max) {
        this.setField(field);
        this.setId(id);
        this.setMax(max);
    }

    public SliceBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.id = in.readVInt();
        this.max = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeVInt(this.id);
        out.writeVInt(this.max);
    }

    private SliceBuilder setField(String field) {
        if (Strings.isEmpty((CharSequence)field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    private SliceBuilder setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be greater than or equal to 0");
        }
        if (this.max != -1 && id >= this.max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    private SliceBuilder setMax(int max) {
        if (max <= 1) {
            throw new IllegalArgumentException("max must be greater than 1");
        }
        if (this.id != -1 && this.id >= max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(MAX_FIELD.getPreferredName(), this.max);
    }

    public static SliceBuilder fromXContent(XContentParser parser) throws IOException {
        SliceBuilder builder = (SliceBuilder)PARSER.parse(parser, (Object)new SliceBuilder(), null);
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SliceBuilder)) {
            return false;
        }
        SliceBuilder o = (SliceBuilder)other;
        return (this.field == null && o.field == null || this.field.equals(o.field)) && this.id == o.id && o.max == this.max;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.id, this.max);
    }

    public boolean shardMatches(int shardOrdinal, int numShards) {
        if (this.max >= numShards) {
            return this.id % numShards == shardOrdinal;
        }
        return shardOrdinal % this.max == this.id;
    }

    public Query toFilter(ClusterService clusterService, ShardSearchRequest request, QueryShardContext context, Version minNodeVersion) {
        MappedFieldType type = context.fieldMapper(this.field);
        if (type == null) {
            throw new IllegalArgumentException("field " + this.field + " not found");
        }
        int shardOrdinal = request.shardId().id();
        int numShards = context.getIndexSettings().getNumberOfShards();
        if (request.preference() != null || request.indexRoutings().length > 0) {
            GroupShardsIterator<ShardIterator> group = this.buildShardIterator(clusterService, request);
            assert (group.size() <= numShards) : "index routing shards: " + group.size() + " cannot be greater than total number of shards: " + numShards;
            if (group.size() < numShards) {
                numShards = group.size();
                int ord = 0;
                shardOrdinal = -1;
                for (ShardIterator it : group) {
                    assert (it.shardId().getIndex().equals((Object)request.shardId().getIndex()));
                    if (request.shardId().equals((Object)it.shardId())) {
                        shardOrdinal = ord;
                        break;
                    }
                    ++ord;
                }
                assert (shardOrdinal != -1) : "shard id: " + request.shardId().getId() + " not found in index shard routing";
            }
        }
        if (!this.shardMatches(shardOrdinal, numShards)) {
            return new MatchNoDocsQuery("this shard is not part of the slice");
        }
        boolean useTermQuery = false;
        if ("_uid".equals(this.field)) {
            throw new IllegalArgumentException("Computing slices on the [_uid] field is illegal for 7.x indices, use [_id] instead");
        }
        if ("_id".equals(this.field)) {
            useTermQuery = true;
        } else {
            if (!type.hasDocValues()) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + this.field);
            }
            Object ifm = context.getForField(type);
            if (!(ifm instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + this.field);
            }
        }
        if (numShards == 1) {
            return useTermQuery ? new TermsSliceQuery(this.field, this.id, this.max) : new DocValuesSliceQuery(this.field, this.id, this.max);
        }
        if (this.max >= numShards) {
            int targetShard = this.id % numShards;
            int numSlicesInShard = this.max / numShards;
            int rest = this.max % numShards;
            if (rest > targetShard) {
                ++numSlicesInShard;
            }
            if (numSlicesInShard == 1) {
                return new MatchAllDocsQuery();
            }
            int shardSlice = this.id / numShards;
            return useTermQuery ? new TermsSliceQuery(this.field, shardSlice, numSlicesInShard) : new DocValuesSliceQuery(this.field, shardSlice, numSlicesInShard);
        }
        return new MatchAllDocsQuery();
    }

    private GroupShardsIterator<ShardIterator> buildShardIterator(ClusterService clusterService, ShardSearchRequest request) {
        ClusterState state = clusterService.state();
        String[] indices = new String[]{request.shardId().getIndex().getName()};
        Map<String, Set<String>> routingMap = request.indexRoutings().length > 0 ? Collections.singletonMap(indices[0], Sets.newHashSet((Object[])request.indexRoutings())) : null;
        return clusterService.operationRouting().searchShards(state, indices, routingMap, request.preference());
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareString(SliceBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(SliceBuilder::setId, ID_FIELD);
        PARSER.declareInt(SliceBuilder::setMax, MAX_FIELD);
    }
}

