/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.RangeQueryBuilder;

public class ComplementHelperUtils {
    public static NumberFieldMapper.NumberFieldType getNumberFieldType(QueryShardContext context, String fieldName) {
        if (context == null) {
            return null;
        }
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (!(fieldType instanceof NumberFieldMapper.NumberFieldType)) {
            return null;
        }
        NumberFieldMapper.NumberFieldType nft = (NumberFieldMapper.NumberFieldType)fieldType;
        return nft;
    }

    public static List<QueryBuilder> numberValueToComplement(String fieldName, Number value) {
        ArrayList<QueryBuilder> complement = new ArrayList<QueryBuilder>();
        RangeQueryBuilder belowRange = new RangeQueryBuilder(fieldName);
        belowRange.to(value);
        belowRange.includeUpper(false);
        complement.add(belowRange);
        RangeQueryBuilder aboveRange = new RangeQueryBuilder(fieldName);
        aboveRange.from(value);
        aboveRange.includeLower(false);
        complement.add(aboveRange);
        return complement;
    }

    public static List<QueryBuilder> numberValuesToComplement(String fieldName, List<Number> sortedValues, boolean isWholeNumber) {
        if (sortedValues.isEmpty()) {
            return null;
        }
        ArrayList<QueryBuilder> complement = new ArrayList<QueryBuilder>();
        Number lastValue = null;
        for (Number value : sortedValues) {
            RangeQueryBuilder range = new RangeQueryBuilder(fieldName);
            range.includeUpper(false);
            range.to(value);
            if (lastValue != null) {
                if (isWholeNumber && value.longValue() - lastValue.longValue() == 1L) continue;
                range.includeLower(false);
                range.from(lastValue);
            }
            complement.add(range);
            lastValue = value;
        }
        RangeQueryBuilder lastRange = new RangeQueryBuilder(fieldName);
        lastRange.from(sortedValues.get(sortedValues.size() - 1));
        lastRange.includeLower(false);
        lastRange.includeUpper(true);
        complement.add(lastRange);
        return complement;
    }
}

