/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;

public class SearchReplicaAllocationDecider
extends AllocationDecider {
    public static final String NAME = "search_replica_allocation";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node.node(), allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node.node(), allocation);
    }

    private Decision canAllocate(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        boolean isSearchReplica = shardRouting.isSearchOnly();
        if (node.isSearchNode() && isSearchReplica || !node.isSearchNode() && !isSearchReplica) {
            return allocation.decision(Decision.YES, NAME, "node and shard are compatible. node: [%s], is search node: [%s], shard: [%s]", node.getId(), node.isSearchNode(), shardRouting.shortSummary());
        }
        return allocation.decision(Decision.NO, NAME, "node and shard are not compatible. node: [%s], is search node: [%s], shard: [%s]", node.getId(), node.isSearchNode(), shardRouting.shortSummary());
    }
}

