/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.applicationtemplates;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.applicationtemplates.SystemTemplate;
import org.opensearch.cluster.applicationtemplates.SystemTemplateMetadata;
import org.opensearch.cluster.applicationtemplates.SystemTemplateRepository;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesPlugin;
import org.opensearch.cluster.applicationtemplates.TemplateRepositoryMetadata;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.threadpool.ThreadPool;

@ExperimentalApi
public class SystemTemplatesService
implements LocalNodeClusterManagerListener {
    public static final Setting<Boolean> SETTING_APPLICATION_BASED_CONFIGURATION_TEMPLATES_ENABLED = Setting.boolSetting("cluster.application_templates.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final List<SystemTemplatesPlugin> systemTemplatesPluginList;
    private final ThreadPool threadPool;
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private volatile boolean enabledTemplates;
    private volatile Stats latestStats;
    private static final Logger logger = LogManager.getLogger(SystemTemplatesService.class);

    public SystemTemplatesService(List<SystemTemplatesPlugin> systemTemplatesPluginList, ThreadPool threadPool, ClusterSettings clusterSettings, Settings settings) {
        this.systemTemplatesPluginList = systemTemplatesPluginList;
        this.threadPool = threadPool;
        if (settings.getAsBoolean(SETTING_APPLICATION_BASED_CONFIGURATION_TEMPLATES_ENABLED.getKey(), false).booleanValue()) {
            this.setEnabledTemplates(settings.getAsBoolean(SETTING_APPLICATION_BASED_CONFIGURATION_TEMPLATES_ENABLED.getKey(), false));
        }
        clusterSettings.addSettingsUpdateConsumer(SETTING_APPLICATION_BASED_CONFIGURATION_TEMPLATES_ENABLED, this::setEnabledTemplates);
    }

    @Override
    public void onClusterManager() {
        this.threadPool.generic().execute(() -> this.refreshTemplates(false));
    }

    @Override
    public void offClusterManager() {
    }

    public void verifyRepositories() {
        this.refreshTemplates(true);
    }

    public Stats stats() {
        return this.latestStats;
    }

    void refreshTemplates(boolean verification) {
        int templatesLoaded = 0;
        int failedLoadingTemplates = 0;
        int failedLoadingRepositories = 0;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if ((verification || this.loaded.compareAndSet(false, true)) && this.enabledTemplates) {
            for (SystemTemplatesPlugin plugin : this.systemTemplatesPluginList) {
                try {
                    SystemTemplateRepository repository = plugin.loadRepository();
                    try {
                        TemplateRepositoryMetadata repositoryMetadata = repository.metadata();
                        logger.debug("Loading templates from repository: {} at version {}", (Object)repositoryMetadata.id(), (Object)repositoryMetadata.version());
                        for (SystemTemplateMetadata templateMetadata : repository.listTemplates()) {
                            try {
                                SystemTemplate template = repository.getTemplate(templateMetadata);
                                if (verification || !plugin.loaderFor(templateMetadata).loadTemplate(template)) continue;
                                ++templatesLoaded;
                            }
                            catch (Exception ex) {
                                exceptions.add(ex);
                                logger.error((Message)new ParameterizedMessage("Failed loading template  {} from repository: {}", (Object)templateMetadata.fullyQualifiedName(), (Object)repositoryMetadata.id()), (Throwable)ex);
                                ++failedLoadingTemplates;
                            }
                        }
                    }
                    finally {
                        if (repository == null) continue;
                        repository.close();
                    }
                }
                catch (Exception ex) {
                    exceptions.add(ex);
                    ++failedLoadingRepositories;
                    logger.error((Message)new ParameterizedMessage("Failed loading repository from plugin: {}", (Object)plugin.getClass().getName()), (Throwable)ex);
                }
            }
            logger.debug("Stats: Total Loaded Templates: [{}], Failed Loading Templates: [{}], Failed Loading Repositories: [{}]", (Object)templatesLoaded, (Object)failedLoadingTemplates, (Object)failedLoadingRepositories);
            if (verification && (failedLoadingRepositories > 0 || failedLoadingTemplates > 0)) {
                this.latestStats = new Stats(templatesLoaded, failedLoadingTemplates, failedLoadingRepositories);
                throw new IllegalStateException("Some of the repositories could not be loaded or are corrupted: " + String.valueOf(exceptions));
            }
        }
        this.latestStats = new Stats(templatesLoaded, failedLoadingTemplates, failedLoadingRepositories);
    }

    private void setEnabledTemplates(boolean enabled) {
        if (!FeatureFlags.isEnabled(FeatureFlags.APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING)) {
            throw new IllegalArgumentException("Application Based Configuration Templates is under an experimental feature and can be activated only by enabling " + FeatureFlags.APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING.getKey() + " feature flag.");
        }
        this.enabledTemplates = enabled;
    }

    @ExperimentalApi
    public static class Stats {
        private final long templatesLoaded;
        private final long failedLoadingTemplates;
        private final long failedLoadingRepositories;

        public Stats(long templatesLoaded, long failedLoadingTemplates, long failedLoadingRepositories) {
            this.templatesLoaded = templatesLoaded;
            this.failedLoadingTemplates = failedLoadingTemplates;
            this.failedLoadingRepositories = failedLoadingRepositories;
        }

        public long getTemplatesLoaded() {
            return this.templatesLoaded;
        }

        public long getFailedLoadingTemplates() {
            return this.failedLoadingTemplates;
        }

        public long getFailedLoadingRepositories() {
            return this.failedLoadingRepositories;
        }
    }
}

