/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.core.action.ShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class SearchPhaseExecutionException
extends OpenSearchException {
    private final String phaseName;
    private final ShardSearchFailure[] shardFailures;

    public SearchPhaseExecutionException(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        this(phaseName, msg, null, shardFailures);
    }

    public SearchPhaseExecutionException(String phaseName, String msg, Throwable cause, ShardSearchFailure[] shardFailures) {
        super(msg, SearchPhaseExecutionException.deduplicateCause(cause, shardFailures), new Object[0]);
        this.phaseName = phaseName;
        this.shardFailures = shardFailures;
    }

    public SearchPhaseExecutionException(StreamInput in) throws IOException {
        super(in);
        this.phaseName = in.readOptionalString();
        this.shardFailures = (ShardSearchFailure[])in.readArray(ShardSearchFailure::readShardSearchFailure, ShardSearchFailure[]::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.phaseName);
        out.writeArray((Writeable[])this.shardFailures);
    }

    private static Throwable deduplicateCause(Throwable cause, ShardSearchFailure[] shardFailures) {
        if (shardFailures == null) {
            throw new IllegalArgumentException("shardSearchFailures must not be null");
        }
        if (cause != null) {
            for (ShardSearchFailure failure : shardFailures) {
                if (failure.getCause() != cause) continue;
                return null;
            }
        }
        return cause;
    }

    public RestStatus status() {
        if (this.shardFailures.length == 0) {
            return this.getCause() == null ? RestStatus.SERVICE_UNAVAILABLE : ExceptionsHelper.status((Throwable)this.getCause());
        }
        RestStatus status = this.shardFailures[0].status();
        if (this.shardFailures.length > 1) {
            for (int i = 1; i < this.shardFailures.length; ++i) {
                if (this.shardFailures[i].status().getStatus() < 500) continue;
                status = this.shardFailures[i].status();
            }
        }
        return status;
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    public Throwable getCause() {
        OpenSearchException[] openSearchExceptionArray;
        int n;
        int n2;
        Throwable cause = super.getCause();
        if (cause == null && (n2 = 0) < (n = (openSearchExceptionArray = this.guessRootCauses()).length)) {
            OpenSearchException rootCause = openSearchExceptionArray[n2];
            return rootCause;
        }
        return cause;
    }

    private static String buildMessage(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to execute phase [").append(phaseName).append("], ").append(msg);
        if (!CollectionUtils.isEmpty((Object[])shardFailures)) {
            sb.append("; shardFailures ");
            for (ShardSearchFailure shardFailure : shardFailures) {
                if (shardFailure.shard() != null) {
                    sb.append("{").append(shardFailure.shard()).append(": ").append(shardFailure.reason()).append("}");
                    continue;
                }
                sb.append("{").append(shardFailure.reason()).append("}");
            }
        }
        return sb.toString();
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ShardOperationFailedException[] failures;
        builder.field("phase", this.phaseName);
        builder.field("grouped", true);
        builder.field("failed_shards");
        builder.startArray();
        for (ShardOperationFailedException failure : failures = ExceptionsHelper.groupBy((ShardOperationFailedException[])this.shardFailures)) {
            failure.toXContent(builder, params);
        }
        builder.endArray();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause((Throwable)((Object)this));
        if (ex != this) {
            OpenSearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)((Object)this));
        } else {
            OpenSearchException.innerToXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)((Object)this), (String)this.getExceptionName(), (String)this.getMessage(), (Map)this.getHeaders(), (Map)this.getMetadata(), (Throwable)super.getCause());
        }
        return builder;
    }

    public OpenSearchException[] guessRootCauses() {
        ShardOperationFailedException[] failures = ExceptionsHelper.groupBy((ShardOperationFailedException[])this.shardFailures);
        ArrayList<OpenSearchException> rootCauses = new ArrayList<OpenSearchException>(failures.length);
        for (ShardOperationFailedException failure : failures) {
            OpenSearchException[] guessRootCauses = OpenSearchException.guessRootCauses((Throwable)failure.getCause());
            rootCauses.addAll(Arrays.asList(guessRootCauses));
        }
        return rootCauses.toArray(new OpenSearchException[0]);
    }

    public String toString() {
        return SearchPhaseExecutionException.buildMessage(this.phaseName, this.getMessage(), this.shardFailures);
    }

    public String getPhaseName() {
        return this.phaseName;
    }
}

