/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClusterSearchShardsAction
extends TransportClusterManagerNodeReadAction<ClusterSearchShardsRequest, ClusterSearchShardsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportClusterSearchShardsAction(TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/shards/search_shards", transportService, clusterService, threadPool, actionFilters, ClusterSearchShardsRequest::new, indexNameExpressionResolver, true);
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterSearchShardsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected ClusterSearchShardsResponse read(StreamInput in) throws IOException {
        return new ClusterSearchShardsResponse(in);
    }

    @Override
    protected void clusterManagerOperation(ClusterSearchShardsRequest request, ClusterState state, ActionListener<ClusterSearchShardsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(state, request.routing(), request.indices());
        HashMap<String, AliasFilter> indicesAndFilters = new HashMap<String, AliasFilter>();
        Set<String> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, request.indices());
        for (String index : concreteIndices) {
            AliasFilter aliasFilter = this.indicesService.buildAliasFilter(clusterState, index, indicesAndAliases);
            String[] aliases = this.indexNameExpressionResolver.indexAliases(clusterState, index, aliasMetadata -> true, true, indicesAndAliases);
            indicesAndFilters.put(index, new AliasFilter(aliasFilter.getQueryBuilder(), aliases));
        }
        HashSet<String> nodeIds = new HashSet<String>();
        GroupShardsIterator<ShardIterator> groupShardsIterator = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference(), null, null, request.slice());
        ClusterSearchShardsGroup[] groupResponses = new ClusterSearchShardsGroup[groupShardsIterator.size()];
        int currentGroup = 0;
        for (ShardIterator shardIt : groupShardsIterator) {
            ShardRouting shard;
            ShardId shardId = shardIt.shardId();
            ShardRouting[] shardRoutings = new ShardRouting[shardIt.size()];
            int currentShard = 0;
            shardIt.reset();
            while ((shard = shardIt.nextOrNull()) != null) {
                shardRoutings[currentShard++] = shard;
                nodeIds.add(shard.currentNodeId());
            }
            groupResponses[currentGroup++] = new ClusterSearchShardsGroup(shardId, shardRoutings);
        }
        DiscoveryNode[] nodes = new DiscoveryNode[nodeIds.size()];
        int currentNode = 0;
        for (String nodeId : nodeIds) {
            nodes[currentNode++] = clusterState.getNodes().get(nodeId);
        }
        listener.onResponse((Object)new ClusterSearchShardsResponse(groupResponses, nodes, indicesAndFilters));
    }
}

