/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.document.DocumentField;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.common.helpers.SearchResponseUtil;

public class CollapseResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor {
    public static final String TYPE = "collapse";
    static final String COLLAPSE_FIELD = "field";
    private final String collapseField;

    private CollapseResponseProcessor(String tag, String description, boolean ignoreFailure, String collapseField) {
        super(tag, description, ignoreFailure);
        this.collapseField = Objects.requireNonNull(collapseField);
    }

    public String getType() {
        return TYPE;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) {
        if (response.getHits() != null) {
            if (response.getHits().getCollapseField() != null) {
                throw new IllegalStateException("Cannot collapse on " + this.collapseField + ". Results already collapsed on " + response.getHits().getCollapseField());
            }
            LinkedHashMap<String, SearchHit> collapsedHits = new LinkedHashMap<String, SearchHit>();
            ArrayList collapseValues = new ArrayList();
            for (SearchHit hit : response.getHits()) {
                String fieldValueString;
                Iterator<Object> fieldValue = null;
                DocumentField docField = (DocumentField)hit.getFields().get(this.collapseField);
                if (docField != null) {
                    if (docField.getValues().size() > 1) {
                        throw new IllegalStateException("Failed to collapse " + hit.getId() + ": doc has multiple values for field " + this.collapseField);
                    }
                    fieldValue = docField.getValues().get(0);
                } else if (hit.getSourceAsMap() != null) {
                    fieldValue = hit.getSourceAsMap().get(this.collapseField);
                }
                if (collapsedHits.containsKey(fieldValueString = fieldValue == null ? "__missing__" : fieldValue.toString())) continue;
                collapsedHits.put(fieldValueString, hit);
                collapseValues.add(fieldValue);
            }
            SearchHit[] newHits = new SearchHit[collapsedHits.size()];
            int i = 0;
            for (SearchHit collapsedHit : collapsedHits.values()) {
                newHits[i++] = collapsedHit;
            }
            SearchHits searchHits = new SearchHits(newHits, response.getHits().getTotalHits(), response.getHits().getMaxScore(), response.getHits().getSortFields(), this.collapseField, collapseValues.toArray());
            return SearchResponseUtil.replaceHits(searchHits, response);
        }
        return response;
    }

    static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public CollapseResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            String collapseField = ConfigurationUtils.readStringProperty((String)CollapseResponseProcessor.TYPE, (String)tag, config, (String)CollapseResponseProcessor.COLLAPSE_FIELD);
            return new CollapseResponseProcessor(tag, description, ignoreFailure, collapseField);
        }
    }
}

