/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.rest;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rule.action.UpdateRuleAction;
import org.opensearch.rule.action.UpdateRuleRequest;
import org.opensearch.rule.action.UpdateRuleResponse;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.Rule;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestUpdateRuleAction
extends BaseRestHandler {
    public String getName() {
        return "update_rule";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_rules/{featureType}/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        FeatureType featureType = FeatureType.from((String)request.param("featureType"));
        try (XContentParser parser = request.contentParser();){
            Rule.Builder builder = Rule.Builder.fromXContent((XContentParser)parser, (FeatureType)featureType);
            UpdateRuleRequest updateRuleRequest = new UpdateRuleRequest(request.param("id"), builder.getDescription(), builder.getAttributeMap(), builder.getFeatureValue(), featureType);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)UpdateRuleAction.INSTANCE, (ActionRequest)updateRuleRequest, this.updateRuleResponse((RestChannel)channel));
            return restChannelConsumer;
        }
    }

    private RestResponseListener<UpdateRuleResponse> updateRuleResponse(RestChannel channel) {
        return new RestResponseListener<UpdateRuleResponse>(this, channel){

            public RestResponse buildResponse(UpdateRuleResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

