/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.UTFUtility;

class OraCharsetEncoder
extends CharsetEncoder {
    private int maxBPC;

    OraCharsetEncoder(OraCharset oraCharset, float f, float f2, byte[] byArray) {
        super(oraCharset, f, f2, byArray);
        this.maxBPC = (int)Math.ceil(f2);
    }

    OraCharsetEncoder(OraCharset oraCharset, float f, float f2) {
        super(oraCharset, f, f2);
        this.maxBPC = (int)Math.ceil(f2);
    }

    @Override
    public CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        int n2 = charBuffer.position();
        int n3 = charBuffer.remaining();
        if (n3 == 0) {
            return CoderResult.UNDERFLOW;
        }
        boolean bl = false;
        if (n3 * this.maxBPC > byteBuffer.remaining()) {
            bl = true;
            if (byteBuffer.remaining() / this.maxBPC < 1) {
                return CoderResult.OVERFLOW;
            }
            n = UTFUtility.isHiSurrogate(charBuffer.charAt(byteBuffer.remaining() / this.maxBPC - 1)) && UTFUtility.isLoSurrogate(charBuffer.charAt(byteBuffer.remaining() / this.maxBPC)) ? byteBuffer.remaining() / this.maxBPC - 1 : byteBuffer.remaining() / this.maxBPC;
        } else {
            n = n3;
        }
        n = n < n3 ? n : n3;
        char[] cArray = new char[n];
        charBuffer.get(cArray);
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = CodingErrorAction.REPLACE == this.unmappableCharacterAction() ? ((OraCharset)this.charset()).convertWithReplacement(new String(cArray, 0, cArray.length)) : ((OraCharset)this.charset()).convert(new String(cArray, 0, cArray.length));
            if (byArray.length > byteBuffer.remaining()) {
                bl = true;
                charBuffer.position(n2);
                char[] cArray2 = new char[n - 2];
                charBuffer.get(cArray2);
                byte[] byArray3 = byArray = CodingErrorAction.REPLACE == this.unmappableCharacterAction() ? ((OraCharset)this.charset()).convertWithReplacement(new String(cArray2, 0, cArray2.length)) : ((OraCharset)this.charset()).convert(new String(cArray2, 0, cArray2.length));
            }
            if (bl) {
                byteBuffer.put(byArray);
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(byArray);
            return CoderResult.UNDERFLOW;
        }
        catch (SQLException sQLException) {
            charBuffer.position(n2);
            return CoderResult.unmappableForLength(n3);
        }
    }
}

