/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import oracle.ons.Notification;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequest;

final class RpcRequestImpl
implements RpcRequest {
    private String broadcastId;
    private String directSource;
    private String traceRoute;
    private String logicalAddress;
    private byte[] argsBytes;
    private Publisher publisher;
    private boolean finalResponseSent;

    RpcRequestImpl(String string, String string2, String string3, String string4, byte[] byArray, Publisher publisher) {
        this.broadcastId = string;
        this.directSource = string2;
        this.traceRoute = string3;
        this.logicalAddress = string4;
        this.argsBytes = byArray;
        this.publisher = publisher;
        this.finalResponseSent = false;
    }

    @Override
    public byte[] getArgBytes() {
        return this.argsBytes;
    }

    @Override
    public void sendResult(byte[] byArray, boolean bl) {
        boolean bl2 = true;
        this.sendResponse(byArray, bl2, bl);
    }

    @Override
    public void sendResponse(byte[] byArray, boolean bl, boolean bl2) {
        if (this.finalResponseSent) {
            return;
        }
        Notification notification = new Notification("ONS_RPC_RESPONSE", "", "", byArray);
        notification.put("ONSbroadcastID", this.broadcastId);
        notification.put("DirectRoute", this.directSource);
        notification.put("BackRoute", this.traceRoute);
        notification.put("DirectSource", this.logicalAddress);
        if (bl) {
            notification.putInternalProperty("Result", bl2 ? "success" : "failure");
            this.finalResponseSent = true;
        } else {
            notification.putInternalProperty("Result", "partial");
        }
        this.publisher.publish(notification);
    }

    boolean isDone() {
        return this.finalResponseSent;
    }
}

