/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;
import oracle.ons.WebSocket;

public class Message {
    protected boolean complete = false;
    protected ByteArrayOutputStream body = new ByteArrayOutputStream(0);
    private ByteArrayOutputStream header = new ByteArrayOutputStream(4096);
    private Writer builder = new OutputStreamWriter((OutputStream)this.header, ONSConfiguration.ONS_CHARSET);

    byte[] dump() {
        return this.header.toByteArray();
    }

    public Message(String string) {
        try {
            this.builder.append("POST").append(" /").append(string).append(" HTTP/1.1").append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message(Message message) {
        try {
            message.builder.flush();
            this.body.write(message.body.toByteArray());
            this.header.write(message.header.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message(NodeAddress nodeAddress) {
        try {
            this.builder.append("GET ons://");
            this.builder.append(nodeAddress.hostname);
            this.builder.append(":");
            this.builder.append(Integer.toString(nodeAddress.port));
            this.builder.append(" HTTP/1.1\r\n");
            this.builder.flush();
            nodeAddress.websocket.createKey(nodeAddress);
            this.put("Sec-WebSocket-Key", nodeAddress.websocket.key);
            this.put("Sec-WebSocket-Protocol", "ons");
            this.put("Sec-WebSocket-Version", "13");
            if (nodeAddress.websocket.subjectCN != null) {
                this.put("Ons-Proxy-Client-Id", nodeAddress.websocket.putString(nodeAddress.websocket.subjectCN));
            }
            this.put("Upgrade", "websocket");
            this.put("Connection", "Upgrade");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message put(String string, String string2) {
        try {
            this.builder.append(string).append(": ").append(string2).append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Message ready() {
        if (this.complete) {
            return this;
        }
        try {
            this.body.close();
            this.put(Notification.internalPropertyList[19], Integer.toString(this.body.size()));
            this.builder.append("\r\n").flush();
            this.builder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.complete = true;
        return this;
    }

    void send(OutputStream outputStream) throws IOException {
        this.ready();
        outputStream.write(this.header.toByteArray());
        outputStream.write(this.body.toByteArray());
    }

    void send(OutputStream outputStream, WebSocket webSocket) throws IOException {
        this.ready();
        webSocket.setMaskOut();
        byte[] byArray = this.header.toByteArray();
        byte[] byArray2 = this.body.toByteArray();
        int n = byArray.length + byArray2.length;
        byte[] byArray3 = webSocket.getFrame(n);
        outputStream.write(byArray3);
        webSocket.applyMaskOut(byArray);
        outputStream.write(byArray);
        if (byArray2.length != 0) {
            webSocket.applyMaskOut(byArray2);
            outputStream.write(byArray2);
        }
    }

    public OutputStream getBodyOutputStream() {
        return this.body;
    }

    public String toString() {
        return this.header.toString();
    }
}

