/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.util.HashMap;
import java.util.Map;

public enum EccCurveParameters {
    P192("p192", "secp192r1"),
    P224("p224", "secp224r1"),
    P256("p256", "secp256r1"),
    P384("p384", "secp384r1"),
    P521("p521", "secp521r1"),
    K163("k163", "sect163k1"),
    K233("k233", "sect233k1"),
    K283("k283", "sect283k1"),
    K409("k409", "sect409k1"),
    K571("k571", "sect571k1"),
    B163("b163", "sect163r2"),
    B233("b233", "sect233r1"),
    B283("b283", "sect283r1"),
    B409("b409", "sect409r1"),
    B571("b571", "sect571r1");

    private String a;
    private String b;
    private static final Map<String, EccCurveParameters> c;
    private static final Map<String, EccCurveParameters> d;

    private EccCurveParameters() {
    }

    private EccCurveParameters(String string2, String string3) {
        this.b = string2;
        this.a = string3;
    }

    public String getNistName() {
        return this.b;
    }

    public String getNickName() {
        return this.a;
    }

    public static EccCurveParameters get(String string) {
        return c.get(string);
    }

    public static EccCurveParameters getByNickName(String string) {
        return d.get(string);
    }

    public String toString() {
        return this.b;
    }

    static {
        c = new HashMap<String, EccCurveParameters>();
        d = new HashMap<String, EccCurveParameters>();
        for (EccCurveParameters eccCurveParameters : EccCurveParameters.values()) {
            c.put(eccCurveParameters.getNistName(), eccCurveParameters);
        }
        for (EccCurveParameters eccCurveParameters : EccCurveParameters.values()) {
            d.put(eccCurveParameters.getNickName(), eccCurveParameters);
        }
    }
}

