/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.Serializable;
import oracle.ucp.jdbc.oracle.RACAffinityContext;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.util.Util;

class OracleConnectionAffinityContext
implements Serializable,
Cloneable,
RACAffinityContext {
    private static final long serialVersionUID = 1554319099870773354L;
    public static String DEFAULT_VERSION_NUMBER = "1.0";
    public static String DEFAULT_SERVICE_NAME = null;
    public static String DEFAULT_DATATBASE_UNIQ_NAME = null;
    public static String DEFAULT_INSTANCE_NAME = null;
    public static String DEFAULT_CONNECTIONPOOL_ID = null;
    public static String DEFAULT_CONNECTION_ID = null;
    private String m_versionNumber = DEFAULT_VERSION_NUMBER;
    private String m_serviceName = DEFAULT_SERVICE_NAME;
    private String m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
    private String m_instanceName = DEFAULT_INSTANCE_NAME;
    private String m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
    private boolean m_isForInstanceAffinity = false;

    OracleConnectionAffinityContext() {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = DEFAULT_SERVICE_NAME;
        this.m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
        this.m_instanceName = DEFAULT_INSTANCE_NAME;
        this.m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
        this.m_isForInstanceAffinity = false;
    }

    OracleConnectionAffinityContext(OracleDatabaseInstanceInfo dbInfo, String poolName) {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = dbInfo.getServiceName();
        this.m_dbUniqName = dbInfo.getDatabaseName();
        this.m_instanceName = dbInfo.getInstanceName();
        this.m_connectionPoolID = poolName;
        this.m_isForInstanceAffinity = false;
    }

    public void setVersionNumber(String versionNumber) {
        this.m_versionNumber = versionNumber;
    }

    @Override
    public String getVersionNumber() {
        return this.m_versionNumber;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setDatabaseUniqueName(String dbUniqname) {
        this.m_dbUniqName = dbUniqname;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.m_dbUniqName;
    }

    public void setInstanceName(String instanceName) {
        this.m_instanceName = instanceName;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setConnectionPoolID(String poolID) {
        this.m_connectionPoolID = poolID;
    }

    public String getConnectionPoolID() {
        return this.m_connectionPoolID;
    }

    @Override
    public RACAffinityContext.AffinityType getAffinityType() {
        return this.isForInstanceAffinity() ? RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY : RACAffinityContext.AffinityType.WEBSESSION_BASED_AFFINITY;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OracleConnectionAffinityContext)) {
            return false;
        }
        OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)obj;
        return this.isForInstanceAffinity() == affinityContext.isForInstanceAffinity() && Util.sameOrEqual(this.m_connectionPoolID, affinityContext.getConnectionPoolID()) && Util.sameOrEqual(this.m_serviceName, affinityContext.getServiceName()) && Util.sameOrEqual(this.m_dbUniqName, affinityContext.getDatabaseUniqueName()) && Util.sameOrEqual(this.m_instanceName, affinityContext.getInstanceName());
    }

    public int hashCode() {
        String result = this.m_connectionPoolID + "##" + this.m_serviceName + "##" + this.m_instanceName + "##" + this.m_dbUniqName + "##" + this.m_isForInstanceAffinity;
        return result.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": versionNumber=" + this.m_versionNumber + ", isForInstanceAffinity=" + this.m_isForInstanceAffinity + ", connectionPoolID=" + this.m_connectionPoolID + ", instanceName=" + this.m_instanceName + ", dbUniqName=" + this.m_dbUniqName + ", serviceName=" + this.m_serviceName;
    }

    public Object clone() {
        OracleConnectionAffinityContext acopy = new OracleConnectionAffinityContext();
        acopy.setConnectionPoolID(this.m_connectionPoolID);
        acopy.setServiceName(this.m_serviceName);
        acopy.setDatabaseUniqueName(this.m_dbUniqName);
        acopy.setInstanceName(this.m_instanceName);
        acopy.setVersionNumber(this.m_versionNumber);
        acopy.setForInstanceAffinity(this.m_isForInstanceAffinity);
        return acopy;
    }

    void setForInstanceAffinity(boolean isForInstanceAffinity) {
        this.m_isForInstanceAffinity = isForInstanceAffinity;
    }

    boolean isForInstanceAffinity() {
        return this.m_isForInstanceAffinity;
    }
}

