/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.ANYDATA;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.xdb.XMLType;

public class OPAQUE
extends DatumWithConnection
implements oracle.jdbc.internal.OracleOpaque {
    OpaqueDescriptor descriptor;
    byte[] value;
    long imageOffset;
    long imageLength;
    private static final String CLASS_NAME = OPAQUE.class.getName();
    Object acProxy;

    public OPAQUE(OpaqueDescriptor type, Connection conn, Object value) throws SQLException {
        if (type == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "OPAQUE").fillInStackTrace();
        }
        this.descriptor = type;
        if (conn != null) {
            this.setPhysicalConnectionOf(conn);
        }
        if (value instanceof ANYDATA) {
            ANYDATA anydata = (ANYDATA)value;
            byte[] image = new byte[anydata.getImageSize()];
            anydata.pickle(image, 0);
            this.value = image;
        } else if (value instanceof byte[]) {
            this.value = (byte[])value;
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
        }
    }

    public OPAQUE(OpaqueDescriptor type, byte[] bytes, Connection conn) throws SQLException {
        super(bytes);
        this.setPhysicalConnectionOf(conn);
        this.descriptor = type;
        this.value = null;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getName();
    }

    @Override
    public String stringValue() throws SQLException {
        Object ret;
        block10: {
            ret = "OPAQUE";
            try {
                Method meth2;
                String retobj = null;
                Object obj = this.toJdbc();
                Class<?> cl = obj.getClass();
                if (cl.equals(this.getClass())) break block10;
                try {
                    meth2 = cl.getMethod("getStringVal", new Class[0]);
                    if (meth2.getDeclaringClass().isAssignableFrom(cl)) {
                        retobj = (String)meth2.invoke(obj, new Object[0]);
                    }
                }
                catch (Exception meth2) {
                    // empty catch block
                }
                if (retobj == null) {
                    try {
                        meth2 = cl.getMethod("stringValue", new Class[0]);
                        if (meth2.getDeclaringClass().isAssignableFrom(cl)) {
                            retobj = (String)meth2.invoke(obj, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (retobj != null) {
                    ret = (String)ret + "(" + retobj + ")";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public OpaqueDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(OpaqueDescriptor desc) {
        this.descriptor = desc;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        return this.descriptor.toBytes(this, false);
    }

    @Override
    public Object getValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    @Override
    public byte[] getBytesValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    @Override
    public void setValue(byte[] value) throws SQLException {
        this.value = value;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new Object[arraySize];
    }

    @Override
    public Map getMap() {
        try {
            return this.getInternalConnection().getTypeMap();
        }
        catch (SQLException ex) {
            return null;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    @Override
    public Object toJdbc(Map map) throws SQLException {
        Object jdbcObject = this;
        if (map != null) {
            Class c = this.descriptor.getClass(map);
            if (c != null) {
                jdbcObject = this.toClass(c, map);
            } else if (this.getSQLTypeName().compareTo("SYS.XMLTYPE") == 0) {
                return XMLType.createXML((OPAQUE)((OPAQUE)jdbcObject));
            }
        }
        return jdbcObject;
    }

    @Override
    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    @Override
    public Object toClass(Class clazz, Map map) throws SQLException {
        Object ret = null;
        try {
            if (clazz == null || clazz == OPAQUE.class || clazz == OracleOpaque.class || clazz == oracle.jdbc.internal.OracleOpaque.class) {
                ret = this;
            } else {
                Object obj = null;
                Object i = clazz.newInstance();
                if (i instanceof ORADataFactory) {
                    ORADataFactory f = (ORADataFactory)i;
                    obj = f.create(this, 2007);
                } else if (i instanceof OracleDataFactory) {
                    OracleDataFactory f = (OracleDataFactory)i;
                    obj = f.create(this, 2007);
                } else {
                    SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName()).fillInStackTrace();
                    CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "toClass", "OPAQUE.toClass: 'clazz' should be oracle.sql.OPAQUE or 'clazz' should have a constructor that takes an oracle.sql.OPAQUE or 'clazz' should implement ORADataFactory or 'clazz' should implement OracleDataFactory", null, sqlException);
                    throw sqlException;
                }
                ret = obj;
            }
        }
        catch (InstantiationException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage()).fillInStackTrace();
        }
        catch (IllegalAccessException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage()).fillInStackTrace();
        }
        return ret;
    }

    @Override
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        this.setShareBytes(image);
        this.imageOffset = offset;
        this.imageLength = length;
    }

    @Override
    public void setImageLength(long length) throws SQLException {
        this.imageLength = length;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

