/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

public class EnvVariableResolver {
    private static final boolean IS_WINDOWS_FILE_SYSTEM = File.separator.equals("\\");
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("(\\$\\{.*?\\})");
    public static final String TNS_ADMIN = "TNS_ADMIN";
    private static final List<Character> SUPPORTED_PRE_CHARS = IS_WINDOWS_FILE_SYSTEM ? Arrays.asList(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':')) : Arrays.asList(Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':'));

    public static String resolveEnvPlaceHolders(String inputString, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(inputString);
        StringBuffer outputBuffer = new StringBuffer();
        while (matcher.find()) {
            String key;
            String value;
            String match = matcher.group(1);
            if (match == null || match.length() < 4 || (value = EnvVariableResolver.getEnvValue(key = match.substring(2, match.length() - 1), userProps)) == null) continue;
            matcher.appendReplacement(outputBuffer, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(outputBuffer);
        return outputBuffer.toString();
    }

    public static String resolveFilePath(String filePath, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        if (EnvVariableResolver.checkIfFileExists(filePath)) {
            return filePath;
        }
        return new EnvKeyParser(filePath.toCharArray()).traverse(userProps);
    }

    private static boolean checkIfFileExists(String inputString) {
        File file = new File(inputString);
        return file.exists();
    }

    private static String getEnvValue(String envKey, @Blind(value=PropertiesBlinder.class) Properties userProps) {
        if (envKey.equalsIgnoreCase(TNS_ADMIN) && userProps.containsKey("oracle.net.tns_admin")) {
            return userProps.getProperty("oracle.net.tns_admin");
        }
        String returnValue = System.getProperty(envKey);
        if (returnValue == null) {
            try {
                returnValue = AccessController.doPrivileged(() -> System.getenv(envKey));
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return returnValue;
    }

    private static class EnvKeyParser {
        private final char[] input;
        private final StringBuilder outputBuffer;
        private int currentIndex = 0;

        private EnvKeyParser(char[] input) {
            this.input = input;
            this.outputBuffer = new StringBuilder();
        }

        public String traverse(@Blind(value=PropertiesBlinder.class) Properties userProp) {
            char prevChar = ' ';
            while (this.currentIndex < this.input.length) {
                switch (this.input[this.currentIndex]) {
                    case '$': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(prevChar))) {
                            this.lookForLinuxEnvReplacement(userProp);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    case '%': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(prevChar))) {
                            this.lookForWindowsEnvReplacement(userProp);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    default: {
                        this.outputBuffer.append(this.input[this.currentIndex]);
                    }
                }
                if (this.currentIndex < this.input.length && !Character.isWhitespace(this.input[this.currentIndex])) {
                    prevChar = this.input[this.currentIndex];
                }
                ++this.currentIndex;
            }
            return this.outputBuffer.toString();
        }

        private boolean lookForWindowsEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties userProps) {
            String keyStr;
            String keyVal;
            StringBuilder key = new StringBuilder();
            StringBuilder actualSeq = new StringBuilder();
            actualSeq.append(this.input[this.currentIndex]);
            boolean envTerminatorFound = false;
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                actualSeq.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '%') {
                    envTerminatorFound = true;
                    break;
                }
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    key.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if (envTerminatorFound && (keyVal = EnvVariableResolver.getEnvValue(keyStr = key.toString(), userProps)) != null) {
                this.outputBuffer.append(keyVal);
                return true;
            }
            this.outputBuffer.append(actualSeq.toString());
            return false;
        }

        private boolean lookForLinuxEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties userProps) {
            String keyStr;
            String keyVal;
            StringBuilder actualSeq = new StringBuilder();
            actualSeq.append(this.input[this.currentIndex]);
            StringBuilder key = new StringBuilder();
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                actualSeq.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '/') break;
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    key.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if ((keyVal = EnvVariableResolver.getEnvValue(keyStr = key.toString(), userProps)) != null) {
                this.outputBuffer.append(keyVal);
                if (this.currentIndex < this.input.length) {
                    this.outputBuffer.append(this.input[this.currentIndex]);
                }
                return true;
            }
            this.outputBuffer.append(actualSeq.toString());
            return false;
        }
    }
}

