/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class OracleMultiPhaseArgs
implements Diagnosable {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleMultiPhaseArgs() {
    }

    public OracleMultiPhaseArgs(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        if (_nsites <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "OracleMultiPhaseArgs", "(_, _nsites, _, _): _nsites <= 1", null, null);
        } else if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "OracleMultiPhaseArgs", "(_, _, _, _): invalid parameters", null, null);
        } else {
            this.action = _action;
            this.nsites = _nsites;
            this.xids = _xids;
            this.dbLinks = _dbLinks;
        }
    }

    public OracleMultiPhaseArgs(byte[] inBytes) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "OracleMultiPhaseArgs", "(inBytes.length = " + (inBytes == null ? 0 : inBytes.length) + ")", null, null);
        ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
        DataInputStream dataIS = new DataInputStream(byteArrayIS);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataIS.readInt();
            this.nsites = dataIS.readInt();
            int fmtid = dataIS.readInt();
            int gtridLen = dataIS.readInt();
            byte[] gtrid = new byte[gtridLen];
            int gtridRead = dataIS.read(gtrid, 0, gtridLen);
            for (int i = 0; i < this.nsites; ++i) {
                int bqualLen = dataIS.readInt();
                byte[] bqual = new byte[bqualLen];
                int bqualRead = dataIS.read(bqual, 0, bqualLen);
                this.xids.addElement(fmtid);
                this.xids.addElement(gtrid);
                this.xids.addElement(bqual);
                String dblink = dataIS.readUTF();
                this.dbLinks.addElement(dblink);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] gtridCommon = null;
        int fmtidCommon = 0;
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
        try {
            dataOS.writeInt(this.action);
            dataOS.writeInt(this.nsites);
            for (int i = 0; i < this.nsites; ++i) {
                String dblink = (String)this.dbLinks.elementAt(i);
                int fmtid = (Integer)this.xids.elementAt(i * 3);
                byte[] gtrid = (byte[])this.xids.elementAt(i * 3 + 1);
                byte[] bqual = (byte[])this.xids.elementAt(i * 3 + 2);
                if (i == 0) {
                    fmtidCommon = fmtid;
                    gtridCommon = gtrid;
                    dataOS.writeInt(fmtid);
                    dataOS.writeInt(gtrid.length);
                    dataOS.write(gtrid, 0, gtrid.length);
                }
                dataOS.writeInt(bqual.length);
                dataOS.write(bqual, 0, bqual.length);
                dataOS.writeUTF(dblink);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOS;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "-------printMPArgs entry-------", null, null);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  action = " + this.action, null, null);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  nsites = " + this.nsites, null, null);
        for (int i = 0; i < this.nsites; ++i) {
            String dblink = (String)this.dbLinks.elementAt(i);
            int fmtid = (Integer)this.xids.elementAt(i * 3);
            byte[] gtrid = (byte[])this.xids.elementAt(i * 3 + 1);
            byte[] bqual = (byte[])this.xids.elementAt(i * 3 + 2);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  fmtid  [" + i + "] = " + fmtid, null, null);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  gtrid  [" + i + "] = ", null, null);
            this.printByteArray(gtrid);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  bqual  [" + i + "] = ", null, null);
            this.printByteArray(bqual);
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "  dblink [" + i + "] = " + dblink, null, null);
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printMPArgs", "-------printMPArgs return-------", null, null);
    }

    private void printByteArray(byte[] bArray) {
        StringBuffer _buf = new StringBuffer();
        for (int i = 0; i < bArray.length; ++i) {
            _buf.append(bArray[i] + " ");
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleMultiPhaseArgs", "printByteArray", "         " + _buf.toString(), null, null);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

