/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.XSSessionParameters;

final class XSSessionParametersI
extends XSSessionParameters {
    byte[] binaryParam = null;
    String[] textParam = null;
    byte[][] textParamBytes;
    int intParam = 0;

    XSSessionParametersI() {
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        if (this.textParam != null && this.textParam.length > 0) {
            this.textParamBytes = new byte[this.textParam.length][];
            for (int i = 0; i < this.textParam.length; ++i) {
                this.textParamBytes[i] = conv.StringToCharBytes(this.textParam[i]);
            }
        } else {
            this.textParamBytes = null;
        }
    }

    @Override
    public void setBinary(byte[] binaryParam) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.binaryParam = (byte[])(binaryParam == null ? null : Arrays.copyOf(binaryParam, binaryParam.length));
    }

    @Override
    public void setInt(int intParam) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.intParam = intParam;
    }

    @Override
    public void setText(String[] textParam) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.textParam = textParam == null ? null : Arrays.copyOf(textParam, textParam.length);
    }
}

