/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

public class T4CTTIoclfeatures
extends T4CTTIfun {
    private static final int TOTAL_UB8_BITMAPS_COUNT = 4;
    private static final int UB8_SIZE = 64;
    private long[] ub8BitmapBuckets = new long[4];
    private int clientFeaturesCount = 0;

    T4CTTIoclfeatures(T4CConnection _conn) {
        super(_conn, (byte)17);
    }

    void add(OracleConnection.ClientFeature cf) {
        long bitMask;
        int ub8BucketIdx = cf.getFeatureId() / 64;
        if ((this.ub8BitmapBuckets[ub8BucketIdx] & (bitMask = 1L << cf.getFeatureId() % 64)) != 0L) {
            return;
        }
        int n = ub8BucketIdx;
        this.ub8BitmapBuckets[n] = this.ub8BitmapBuckets[n] | bitMask;
        ++this.clientFeaturesCount;
    }

    void doOCLFEATURES() throws IOException {
        if (this.clientFeaturesCount > 0) {
            this.setFunCode((short)191);
            this.doPigRPC();
            this.ub8BitmapBuckets = new long[4];
            this.clientFeaturesCount = 0;
        }
    }

    @Override
    void marshal() throws IOException {
        try {
            StringBuilder ub8BitmapsStringBuilder = new StringBuilder();
            for (int i = 0; i < this.ub8BitmapBuckets.length - 1; ++i) {
                ub8BitmapsStringBuilder.append(this.ub8BitmapBuckets[i] + ",");
            }
            ub8BitmapsStringBuilder.append(this.ub8BitmapBuckets[this.ub8BitmapBuckets.length - 1]);
            byte[] clientFeaturesAsByteArray = this.meg.conv.StringToCharBytes(ub8BitmapsStringBuilder.toString());
            this.meg.marshalPTR();
            this.meg.marshalSWORD(clientFeaturesAsByteArray.length);
            this.meg.marshalSB8(0L);
            this.meg.marshalCHR(clientFeaturesAsByteArray);
        }
        catch (SQLException sqlEx) {
            IOException ioEx = new IOException();
            ioEx.initCause(sqlEx.getCause());
            throw ioEx;
        }
    }
}

