/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public final class ChangedMaxLength
implements Changed {
    private final Integer oldValue;
    private final Integer newValue;
    private final DiffContext context;

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.oldValue, this.newValue)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isRequest() && (this.oldValue == null || this.newValue != null && this.newValue < this.oldValue) && BackwardIncompatibleProp.REQUEST_MAX_LENGTH_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.context.isResponse() && (this.newValue == null || this.oldValue != null && this.newValue > this.oldValue) && BackwardIncompatibleProp.RESPONSE_MAX_LENGTH_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public ChangedMaxLength(Integer oldValue, Integer newValue, DiffContext context) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.context = context;
    }

    public Integer getOldValue() {
        return this.oldValue;
    }

    public Integer getNewValue() {
        return this.newValue;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedMaxLength that = (ChangedMaxLength)o;
        return Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.oldValue, this.newValue, this.context);
    }

    public String toString() {
        return "ChangedMaxLength(oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", context=" + this.getContext() + ")";
    }
}

