/*
 * Decompiled with CFR 0.152.
 */
package j2html.utils;

import j2html.utils.EmptySelectorBodyException;
import j2html.utils.Selector;
import j2html.utils.UnbalancedBracesException;
import j2html.utils.UnterminatedCommentException;
import j2html.utils.UnterminatedSelectorException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Logger;

public class CSSMin {
    private static final Logger LOG = Logger.getLogger(CSSMin.class.getName());
    static boolean debugLogging = false;

    private CSSMin() {
    }

    public static String compressCss(String input) {
        try {
            String s2;
            BufferedReader br = new BufferedReader(new StringReader(input));
            StringBuilder sb = new StringBuilder();
            if (debugLogging) {
                LOG.info("Reading file into StringBuffer...");
            }
            while ((s2 = br.readLine()) != null) {
                if (s2.trim().equals("")) continue;
                sb.append(s2);
            }
            if (debugLogging) {
                LOG.info("Removing comments...");
            }
            int n = 0;
            while ((n = sb.indexOf("/*", n)) != -1) {
                if (sb.charAt(n + 2) == '*') {
                    n += 2;
                    continue;
                }
                int k = sb.indexOf("*/", n + 2);
                if (k == -1) {
                    throw new UnterminatedCommentException();
                }
                sb.delete(n, k + 2);
            }
            if (debugLogging) {
                LOG.info(sb.toString());
                LOG.info("\n\n");
            }
            if (debugLogging) {
                LOG.info("Parsing and processing selectors...");
            }
            Vector<Selector> selectors = new Vector<Selector>();
            n = 0;
            int j = 0;
            for (int i = 0; i < sb.length(); ++i) {
                block20: {
                    char curr = sb.charAt(i);
                    if (j < 0) {
                        throw new UnbalancedBracesException();
                    }
                    if (curr == '{') {
                        ++j;
                        continue;
                    }
                    if (curr != '}' || --j != 0) continue;
                    try {
                        selectors.addElement(new Selector(sb.substring(n, i + 1)));
                    }
                    catch (UnterminatedSelectorException usex) {
                        LOG.warning("Unterminated selector: " + usex.getMessage());
                    }
                    catch (EmptySelectorBodyException ebex) {
                        if (!debugLogging) break block20;
                        LOG.warning("Empty selector body: " + ebex.getMessage());
                    }
                }
                n = i + 1;
            }
            StringBuilder result = new StringBuilder();
            for (Selector selector : selectors) {
                result.append(selector);
            }
            if (debugLogging) {
                LOG.info("Process completed successfully.");
            }
            return result.toString();
        }
        catch (UnterminatedCommentException ucex) {
            LOG.warning("Unterminated comment.");
        }
        catch (UnbalancedBracesException ubex) {
            LOG.warning("Unbalanced braces.");
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
        return null;
    }
}

