# This file gives a template to start a new analyser.
package MyAnalyser;

use strict;

# An analyser is a subclass of Lire::DlfAnalyser
use base qw/Lire::DlfAnalyser/;

# You'll use objects of this type to get the records to analyse.
# Consult its man page for more information.
use Lire::DlfQuery;

# The constructor. The constructor can be called anything. It isn't
# used by the Lire framework. You'll instantiate the analyser
# yourself in the registration script.
sub new {
    return bless {}, shift;
}

########################################################################
#                          METADATA METHODS
#
# The following methods are used to provide information about your
# converter to the Lire framework.
#
########################################################################

# Returns the name of the analyser.
sub name {
    return "myanalyser";
}

# The analyser's title
sub title {
    return "My Analyser Title";
}

# The analyser's description
sub description {
    return '<para>A DocBook description of my analyser.</para>';

}

# This method should returns the name of the DLF schema for which
# records are analysed.
sub src_schema {
    return "my-src_schema";
}

# This method should returns the name of the DLF schema that is
# written to.
sub dst_schema {
    return "my-derived_schema";
}

########################################################################
#                          PROCESSING METHODS
#
# The analyse method is called once. It should the read DLF records in
# the DlfStore available from $process->dlf_store(). It writes
# records by using the write_dlf method on the $process parameter.
#
# Consult the Lire::DlfAnalyserProcess man page for more information.
sub analyse {
    my ( $self, $process, $config ) = @_;

    my $query = new Lire::DlfQuery( 'my-src_schema' );
    foreach my $field ( qw/dlf_id time some_field some_other_field/) {
        $query->add_field( $field );
    }
    # We specify the ordering of the returned records. This can be
    # used to simplify many algorithms
    $query->set_sort_spec( 'time some_field' );

    # This will make sure we only analyse the DLF records which
    # were imported or created by another analyser.
    #
    # It is possible for the source_filter to be empty when we should
    # analyse the complete stream.
    my $filter = $process->source_filter();
    $query->set_filter_clause( $filter->sql_expr(), @{$filter->sql_params()} )
      if defined $filter;

    # This will return a cursor from which we can
    # retrieve the DLF records.
    my $result = $query->execute( $process->dlf_store() );
    while ( defined( my $dlf = $result->next_row() ) ) {

        eval {
            # We analyse the DLF records here
            # ...
            # ...

            # We eventually create new dlf records
            my $new_dlf = { };

            # We can link the derived records to the one to which
            # they are related
            my $dlf_ids = [];
            push @$dlf_ids, $dlf->{'dlf_id'};

            # When we are ready we write new records like
            # this
            $process->write_dlf( $new_dlf, $dlf_ids );
        };
        # We can report error like this:
        $process->error( $@ ) if $@;
    }

    return;
}

1;
