// This file is part of libigl, a simple c++ geometry processing library.
//
// Copyright (C) 2020 Oded Stein <oded.stein@columbia.edu>
//
// This Source Code Form is subject to the terms of the Mozilla Public License
// v. 2.0. If a copy of the MPL was not distributed with this file, You can
// obtain one at http://mozilla.org/MPL/2.0/.
#ifndef IGL_AVERAGE_FROM_EDGES_ONTO_VERTICES_H
#define IGL_AVERAGE_FROM_EDGES_ONTO_VERTICES_H
#include "igl_inline.h"

#include <Eigen/Dense>
namespace igl
{
  /// Move a scalar field defined on edges to vertices by averaging
  ///
  /// @param[in] F #F by 3 triangle mesh connectivity
  /// @param[in] E #F by 3 mapping from each halfedge to each edge
  /// @param[in] oE #F by 3 orientation as generated by orient_halfedges
  /// @param[in] uE #uE by 1 list of scalars
  /// @param[out] uV #V by 1 list of  scalar defined on vertices
  ///
  /// \see orient_halfedges
  template<typename DerivedF,typename DerivedE,typename DerivedoE,
  typename DeriveduE,typename DeriveduV>
  IGL_INLINE void average_from_edges_onto_vertices(
    const Eigen::MatrixBase<DerivedF> &F,
    const Eigen::MatrixBase<DerivedE> &E,
    const Eigen::MatrixBase<DerivedoE> &oE,
    const Eigen::MatrixBase<DeriveduE> &uE,
    Eigen::PlainObjectBase<DeriveduV> &uV);
}

#ifndef IGL_STATIC_LIBRARY
#  include "average_from_edges_onto_vertices.cpp"
#endif

#endif
