/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.MessageDigest;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;

class RawSaltedSimpleDigestPassword
extends RawPassword
implements SaltedSimpleDigestPassword {
    private static final long serialVersionUID = -7933794700841833594L;
    private final byte[] digest;
    private final byte[] salt;

    RawSaltedSimpleDigestPassword(String algorithm, byte[] digest, byte[] salt) {
        super(algorithm);
        this.digest = digest;
        this.salt = salt;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public RawSaltedSimpleDigestPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.digest), (int)Arrays.hashCode(this.salt)), (int)this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawSaltedSimpleDigestPassword)) {
            return false;
        }
        RawSaltedSimpleDigestPassword other = (RawSaltedSimpleDigestPassword)obj;
        return this.getAlgorithm().equals(other.getAlgorithm()) && MessageDigest.isEqual(this.digest, other.digest) && Arrays.equals(this.salt, other.salt);
    }
}

